/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;

public final class Region
extends Resource {
    public int handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = OS.gdk_region_new();
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    Region(Device device, int handle) {
        this.device = device;
        this.handle = handle;
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        int polyRgn = OS.gdk_region_polygon(pointArray, pointArray.length / 2, 0);
        OS.gdk_region_union(this.handle, polyRgn);
        OS.gdk_region_destroy(polyRgn);
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.add(rect.x, rect.y, rect.width, rect.height);
    }

    public void add(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRect = new GdkRectangle();
        gdkRect.x = x;
        gdkRect.y = y;
        gdkRect.width = width;
        gdkRect.height = height;
        OS.gdk_region_union_with_rect(this.handle, gdkRect);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_union(this.handle, region.handle);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.gdk_region_point_in(this.handle, x, y);
    }

    public boolean contains(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.gdk_region_destroy(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        GdkRectangle gdkRect = new GdkRectangle();
        OS.gdk_region_get_clipbox(this.handle, gdkRect);
        return new Rectangle(gdkRect.x, gdkRect.y, gdkRect.width, gdkRect.height);
    }

    public static Region gtk_new(Device device, int handle) {
        return new Region(device, handle);
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.intersect(rect.x, rect.y, rect.width, rect.height);
    }

    public void intersect(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRect = new GdkRectangle();
        gdkRect.x = x;
        gdkRect.y = y;
        gdkRect.width = width;
        gdkRect.height = height;
        int rectRgn = OS.gdk_region_rectangle(gdkRect);
        OS.gdk_region_intersect(this.handle, rectRgn);
        OS.gdk_region_destroy(rectRgn);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_intersect(this.handle, region.handle);
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        GdkRectangle gdkRect = new GdkRectangle();
        gdkRect.x = x;
        gdkRect.y = y;
        gdkRect.width = width;
        gdkRect.height = height;
        return OS.gdk_region_rect_in(this.handle, gdkRect) != 1;
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.gdk_region_empty(this.handle);
    }

    public void subtract(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        int polyRgn = OS.gdk_region_polygon(pointArray, pointArray.length / 2, 0);
        OS.gdk_region_subtract(this.handle, polyRgn);
        OS.gdk_region_destroy(polyRgn);
    }

    public void subtract(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.subtract(rect.x, rect.y, rect.width, rect.height);
    }

    public void subtract(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRect = new GdkRectangle();
        gdkRect.x = x;
        gdkRect.y = y;
        gdkRect.width = width;
        gdkRect.height = height;
        int rectRgn = OS.gdk_region_rectangle(gdkRect);
        OS.gdk_region_subtract(this.handle, rectRgn);
        OS.gdk_region_destroy(rectRgn);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_subtract(this.handle, region.handle);
    }

    public void translate(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.gdk_region_offset(this.handle, x, y);
    }

    public void translate(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        this.translate(pt.x, pt.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

