/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.sourcelookup;

import java.text.MessageFormat;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.debug.core.sourcelookup.PHPSourceNotFoundInput;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class PHPSourceNotFoundEditorInput
extends PlatformObject
implements IEditorInput {
    private IStackFrame fFrame;
    private String fFrameText;

    public PHPSourceNotFoundEditorInput(PHPSourceNotFoundInput pHPSourceNotFoundInput) {
        this.fFrame = pHPSourceNotFoundInput.getStackFrame();
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation((String)this.fFrame.getModelIdentifier());
        this.fFrameText = iDebugModelPresentation.getText((Object)this.fFrame);
        iDebugModelPresentation.dispose();
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugUITools.getDefaultImageDescriptor((Object)this.fFrame);
    }

    public String getName() {
        try {
            return this.fFrame.getName();
        }
        catch (DebugException debugException) {
            return PHPDebugUIMessages.SourceNotFoundEditorInput_Source_Not_Found_1;
        }
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return MessageFormat.format(PHPDebugUIMessages.SourceNotFoundEditorInput_Source_not_found_for__0__2, this.fFrameText);
    }
}

