/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.protocol.bundleentry.Handler;
import org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BaseData
implements BundleData {
    private long id;
    private BaseAdaptor adaptor;
    private Bundle bundle;
    private int startLevel = -1;
    private int status = 0;
    private StorageHook[] storageHooks;
    private String location;
    private long lastModified;
    protected BundleFile bundleFile;
    private boolean dirty = false;
    protected Dictionary manifest;
    protected String fileName;
    private String symbolicName;
    private Version version;
    private String activator;
    private String classpath;
    private String executionEnvironment;
    private String dynamicImports;
    private int type;

    public BaseData(long id, BaseAdaptor adaptor) {
        this.id = id;
        this.adaptor = adaptor;
    }

    public BundleClassLoader createClassLoader(ClassLoaderDelegate delegate, BundleProtectionDomain domain, String[] bundleclasspath) {
        ClassLoadingHook[] hooks = this.adaptor.getHookRegistry().getClassLoadingHooks();
        ClassLoader parent = this.adaptor.getBundleClassLoaderParent();
        BaseClassLoader cl = null;
        int i = 0;
        while (i < hooks.length && cl == null) {
            cl = hooks[i].createClassLoader(parent, delegate, domain, this, bundleclasspath);
            ++i;
        }
        if (cl == null) {
            cl = new DefaultClassLoader(parent, delegate, domain, this, bundleclasspath);
        }
        return cl;
    }

    public final URL getEntry(String path) {
        BundleEntry entry = this.getBundleFile().getEntry(path);
        if (entry == null) {
            return null;
        }
        if (path.length() == 0 || path.charAt(0) != '/') {
            path = String.valueOf('/') + path;
        }
        try {
            return new URL("bundleentry", Long.toString(this.id), 0, path, new Handler(entry));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public final Enumeration getEntryPaths(String path) {
        return this.getBundleFile().getEntryPaths(path);
    }

    public String findLibrary(String libname) {
        ClassLoadingHook[] hooks = this.adaptor.getHookRegistry().getClassLoadingHooks();
        String result = null;
        int i = 0;
        while (i < hooks.length) {
            result = hooks[i].findLibrary(this, libname);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    public void installNativeCode(String[] nativepaths) throws BundleException {
        this.adaptor.getStorage().installNativeCode(this, nativepaths);
    }

    public File getDataFile(String path) {
        return this.adaptor.getStorage().getDataFile(this, path);
    }

    public Dictionary getManifest() throws BundleException {
        if (this.manifest == null) {
            this.manifest = this.adaptor.getStorage().loadManifest(this);
        }
        return this.manifest;
    }

    public long getBundleID() {
        return this.id;
    }

    public final String getLocation() {
        return this.location;
    }

    public final void setLocation(String location) {
        this.location = location;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    public final void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void close() throws IOException {
        if (this.bundleFile != null) {
            this.getBundleFile().close();
        }
    }

    public void open() throws IOException {
        this.getBundleFile().open();
    }

    public final void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public final Bundle getBundle() {
        return this.bundle;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStartLevel(int value) {
        this.startLevel = this.setPersistentData(value, true, this.startLevel);
    }

    public void setStatus(int value) {
        this.status = this.setPersistentData(value, false, this.status);
    }

    private int setPersistentData(int value, boolean isStartLevel, int orig) {
        StorageHook[] hooks = this.getStorageHooks();
        int i = 0;
        while (i < hooks.length) {
            if (isStartLevel ? hooks[i].forgetStartLevelChange(value) : hooks[i].forgetStatusChange(value)) {
                return value;
            }
            ++i;
        }
        if (value != orig) {
            this.dirty = true;
        }
        return value;
    }

    public void save() throws IOException {
        this.adaptor.getStorage().save(this);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public final String getSymbolicName() {
        return this.symbolicName;
    }

    public final void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public final Version getVersion() {
        return this.version;
    }

    public final void setVersion(Version version) {
        this.version = version;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int type) {
        this.type = type;
    }

    public final String[] getClassPath() throws BundleException {
        ManifestElement[] classpathElements = ManifestElement.parseHeader("Bundle-ClassPath", this.classpath);
        return BaseData.getClassPath(classpathElements);
    }

    public String getClassPathString() {
        return this.classpath;
    }

    public void setClassPathString(String classpath) {
        this.classpath = classpath;
    }

    public final String getActivator() {
        return this.activator;
    }

    public final void setActivator(String activator) {
        this.activator = activator;
    }

    public final String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setExecutionEnvironment(String executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public final String getDynamicImports() {
        return this.dynamicImports;
    }

    public void setDynamicImports(String dynamicImports) {
        this.dynamicImports = dynamicImports;
    }

    public final boolean matchDNChain(String pattern) {
        StorageHook[] hooks = this.getStorageHooks();
        int i = 0;
        while (i < hooks.length) {
            if (hooks[i].matchDNChain(pattern)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final BaseAdaptor getAdaptor() {
        return this.adaptor;
    }

    public synchronized BundleFile getBundleFile() throws IllegalArgumentException {
        if (this.bundleFile == null) {
            try {
                this.bundleFile = this.adaptor.createBundleFile(null, this);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return this.bundleFile;
    }

    private static String[] getClassPath(ManifestElement[] classpath) {
        if (classpath == null) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  no classpath");
            }
            return new String[]{"."};
        }
        ArrayList<String> result = new ArrayList<String>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  found classpath entry " + classpath[i].getValueComponents());
            }
            String[] paths = classpath[i].getValueComponents();
            int j = 0;
            while (j < paths.length) {
                result.add(paths[j]);
                ++j;
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public StorageHook getStorageHook(String key) {
        if (this.storageHooks == null) {
            return null;
        }
        int i = 0;
        while (i < this.storageHooks.length) {
            if (this.storageHooks[i].getKey().equals(key)) {
                return this.storageHooks[i];
            }
            ++i;
        }
        return null;
    }

    public void setStorageHooks(StorageHook[] storageHooks) {
        if (this.storageHooks != null) {
            return;
        }
        this.storageHooks = storageHooks;
    }

    public StorageHook[] getStorageHooks() {
        return this.storageHooks == null ? new StorageHook[]{} : this.storageHooks;
    }

    public File getExtractFile(String path) {
        return this.adaptor.getStorage().getExtractFile(this, path);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String toString() {
        String name = this.getSymbolicName();
        if (name == null) {
            return this.getLocation();
        }
        Version ver = this.getVersion();
        if (ver == null) {
            return name;
        }
        return String.valueOf(name) + "_" + ver;
    }
}

