/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.actions.ActionMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.MoveAction;
import org.eclipse.php.internal.ui.actions.RenameAction;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.Page;

public class RefactorActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.php.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    private IWorkbenchSite fSite;
    private PHPStructuredEditor fEditor;
    private String fGroupName = "group.reorganize";
    private SelectionDispatchAction fMoveAction;
    private SelectionDispatchAction fRenameAction;
    private UndoRedoActionGroup fUndoRedoActionGroup;
    private List fEditorActions;
    private IKeyBindingService fKeyBindingService;
    private Action fNoActionAvailable = new NoActionAvailable();
    static /* synthetic */ Class class$0;

    public RefactorActionGroup(IViewPart iViewPart) {
        this((IWorkbenchSite)iViewPart.getSite(), iViewPart.getSite().getKeyBindingService());
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IUndoContext iUndoContext = (IUndoContext)iWorkspace.getAdapter((Class)clazz);
        this.fUndoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)iViewPart.getViewSite(), iUndoContext, true);
    }

    public RefactorActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite(), null);
    }

    public RefactorActionGroup(PHPStructuredEditor pHPStructuredEditor, String string) {
        this.fSite = pHPStructuredEditor.getEditorPart().getEditorSite();
        this.fEditor = pHPStructuredEditor;
        this.fGroupName = string;
        ISelectionProvider iSelectionProvider = pHPStructuredEditor.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.fEditorActions = new ArrayList();
        this.fRenameAction = new RenameAction(pHPStructuredEditor);
        this.fRenameAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.rename.element");
        this.fRenameAction.update(iSelection);
        pHPStructuredEditor.setAction("RenameElement", (IAction)this.fRenameAction);
        this.fEditorActions.add(this.fRenameAction);
        this.fMoveAction = new MoveAction(pHPStructuredEditor);
        this.fMoveAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.move.element");
        this.fMoveAction.update(iSelection);
        pHPStructuredEditor.setAction("MoveElement", (IAction)this.fMoveAction);
        this.fEditorActions.add(this.fMoveAction);
        this.fKeyBindingService = pHPStructuredEditor.getEditorSite().getKeyBindingService();
    }

    private RefactorActionGroup(IWorkbenchSite iWorkbenchSite, IKeyBindingService iKeyBindingService) {
        this.fSite = iWorkbenchSite;
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.fMoveAction = new MoveAction(iWorkbenchSite);
        this.fMoveAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.move.element");
        RefactorActionGroup.initAction(this.fMoveAction, iSelectionProvider, iSelection);
        this.fRenameAction = new RenameAction(iWorkbenchSite);
        this.fRenameAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.rename.element");
        RefactorActionGroup.initAction(this.fRenameAction, iSelectionProvider, iSelection);
        this.fKeyBindingService = iKeyBindingService;
    }

    private static void initAction(SelectionDispatchAction selectionDispatchAction, ISelectionProvider iSelectionProvider, ISelection iSelection) {
        selectionDispatchAction.update(iSelection);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)selectionDispatchAction);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        iActionBars.setGlobalActionHandler("org.eclipse.php.ui.actions.Move", (IAction)this.fMoveAction);
        iActionBars.setGlobalActionHandler("org.eclipse.php.ui.actions.Rename", (IAction)this.fRenameAction);
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.fillActionBars(iActionBars);
        }
    }

    public void retargetFileMenuActions(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
        iActionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.fMoveAction);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.addRefactorSubmenu(iMenuManager);
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        this.disposeAction(this.fMoveAction, iSelectionProvider);
        this.disposeAction(this.fRenameAction, iSelectionProvider);
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.dispose();
        }
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener iSelectionChangedListener, ISelectionProvider iSelectionProvider) {
        if (iSelectionChangedListener != null) {
            iSelectionProvider.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }

    private void addRefactorSubmenu(IMenuManager iMenuManager) {
        String string = ActionMessages.RefactorMenu_label;
        MenuManager menuManager = new MenuManager(string, MENU_ID);
        if (this.fEditor != null) {
            PHPFileData pHPFileData = SelectionConverter.getInput(this.fEditor);
            if (pHPFileData != null && ActionUtils.isPHPSource((PHPCodeData)pHPFileData)) {
                menuManager.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager iMenuManager) {
                        RefactorActionGroup.this.refactorMenuShown(iMenuManager);
                    }
                });
                menuManager.add((IAction)this.fNoActionAvailable);
                iMenuManager.appendToGroup(this.fGroupName, (IContributionItem)menuManager);
            }
        } else if (this.fillRefactorMenu((IMenuManager)menuManager) > 0) {
            iMenuManager.appendToGroup(this.fGroupName, (IContributionItem)menuManager);
        }
    }

    private int fillRefactorMenu(IMenuManager iMenuManager) {
        int n = 0;
        iMenuManager.add((IContributionItem)new Separator(GROUP_REORG));
        n += this.addAction(iMenuManager, (IAction)this.fRenameAction);
        iMenuManager.add((IContributionItem)new Separator(GROUP_TYPE));
        iMenuManager.add((IContributionItem)new Separator(GROUP_CODING));
        return n += this.addAction(iMenuManager, (IAction)this.fMoveAction);
    }

    private int addAction(IMenuManager iMenuManager, IAction iAction) {
        if (iAction != null && iAction.isEnabled()) {
            iMenuManager.add(iAction);
            return 1;
        }
        return 0;
    }

    private void refactorMenuShown(final IMenuManager iMenuManager) {
        Menu menu = ((MenuManager)iMenuManager).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent menuEvent) {
                RefactorActionGroup.this.refactorMenuHidden(iMenuManager);
            }
        });
        ITextSelection iTextSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        Iterator iterator = this.fEditorActions.iterator();
        while (iterator.hasNext()) {
            SelectionDispatchAction selectionDispatchAction = (SelectionDispatchAction)((Object)iterator.next());
            selectionDispatchAction.update((ISelection)iTextSelection);
        }
        iMenuManager.removeAll();
        if (this.fillRefactorMenu(iMenuManager) == 0) {
            iMenuManager.add((IAction)this.fNoActionAvailable);
        }
    }

    private void refactorMenuHidden(IMenuManager iMenuManager) {
        ITextSelection iTextSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        Iterator iterator = this.fEditorActions.iterator();
        while (iterator.hasNext()) {
            SelectionDispatchAction selectionDispatchAction = (SelectionDispatchAction)((Object)iterator.next());
            selectionDispatchAction.update((ISelection)iTextSelection);
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText(ActionMessages.RefactorActionGroup_no_refactoring_available);
        }
    }
}

