/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.php.core.format.FormatterUtils;
import org.eclipse.wst.html.ui.internal.text.HTMLDocumentRegionEdgeMatcher;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class MatchingCharAutoEditStrategy
implements IAutoEditStrategy {
    protected static final char CURLY_OPEN = '{';
    protected static final char CURLY_CLOSE = '}';
    protected static final char ROUND_OPEN = '(';
    protected static final char ROUND_CLOSE = ')';
    protected static final char SQUARE_OPEN = '[';
    protected static final char SQUARE_CLOSE = ']';
    protected static final char SINGLE_QOUTE = '\'';
    protected static final char DOUBLE_QOUTES = '\"';
    protected static final char BACK_QOUTE = '`';
    protected static final char BACK_SLASH = '\\';
    protected static final int SEARCH_NOT_VALID = -1;
    protected static final int MATCHING_BRACKET_NEEDED = 0;
    protected static final int MATCHING_BRACKET_NOT_NEEDED = 1;
    protected static HTMLDocumentRegionEdgeMatcher matcher = new HTMLDocumentRegionEdgeMatcher();

    protected boolean isClosingBracket(char c) {
        return c == ')' || c == ']' || c == '}';
    }

    protected boolean isQuote(char c) {
        return c == '\'' || c == '\"' || c == '`';
    }

    protected static char getMatchingChar(char c) {
        switch (c) {
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': 
            case '\'': 
            case '`': {
                return c;
            }
        }
        return '-';
    }

    protected boolean shouldAddClosingBracket(IStructuredDocument iStructuredDocument, int n, boolean bl) throws BadLocationException {
        if (iStructuredDocument.getLength() == n) {
            return true;
        }
        char c = iStructuredDocument.getChar(n);
        if (Character.isWhitespace(c) || this.isClosingBracket(c) || bl && this.isQuote(c) || c == ';') {
            return true;
        }
        if (n + 1 >= iStructuredDocument.getLength()) {
            return false;
        }
        char c2 = iStructuredDocument.getChar(n + 1);
        String string = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)n);
        if (string == "org.eclipse.php.PHP_DEFAULT" || string == "PHP_OPENTAG" || string == "PHP_CLOSETAG") {
            if (c == '?' && c2 == '>') {
                return true;
            }
            if (c == '<' && c2 == '<') {
                int n2 = n + 2;
                while (n2 < iStructuredDocument.getLength()) {
                    char c3 = iStructuredDocument.getChar(n2);
                    if (Character.isWhitespace(c3)) {
                        if (n2 + 1 != iStructuredDocument.getLength()) break;
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return c == '/' && (c2 == '/' || c2 == '*');
    }

    protected static boolean isSpecialOpenCurlyInQuotes(IStructuredDocument iStructuredDocument, int n) throws BadLocationException {
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        if (iStructuredDocumentRegion == null) {
            return false;
        }
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion.getType() != "PHP_ENCAPSED_AND_WHITESPACE") {
            return false;
        }
        char c = iStructuredDocument.getChar(iStructuredDocumentRegion.getStartOffset() + iTextRegion.getStart());
        if (c != '\"' && c != '`') {
            return false;
        }
        char c2 = iStructuredDocument.getChar(n + 1);
        return c2 == '$';
    }
}

