/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.php.internal.ui.util.CustomHashtable;
import org.eclipse.php.internal.ui.util.TreePath;

public class MultiElementSelection
extends StructuredSelection {
    private static final TreePath[] EMPTY_TREE_PATHS = new TreePath[0];
    private TreePath[] fAllTreePaths;
    private CustomHashtable fElement2TreePaths;

    public MultiElementSelection(StructuredViewer structuredViewer, List list, TreePath[] treePathArray) {
        super(list);
        this.fAllTreePaths = treePathArray;
        this.fElement2TreePaths = this.createTreePathMap(structuredViewer.getComparer());
    }

    public TreePath[] getAllTreePaths() {
        return this.fAllTreePaths;
    }

    public TreePath[] getTreePaths(Object object) {
        Object object2 = this.fElement2TreePaths.get(object);
        if (object2 == null) {
            return EMPTY_TREE_PATHS;
        }
        if (object2 instanceof TreePath) {
            return new TreePath[]{(TreePath)object2};
        }
        if (object2 instanceof List) {
            List list = (List)object2;
            return list.toArray(new TreePath[list.size()]);
        }
        Assert.isTrue((boolean)false, (String)"Should not happen");
        return null;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().getName().equals(object.getClass().getName())) {
            return false;
        }
        MultiElementSelection multiElementSelection = (MultiElementSelection)((Object)object);
        if (this.fAllTreePaths.length != multiElementSelection.fAllTreePaths.length) {
            return false;
        }
        int n = 0;
        while (n < this.fAllTreePaths.length) {
            if (!this.fAllTreePaths[n].equals(multiElementSelection.fAllTreePaths[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private CustomHashtable createTreePathMap(IElementComparer iElementComparer) {
        CustomHashtable customHashtable = new CustomHashtable(iElementComparer);
        int n = 0;
        while (n < this.fAllTreePaths.length) {
            TreePath treePath = this.fAllTreePaths[n];
            Object object = treePath.getLastSegment();
            if (object != null) {
                Object object2 = customHashtable.get(object);
                if (object2 == null) {
                    customHashtable.put(object, treePath);
                } else if (object2 instanceof TreePath) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(object2);
                    arrayList.add(treePath);
                    customHashtable.put(object, arrayList);
                } else if (object2 instanceof List) {
                    ((List)object2).add(treePath);
                } else {
                    Assert.isTrue((boolean)false, (String)"Should not happen");
                }
            }
            ++n;
        }
        return customHashtable;
    }
}

