/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.core.project.IIncludePathEntry;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.includepath.EditVariableEntryDialog;
import org.eclipse.php.ui.preferences.includepath.IncludePathContainerWizard;
import org.eclipse.php.ui.preferences.includepath.MultipleFolderSelectionDialog;
import org.eclipse.php.ui.preferences.includepath.NewVariableEntryDialog;
import org.eclipse.php.ui.preferences.includepath.TypedElementSelectionValidator;
import org.eclipse.php.ui.preferences.includepath.ZipFileFilter;
import org.eclipse.php.ui.util.TypedViewerFilter;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public final class IncludePathDialogAccess {
    public static final String DIALOGSTORE_LASTEXTZIP = "org.eclipse.php.ui.lastextzip";
    public static final String DIALOGSTORE_LASTZIPATTACH = "org.eclipse.php.ui.lastzipattach";
    public static final String DIALOGSTORE_LASTVARIABLE = "org.eclipse.php.ui.lastvariable";
    public static final String DIALOGSTORE_LASTINCLUDEFOLDER = "org.eclipse.php.ui.lastincludefolder";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private IncludePathDialogAccess() {
    }

    public static IPath configureVariableEntry(Shell shell, IPath iPath, IPath[] iPathArray) {
        if (iPathArray == null) {
            throw new IllegalArgumentException();
        }
        EditVariableEntryDialog editVariableEntryDialog = new EditVariableEntryDialog(shell, iPath, iPathArray);
        if (editVariableEntryDialog.open() == 0) {
            return editVariableEntryDialog.getPath();
        }
        return null;
    }

    public static IPath[] chooseVariableEntries(Shell shell, IPath[] iPathArray) {
        if (iPathArray == null) {
            throw new IllegalArgumentException();
        }
        NewVariableEntryDialog newVariableEntryDialog = new NewVariableEntryDialog(shell);
        if (newVariableEntryDialog.open() == 0) {
            return newVariableEntryDialog.getResult();
        }
        return null;
    }

    public static IIncludePathEntry configureContainerEntry(Shell shell, IIncludePathEntry iIncludePathEntry, IProject iProject, IIncludePathEntry[] iIncludePathEntryArray) {
        IIncludePathEntry[] iIncludePathEntryArray2;
        if (iIncludePathEntry == null || iIncludePathEntryArray == null) {
            throw new IllegalArgumentException();
        }
        IncludePathContainerWizard includePathContainerWizard = new IncludePathContainerWizard(iIncludePathEntry, iProject, iIncludePathEntryArray);
        if (IncludePathContainerWizard.openWizard(shell, includePathContainerWizard) == 0 && (iIncludePathEntryArray2 = includePathContainerWizard.getNewEntries()) != null && iIncludePathEntryArray2.length == 1) {
            return iIncludePathEntryArray2[0];
        }
        return null;
    }

    public static IIncludePathEntry[] chooseContainerEntries(Shell shell, IProject iProject, IIncludePathEntry[] iIncludePathEntryArray) {
        if (iIncludePathEntryArray == null) {
            throw new IllegalArgumentException();
        }
        IncludePathContainerWizard includePathContainerWizard = new IncludePathContainerWizard(null, iProject, iIncludePathEntryArray);
        if (IncludePathContainerWizard.openWizard(shell, includePathContainerWizard) == 0) {
            return includePathContainerWizard.getNewEntries();
        }
        return null;
    }

    public static IPath configureZIPEntry(Shell shell, IPath iPath, IPath[] iPathArray) {
        IResource iResource;
        IPath iPath2;
        if (iPath == null || iPathArray == null) {
            throw new IllegalArgumentException();
        }
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, false);
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iPathArray.length);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int n = 0;
        while (n < iPathArray.length) {
            iPath2 = iPathArray[n];
            if (!iPath2.equals((Object)iPath) && (iResource = iWorkspaceRoot.findMember(iPathArray[n])) instanceof IFile) {
                arrayList.add(iResource);
            }
            ++n;
        }
        IResource iResource2 = iWorkspaceRoot.findMember(iPath);
        iPath2 = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        iPath2.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        iPath2.setTitle(PHPUIMessages.IncludePathDialogAccess_ZIPArchiveDialog_edit_title);
        iPath2.setMessage(PHPUIMessages.IncludePathDialogAccess_ZIPArchiveDialog_edit_description);
        iPath2.addFilter((ViewerFilter)new ZipFileFilter(arrayList, true));
        iPath2.setInput((Object)iWorkspaceRoot);
        iPath2.setSorter((ViewerSorter)new ResourceSorter(1));
        iPath2.setInitialSelection((Object)iResource2);
        if (iPath2.open() == 0) {
            iResource = (IResource)iPath2.getFirstResult();
            return iResource.getFullPath();
        }
        return null;
    }

    public static IPath[] chooseZIPEntries(Shell shell, IPath iPath, IPath[] iPathArray) {
        IResource iResource;
        if (iPathArray == null) {
            throw new IllegalArgumentException();
        }
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, true);
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iPathArray.length);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int n = 0;
        while (n < iPathArray.length) {
            iResource = iWorkspaceRoot.findMember(iPathArray[n]);
            if (iResource instanceof IFile) {
                arrayList.add(iResource);
            }
            ++n;
        }
        IResource iResource2 = iPath != null ? iWorkspaceRoot.findMember(iPath) : null;
        iResource = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        iResource.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        iResource.setTitle(PHPUIMessages.IncludePathDialogAccess_ZIPArchiveDialog_new_title);
        iResource.setMessage(PHPUIMessages.IncludePathDialogAccess_ZIPArchiveDialog_new_description);
        iResource.addFilter((ViewerFilter)new ZipFileFilter(arrayList, true));
        iResource.setInput((Object)iWorkspaceRoot);
        iResource.setSorter((ViewerSorter)new ResourceSorter(1));
        iResource.setInitialSelection((Object)iResource2);
        if (iResource.open() == 0) {
            Object[] objectArray = iResource.getResult();
            IPath[] iPathArray2 = new IPath[objectArray.length];
            int n2 = 0;
            while (n2 < iPathArray2.length) {
                IResource iResource3 = (IResource)objectArray[n2];
                iPathArray2[n2] = iResource3.getFullPath();
                ++n2;
            }
            return iPathArray2;
        }
        return null;
    }

    public static IPath[] chooseIncludePathFoldersEntries(Shell shell) {
        String string = PHPUiPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LASTINCLUDEFOLDER);
        if (string == null) {
            string = "";
        }
        DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4);
        directoryDialog.setText(PHPUIMessages.IncludePathDialogAccess_IncludePathFolderDialog_new_title);
        directoryDialog.setMessage(PHPUIMessages.IncludePathDialogAccess_IncludePathFolderDialog_new_description);
        directoryDialog.setFilterPath(string);
        String string2 = directoryDialog.open();
        if (string2 == null) {
            return null;
        }
        IPath iPath = new Path(string2).makeAbsolute();
        PHPUiPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LASTINCLUDEFOLDER, iPath.removeLastSegments(1).toOSString());
        return new IPath[]{iPath};
    }

    public static IPath configureIncludePathFolderEntry(Shell shell, IPath iPath) {
        if (iPath == null) {
            throw new IllegalArgumentException();
        }
        String string = iPath.removeLastSegments(1).toOSString();
        DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4);
        directoryDialog.setText(PHPUIMessages.IncludePathDialogAccess_0);
        directoryDialog.setFilterPath(string);
        String string2 = directoryDialog.open();
        if (string2 == null) {
            return null;
        }
        IPath iPath2 = new Path(string2).makeAbsolute();
        PHPUiPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LASTINCLUDEFOLDER, iPath2.removeLastSegments(1).toOSString());
        return iPath2;
    }

    public static IPath configureExternalZIPEntry(Shell shell, IPath iPath) {
        if (iPath == null) {
            throw new IllegalArgumentException();
        }
        String string = iPath.removeLastSegments(1).toOSString();
        FileDialog fileDialog = new FileDialog(shell, 4);
        fileDialog.setText(PHPUIMessages.IncludePathDialogAccess_ExtZIPArchiveDialog_edit_title);
        fileDialog.setFilterExtensions(ZipFileFilter.FILTER_EXTENSIONS);
        fileDialog.setFilterPath(string);
        fileDialog.setFileName(iPath.lastSegment());
        String string2 = fileDialog.open();
        if (string2 == null) {
            return null;
        }
        PHPUiPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LASTEXTZIP, fileDialog.getFilterPath());
        return Path.fromOSString((String)string2).makeAbsolute();
    }

    public static IPath[] chooseExternalZIPEntries(Shell shell) {
        String string = PHPUiPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LASTEXTZIP);
        if (string == null) {
            string = "";
        }
        FileDialog fileDialog = new FileDialog(shell, 2);
        fileDialog.setText(PHPUIMessages.IncludePathDialogAccess_ExtZIPArchiveDialog_new_title);
        fileDialog.setFilterExtensions(ZipFileFilter.FILTER_EXTENSIONS);
        fileDialog.setFilterPath(string);
        String string2 = fileDialog.open();
        if (string2 == null) {
            return null;
        }
        String[] stringArray = fileDialog.getFileNames();
        int n = stringArray.length;
        IPath iPath = Path.fromOSString((String)fileDialog.getFilterPath());
        IPath[] iPathArray = new IPath[n];
        int n2 = 0;
        while (n2 < n) {
            iPathArray[n2] = iPath.append(stringArray[n2]).makeAbsolute();
            ++n2;
        }
        PHPUiPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LASTEXTZIP, fileDialog.getFilterPath());
        return iPathArray;
    }

    public static IPath[] chooseFolderEntries(Shell shell, IPath iPath, IPath[] iPathArray) {
        if (iPathArray == null) {
            throw new IllegalArgumentException();
        }
        String string = PHPUIMessages.IncludePathDialogAccess_ExistingPHPFolderDialog_new_title;
        String string2 = PHPUIMessages.IncludePathDialogAccess_ExistingPHPFolderDialog_new_description;
        return IncludePathDialogAccess.internalChooseFolderEntry(shell, iPath, iPathArray, string, string2);
    }

    public static IPath[] chooseSourceFolderEntries(Shell shell, IPath iPath, IPath[] iPathArray) {
        if (iPathArray == null) {
            throw new IllegalArgumentException();
        }
        String string = PHPUIMessages.IncludePathDialogAccess_ExistingSourceFolderDialog_new_title;
        String string2 = PHPUIMessages.IncludePathDialogAccess_ExistingSourceFolderDialog_new_description;
        return IncludePathDialogAccess.internalChooseFolderEntry(shell, iPath, iPathArray, string, string2);
    }

    private static IPath[] internalChooseFolderEntry(Shell shell, IPath iPath, IPath[] iPathArray, String string, String string2) {
        Object[] objectArray;
        Class[] classArray = new Class[2];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(iPathArray.length);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int n = 0;
        while (n < iPathArray.length) {
            objectArray = iWorkspaceRoot.findMember(iPathArray[n]);
            if (objectArray instanceof IContainer) {
                arrayList.add(objectArray);
            }
            ++n;
        }
        IResource iResource = iPath != null ? iWorkspaceRoot.findMember(iPath) : null;
        objectArray = arrayList.toArray();
        MultipleFolderSelectionDialog multipleFolderSelectionDialog = new MultipleFolderSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        multipleFolderSelectionDialog.setExisting(objectArray);
        multipleFolderSelectionDialog.setTitle(string);
        multipleFolderSelectionDialog.setMessage(string2);
        multipleFolderSelectionDialog.addFilter(new TypedViewerFilter(classArray2, objectArray));
        multipleFolderSelectionDialog.setInput(iWorkspaceRoot);
        multipleFolderSelectionDialog.setInitialFocus(iResource);
        if (multipleFolderSelectionDialog.open() == 0) {
            Object[] objectArray2 = multipleFolderSelectionDialog.getResult();
            IPath[] iPathArray2 = new IPath[objectArray2.length];
            int n2 = 0;
            while (n2 < iPathArray2.length) {
                IResource iResource2 = (IResource)objectArray2[n2];
                iPathArray2[n2] = iResource2.getFullPath();
                ++n2;
            }
            return iPathArray2;
        }
        return null;
    }
}

