/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.Logger;
import org.eclipse.php.core.containers.LocalFileStorage;
import org.eclipse.php.core.containers.ZipEntryStorage;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.containers.LocalFileStorageEditorInput;
import org.eclipse.php.ui.containers.ZipEntryStorageEditorInput;
import org.eclipse.php.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorUtility {
    static /* synthetic */ Class class$0;

    public static boolean isEditorInput(Object object, IEditorPart iEditorPart) {
        if (iEditorPart != null) {
            return iEditorPart.getEditorInput().equals(EditorUtility.getEditorInput(object));
        }
        return false;
    }

    public static IEditorPart isOpenInEditor(Object object) {
        IWorkbenchPage iWorkbenchPage;
        IEditorInput iEditorInput = null;
        iEditorInput = EditorUtility.getEditorInput(object);
        if (iEditorInput != null && (iWorkbenchPage = PHPUiPlugin.getActivePage()) != null) {
            return iWorkbenchPage.findEditor(iEditorInput);
        }
        return null;
    }

    public static void openInEditor(String string, int n) throws CoreException {
        Path path;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        IFile iFile = iWorkspaceRoot.getFile((IPath)(path = new Path(string)));
        if (iFile == null) {
            iFile = iWorkspaceRoot.getFileForLocation((IPath)path);
        }
        IMarker iMarker = iFile.createMarker("org.eclipse.core.resources.textmarker");
        iMarker.setAttribute("lineNumber", n);
        IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
        if (iWorkbenchPage != null) {
            IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IMarker)iMarker);
        }
        iMarker.delete();
    }

    public static IEditorPart openInEditor(Object object) throws PartInitException {
        return EditorUtility.openInEditor(object, true);
    }

    public static IEditorPart openInEditor(Object object, boolean bl) throws PartInitException {
        if (object instanceof IFile) {
            return EditorUtility.openInEditor((IFile)object, bl);
        }
        IEditorInput iEditorInput = EditorUtility.getEditorInput(object);
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            return EditorUtility.openInEditor(iFileEditorInput.getFile(), bl);
        }
        if (iEditorInput != null) {
            return EditorUtility.openInEditor(iEditorInput, EditorUtility.getEditorID(iEditorInput), bl);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart iEditorPart, PHPCodeData pHPCodeData) {
        UserData userData;
        if (pHPCodeData == null) {
            return;
        }
        if (iEditorPart instanceof PHPStructuredEditor) {
            ((PHPStructuredEditor)iEditorPart).setSelection(pHPCodeData, true);
            return;
        }
        int n = -1;
        int n2 = 0;
        if (pHPCodeData instanceof PHPCodeData && (userData = pHPCodeData.getUserData()) != null) {
            n = userData.getStartPosition();
            n2 = userData.getEndPosition() - userData.getStartPosition() + 1;
        }
        if (n >= 0) {
            EditorUtility.revealInEditor(iEditorPart, n, n2);
        }
    }

    public static void revealInEditor(IEditorPart iEditorPart, IRegion iRegion) {
        if (iEditorPart != null && iRegion != null) {
            EditorUtility.revealInEditor(iEditorPart, iRegion.getOffset(), iRegion.getLength());
        }
    }

    public static void revealInEditor(IEditorPart iEditorPart, final int n, final int n2) {
        if (iEditorPart instanceof ITextEditor) {
            ((ITextEditor)iEditorPart).selectAndReveal(n, n2);
            return;
        }
        if (iEditorPart instanceof IGotoMarker) {
            final IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                final IGotoMarker iGotoMarker = (IGotoMarker)iEditorPart;
                WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                    /*
                     * Exception decompiling
                     */
                    protected void execute(IProgressMonitor var1_1) throws CoreException {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 85->89)] java.lang.Throwable
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                };
                try {
                    workspaceModifyOperation.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
        if (iEditorPart != null && iEditorPart.getEditorSite().getSelectionProvider() != null) {
            IEditorSite iEditorSite = iEditorPart.getEditorSite();
            if (iEditorSite == null) {
                return;
            }
            ISelectionProvider iSelectionProvider = iEditorPart.getEditorSite().getSelectionProvider();
            if (iSelectionProvider == null) {
                return;
            }
            iSelectionProvider.setSelection((ISelection)new TextSelection(n, n2));
        }
    }

    public static IEditorPart openInEditor(IFile iFile, boolean bl) throws PartInitException {
        IWorkbenchPage iWorkbenchPage;
        if (iFile != null && (iWorkbenchPage = PHPUiPlugin.getActivePage()) != null) {
            IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)bl);
            EditorUtility.initializeHighlightRange(iEditorPart);
            return iEditorPart;
        }
        return null;
    }

    private static IEditorPart openInEditor(IEditorInput iEditorInput, String string, boolean bl) throws PartInitException {
        IWorkbenchPage iWorkbenchPage;
        if (iEditorInput != null && (iWorkbenchPage = PHPUiPlugin.getActivePage()) != null) {
            IEditorPart iEditorPart = iWorkbenchPage.openEditor(iEditorInput, string, bl);
            EditorUtility.initializeHighlightRange(iEditorPart);
            return iEditorPart;
        }
        return null;
    }

    private static void initializeHighlightRange(IEditorPart iEditorPart) {
        if (iEditorPart instanceof ITextEditor) {
            IAction iAction = iEditorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean bl = iAction != null;
            boolean bl2 = bl = bl && iAction.isEnabled() && iAction.isChecked();
            if (bl) {
                if (iAction instanceof TextEditorAction) {
                    ((TextEditorAction)iAction).setEditor(null);
                    ((TextEditorAction)iAction).setEditor((ITextEditor)iEditorPart);
                } else {
                    iAction.run();
                    iAction.run();
                }
            }
        }
    }

    public static String getEditorID(IEditorInput iEditorInput) {
        IEditorDescriptor iEditorDescriptor;
        try {
            String string;
            File file;
            LocalFileStorageEditorInput localFileStorageEditorInput;
            LocalFileStorage localFileStorage;
            if (iEditorInput instanceof LocalFileStorageEditorInput && (localFileStorage = (LocalFileStorage)(localFileStorageEditorInput = (LocalFileStorageEditorInput)iEditorInput).getStorage()) != null && (file = localFileStorage.getFile()) != null && (string = EditorUtility.getEditorId(file)) != null) {
                return string;
            }
            iEditorDescriptor = IDE.getEditorDescriptor((String)iEditorInput.getName());
        }
        catch (PartInitException partInitException) {
            return null;
        }
        if (iEditorDescriptor != null) {
            return iEditorDescriptor.getId();
        }
        return null;
    }

    private static String getEditorId(File file) {
        IWorkbench iWorkbench = PHPUiPlugin.getDefault().getWorkbench();
        IEditorRegistry iEditorRegistry = iWorkbench.getEditorRegistry();
        IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(file.getName(), EditorUtility.getContentType(file));
        if (iEditorDescriptor != null) {
            return iEditorDescriptor.getId();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IContentType getContentType(File file) {
        IContentType iContentType;
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                iContentType = Platform.getContentTypeManager().findContentTypeFor((InputStream)fileInputStream, file.getName());
                Object var3_3 = null;
            }
            catch (IOException iOException) {
                Logger.logException(iOException);
                Object var3_4 = null;
                try {
                    if (fileInputStream == null) return null;
                    ((InputStream)fileInputStream).close();
                    return null;
                }
                catch (IOException iOException3) {
                    Logger.logException(iOException3);
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {}
            catch (IOException iOException2) {
                Logger.logException(iOException2);
                throw throwable;
            }
            if (fileInputStream == null) throw throwable;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            Logger.logException(iOException);
            return iContentType;
        }
        if (fileInputStream == null) return iContentType;
        ((InputStream)fileInputStream).close();
        return iContentType;
    }

    private static IEditorInput getEditorInput(PHPCodeData pHPCodeData, IProject iProject, String string) {
        IResource iResource = PHPModelUtil.getResource((Object)pHPCodeData);
        if (iResource == null || !iResource.exists() || !iResource.getProject().equals((Object)iProject)) {
            Object object = PHPModelUtil.getExternalResource((Object)pHPCodeData, (IProject)iProject);
            if (object instanceof File) {
                LocalFileStorage localFileStorage = new LocalFileStorage((File)object);
                localFileStorage.setProject(iProject);
                localFileStorage.setIncBaseDirName(string);
                return new LocalFileStorageEditorInput(localFileStorage);
            }
            if (object instanceof ZipFile) {
                return EditorUtility.createZipEntryStorageEditorInput((ZipFile)object, pHPCodeData, iProject);
            }
        }
        if (iResource instanceof IFile) {
            return new FileEditorInput((IFile)iResource);
        }
        return null;
    }

    private static ZipEntryStorageEditorInput createZipEntryStorageEditorInput(ZipFile zipFile, PHPCodeData pHPCodeData, IProject iProject) {
        ZipEntry zipEntry;
        block5: {
            ZipInputStream zipInputStream = null;
            zipEntry = null;
            File file = new File(zipFile.getName());
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            zipEntry = zipInputStream.getNextEntry();
            PHPFileData pHPFileData = null;
            pHPFileData = pHPCodeData instanceof PHPFileData ? (PHPFileData)pHPCodeData : PHPModelUtil.getPHPFileContainer((PHPCodeData)pHPCodeData);
            String string = pHPFileData.getName();
            string = string.substring(string.indexOf(File.separatorChar) + 1);
            while (zipEntry != null && !zipEntry.getName().equals(string)) {
                zipEntry = zipInputStream.getNextEntry();
            }
            if (zipEntry != null) break block5;
            return null;
        }
        try {
            ZipEntryStorage zipEntryStorage = new ZipEntryStorage(zipFile, zipEntry);
            zipEntryStorage.setProject(iProject);
            return new ZipEntryStorageEditorInput(zipEntryStorage);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.logException(fileNotFoundException);
            return null;
        }
        catch (IOException iOException) {
            Logger.logException(iOException);
            return null;
        }
    }

    public static IEditorInput getEditorInput(Object object) {
        IProject iProject = null;
        if (object instanceof TreeItem) {
            iProject = EditorUtility.getProject((TreeItem)object);
            String string = EditorUtility.getIncludeDirectory((TreeItem)object);
            return EditorUtility.getEditorInput((PHPCodeData)((TreeItem)object).getData(), iProject, string);
        }
        if (object instanceof PHPCodeData) {
            return EditorUtility.getEditorInput((PHPCodeData)object, null, null);
        }
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        return null;
    }

    private static String getIncludeDirectory(TreeItem treeItem) {
        if (!(treeItem.getData() instanceof PHPCodeData)) {
            return null;
        }
        PHPCodeData pHPCodeData = (PHPCodeData)treeItem.getData();
        while (pHPCodeData != null && !(pHPCodeData instanceof PHPFileData)) {
            pHPCodeData = pHPCodeData.getContainer();
            treeItem = treeItem.getParentItem();
        }
        while (treeItem != null && !(treeItem.getData() instanceof PHPIncludePathModel)) {
            treeItem = treeItem.getParentItem();
        }
        if (treeItem == null) {
            return null;
        }
        return treeItem.getText();
    }

    private static IProject getProject(TreeItem treeItem) {
        if (!(treeItem.getData() instanceof PHPCodeData)) {
            return null;
        }
        PHPCodeData pHPCodeData = (PHPCodeData)treeItem.getData();
        while (pHPCodeData != null && !(pHPCodeData instanceof PHPFileData)) {
            pHPCodeData = pHPCodeData.getContainer();
            treeItem = treeItem.getParentItem();
        }
        while (treeItem != null && !(treeItem.getData() instanceof IProject)) {
            treeItem = treeItem.getParentItem();
        }
        if (treeItem == null) {
            return null;
        }
        return (IProject)treeItem.getData();
    }

    public static PHPCodeData getActiveEditorPHPInput() {
        IEditorInput iEditorInput;
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null && (iEditorInput = iEditorPart.getEditorInput()) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.php.core.phpModel.phpElementData.PHPCodeData");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (PHPCodeData)iEditorInput.getAdapter((Class)clazz);
        }
        return null;
    }

    public static PHPProjectModel getPHPProject(IEditorInput iEditorInput) {
        IProject iProject;
        if (iEditorInput instanceof IFileEditorInput && (iProject = ((IFileEditorInput)iEditorInput).getFile().getProject()) != null) {
            return PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        }
        return null;
    }

    public static int findLocalizedModifier(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int n) {
        String string = "";
        if ((n & 0x40000) == 262144) {
            string = EditorUtility.appendModifierString(string, 262144);
        }
        if ((n & 0x10000) == 65536) {
            string = EditorUtility.appendModifierString(string, 65536);
        }
        if ((n & 0x20000) == 131072) {
            string = EditorUtility.appendModifierString(string, 131072);
        }
        if ((n & 0x400000) == 0x400000) {
            string = EditorUtility.appendModifierString(string, 0x400000);
        }
        return string;
    }

    private static String appendModifierString(String string, int n) {
        if (string == null) {
            string = "";
        }
        String string2 = Action.findModifierString((int)n);
        if (string.length() == 0) {
            return string2;
        }
        return MessageFormat.format(PHPUIMessages.EditorUtility_concatModifierStrings, string, string2);
    }
}

