/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design.editparts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.directedit.ComboBoxCellEditorManager;
import org.eclipse.wst.xsd.ui.internal.adt.design.directedit.ElementReferenceDirectEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.design.directedit.LabelCellEditorLocator;
import org.eclipse.wst.xsd.ui.internal.adt.design.directedit.LabelEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.design.directedit.TypeReferenceDirectEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseTypeConnectingEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.CenteredConnectionAnchor;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ColumnEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.INamedEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.TypeReferenceConnection;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.FocusTypeColumn;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.ADTDirectEditPolicy;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.ADTSelectionFeedbackEditPolicy;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.IADTUpdateCommand;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.IFieldFigure;
import org.eclipse.wst.xsd.ui.internal.adt.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IField;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IType;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.GraphNodeDragTracker;
import org.eclipse.xsd.XSDNamedComponent;

public class BaseFieldEditPart
extends BaseTypeConnectingEditPart
implements INamedEditPart {
    protected TypeReferenceConnection connectionFigure;
    protected ADTDirectEditPolicy adtDirectEditPolicy = new ADTDirectEditPolicy();
    protected TypeUpdateCommand typeUpdateCommand = new TypeUpdateCommand();
    protected ElementReferenceUpdateCommand elementUpdateCommand = new ElementReferenceUpdateCommand();
    protected TypeReferenceConnection connectionFeedbackFigure;

    protected IFigure createFigure() {
        IFieldFigure figure = this.getFigureFactory().createFieldFigure(this.getModel());
        figure.setForegroundColor(ColorConstants.black);
        return figure;
    }

    public IFieldFigure getFieldFigure() {
        return (IFieldFigure)this.figure;
    }

    protected boolean shouldDrawConnection() {
        boolean result = false;
        EditPart parent = this.getParent();
        while (parent != null) {
            if (parent.getModel() instanceof FocusTypeColumn) {
                result = true;
                break;
            }
            parent = parent.getParent();
        }
        return result;
    }

    private EditPart getTargetEditPart(IType type) {
        ColumnEditPart columnEditPart = null;
        BaseFieldEditPart editPart = this;
        while (editPart != null) {
            if (editPart instanceof ColumnEditPart) {
                columnEditPart = (ColumnEditPart)((Object)editPart);
                break;
            }
            editPart = editPart.getParent();
        }
        if (columnEditPart != null) {
            EditPart parent = columnEditPart.getParent();
            List columns = parent.getChildren();
            int index = columns.indexOf(columnEditPart);
            if (columns.size() > index) {
                EditPart nextColumn = (EditPart)columns.get(index + 1);
                Iterator i = nextColumn.getChildren().iterator();
                while (i.hasNext()) {
                    EditPart child = (EditPart)i.next();
                    if (child.getModel() != type) continue;
                    return child;
                }
            }
        }
        return null;
    }

    public TypeReferenceConnection createConnectionFigure() {
        AbstractGraphicalEditPart referenceTypePart;
        this.connectionFigure = null;
        IField field = (IField)this.getModel();
        IType type = field.getType();
        if (type != null && (referenceTypePart = (AbstractGraphicalEditPart)this.getTargetEditPart(type)) != null) {
            this.connectionFigure = new TypeReferenceConnection();
            if (this.getFigure().getParent() == referenceTypePart.getFigure()) {
                this.connectionFigure.setSourceAnchor((ConnectionAnchor)new CenteredConnectionAnchor(this.getFigure(), 2, 1));
            } else {
                this.connectionFigure.setSourceAnchor((ConnectionAnchor)new CenteredConnectionAnchor(this.getFigure(), 3, 5));
            }
            int targetAnchorYOffset = 8;
            this.connectionFigure.setTargetAnchor((ConnectionAnchor)new CenteredConnectionAnchor(referenceTypePart.getFigure(), 4, 0, targetAnchorYOffset));
            this.connectionFigure.setHighlight(false);
        }
        return this.connectionFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.adtDirectEditPolicy);
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ADTSelectionFeedbackEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IFieldFigure figure = this.getFieldFigure();
        IField field = (IField)this.getModel();
        figure.getNameLabel().setText(field.getName());
        figure.getTypeLabel().setText(field.getTypeName());
        figure.refreshVisuals(this.getModel());
        figure.recomputeLayout();
        ((GraphicalEditPart)this.getRoot()).getFigure().invalidateTree();
    }

    public DragTracker getDragTracker(Request request) {
        return new GraphNodeDragTracker((EditPart)this);
    }

    public Label getNameLabelFigure() {
        return this.getFieldFigure().getNameLabel();
    }

    public void performDirectEdit(Point cursorLocation) {
    }

    public void performRequest(Request request) {
        if (((IADTObject)this.getModel()).isReadOnly()) {
            return;
        }
        if (request.getType() == "direct edit" || request.getType() == "open") {
            IFieldFigure fieldFigure = this.getFieldFigure();
            Object model = this.getModel();
            if (request instanceof LocationRequest) {
                LocationRequest locationRequest = (LocationRequest)request;
                Point p = locationRequest.getLocation();
                if (this.hitTest((IFigure)fieldFigure.getTypeLabel(), p)) {
                    TypeReferenceDirectEditManager manager = new TypeReferenceDirectEditManager((IField)model, this, fieldFigure.getTypeLabel());
                    this.typeUpdateCommand.setDelegate(manager);
                    this.adtDirectEditPolicy.setUpdateCommand(this.typeUpdateCommand);
                    manager.show();
                } else if (this.hitTest((IFigure)fieldFigure.getNameLabel(), p) && model instanceof IField) {
                    IField field = (IField)model;
                    if (field.isReference()) {
                        ElementReferenceDirectEditManager manager = new ElementReferenceDirectEditManager((IField)model, this, fieldFigure.getNameLabel());
                        this.elementUpdateCommand.setDelegate(manager);
                        this.adtDirectEditPolicy.setUpdateCommand(this.elementUpdateCommand);
                        manager.show();
                    } else {
                        LabelEditManager manager = new LabelEditManager((GraphicalEditPart)this, new LabelCellEditorLocator(this, p));
                        NameUpdateCommandWrapper wrapper = new NameUpdateCommandWrapper();
                        this.adtDirectEditPolicy.setUpdateCommand(wrapper);
                        manager.show();
                    }
                }
            }
        }
    }

    public void doEditName(boolean addFromDesign) {
        if (!addFromDesign) {
            return;
        }
        Notifier object = ((XSDBaseAdapter)this.getModel()).getTarget();
        if (object instanceof XSDNamedComponent) {
            Point p = this.getNameLabelFigure().getLocation();
            LabelEditManager manager = new LabelEditManager((GraphicalEditPart)this, new LabelCellEditorLocator(this, p));
            NameUpdateCommandWrapper wrapper = new NameUpdateCommandWrapper();
            this.adtDirectEditPolicy.setUpdateCommand(wrapper);
            manager.show();
        }
    }

    public void addFeedback() {
        if (this.connectionFigure != null) {
            this.connectionFeedbackFigure = new TypeReferenceConnection();
            this.connectionFeedbackFigure.setSourceAnchor(this.connectionFigure.getSourceAnchor());
            this.connectionFeedbackFigure.setTargetAnchor(this.connectionFigure.getTargetAnchor());
            this.connectionFeedbackFigure.setHighlight(true);
            this.getLayer("Feedback Layer").add((IFigure)this.connectionFeedbackFigure);
        }
        super.addFeedback();
        this.getFieldFigure().addSelectionFeedback();
    }

    public void removeFeedback() {
        if (this.connectionFeedbackFigure != null) {
            this.connectionFeedbackFigure.setHighlight(false);
            this.getLayer("Feedback Layer").remove((IFigure)this.connectionFeedbackFigure);
        }
        this.connectionFeedbackFigure = null;
        super.removeFeedback();
        this.getFieldFigure().removeSelectionFeedback();
    }

    class ElementReferenceUpdateCommand
    extends Command
    implements IADTUpdateCommand {
        protected ComboBoxCellEditorManager delegate;
        protected DirectEditRequest request;

        public ElementReferenceUpdateCommand() {
            super(Messages._UI_ACTION_UPDATE_ELEMENT_REFERENCE);
        }

        public void setDelegate(ComboBoxCellEditorManager delegate) {
            this.delegate = delegate;
        }

        public void setRequest(DirectEditRequest request) {
            this.request = request;
        }

        public void execute() {
            if (this.delegate != null) {
                this.delegate.performEdit(this.request.getCellEditor());
            }
        }

        public boolean canExecute() {
            return true;
        }
    }

    class NameUpdateCommandWrapper
    extends Command
    implements IADTUpdateCommand {
        Command command;
        protected DirectEditRequest request;

        public NameUpdateCommandWrapper() {
            super(Messages._UI_ACTION_UPDATE_NAME);
        }

        public void setRequest(DirectEditRequest request) {
            this.request = request;
        }

        public void execute() {
            IField field = (IField)BaseFieldEditPart.this.getModel();
            Object newValue = this.request.getCellEditor().getValue();
            if (newValue instanceof String) {
                this.command = field.getUpdateNameCommand((String)newValue);
            }
            if (this.command != null) {
                this.command.execute();
            }
        }
    }

    class TypeUpdateCommand
    extends Command
    implements IADTUpdateCommand {
        protected ComboBoxCellEditorManager delegate;
        protected DirectEditRequest request;

        public TypeUpdateCommand() {
            super(Messages._UI_ACTION_UPDATE_TYPE);
        }

        public void setDelegate(ComboBoxCellEditorManager delegate) {
            this.delegate = delegate;
        }

        public void setRequest(DirectEditRequest request) {
            this.request = request;
        }

        public void execute() {
            if (this.delegate != null) {
                this.delegate.performEdit(this.request.getCellEditor());
            }
        }

        public boolean canExecute() {
            return true;
        }
    }
}

