/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.core.documentModel.parser.PhpLexer;
import org.eclipse.php.core.format.FormatPreferencesSupport;
import org.eclipse.php.core.format.FormatterUtils;
import org.eclipse.php.core.format.IIndentationStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class DefaultIndentationStrategy
implements IIndentationStrategy {
    public void placeMatchingBlanks(IStructuredDocument iStructuredDocument, StringBuffer stringBuffer, int n, int n2) throws BadLocationException {
        int n3;
        int n4;
        int n5 = this.getIndentationBaseLine(iStructuredDocument, n, n2);
        IRegion iRegion = iStructuredDocument.getLineInformation(n5);
        String string = FormatterUtils.getLineBlanks(iStructuredDocument, iRegion);
        stringBuffer.append(string);
        int n6 = iRegion.getOffset() + iRegion.getLength();
        if (n2 < n6) {
            n4 = n2;
            n3 = n;
        } else {
            n4 = n6;
            n3 = n5;
        }
        if (this.shouldIndent(iStructuredDocument, n4, n3)) {
            int n7 = FormatPreferencesSupport.getInstance().getIndentationSize((IDocument)iStructuredDocument);
            char c = FormatPreferencesSupport.getInstance().getIndentationChar((IDocument)iStructuredDocument);
            int n8 = 0;
            while (n8 < n7) {
                stringBuffer.append(c);
                ++n8;
            }
        }
    }

    private int getIndentationBaseLine(IStructuredDocument iStructuredDocument, int n, int n2) throws BadLocationException {
        int n3 = n;
        while (n3 >= 0) {
            IRegion iRegion = iStructuredDocument.getLineInformation(n3);
            if (iRegion.getLength() == 0) {
                --n3;
                continue;
            }
            int n4 = iRegion.getOffset() + iRegion.getLength();
            boolean bl = this.isIndentationBase(iStructuredDocument, Math.min(n2, n4), n2);
            if (bl) {
                return n3;
            }
            --n3;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isIndentationBase(IStructuredDocument var1_1, int var2_2, int var3_3) throws BadLocationException {
        var4_4 = var1_1.getLineInformationOfOffset(var2_2);
        var5_5 = var4_4.getOffset();
        if (!DefaultIndentationStrategy.isBlanks(var1_1, var5_5, var2_2, var3_3)) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            ++var5_5;
lbl6:
            // 2 sources

            ** while (Character.isWhitespace((char)var1_1.getChar((int)var5_5)))
        }
lbl7:
        // 1 sources

        var6_6 = FormatterUtils.getPartitionType(var1_1, var5_5);
        var7_7 = FormatterUtils.getPartitionType(var1_1, var2_2);
        var8_8 = FormatterUtils.getPartitionType(var1_1, var3_3);
        if (this.shouldNotConsiderAsIndentationBase(var6_6, var8_8)) {
            return false;
        }
        return this.lineShouldInedent(var6_6, var7_7) != false || var8_8 == var6_6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean shouldIndent(IStructuredDocument iStructuredDocument, int n, int n2) {
        try {
            IRegion iRegion = iStructuredDocument.getLineInformation(n2);
            int n3 = this.getLastTokenOffset(iStructuredDocument, iRegion, n);
            if (n3 == -1) {
                return false;
            }
            IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n3);
            ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n3);
            String string = iTextRegion.getType();
            if (string == "PHP_CURLY_OPEN") {
                return true;
            }
            if (string != "PHP_TOKEN") return false;
            if (iStructuredDocument.getChar(iStructuredDocumentRegion.getStartOffset() + iTextRegion.getStart()) != ':') return false;
            int n4 = iStructuredDocumentRegion.getStartOffset() + iTextRegion.getStart() - 1;
            while (true) {
                if (n4 < iRegion.getOffset()) {
                    return false;
                }
                iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n4);
                string = iTextRegion.getType();
                if (string == "PHP_CASE") return true;
                if (string == "PHP_DEFAULT") {
                    return true;
                }
                n4 = iStructuredDocumentRegion.getStartOffset() + iTextRegion.getStart() - 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    boolean shouldNotConsiderAsIndentationBase(String string, String string2) {
        return string != string2 && (string == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || string == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || string == "org.eclipse.php.PHP_SINGLE_LINE_COMMENT" || string == "org.eclipse.php.PHP_DOC" || string == "org.eclipse.php.PHP_QUOTED_STRING");
    }

    boolean lineShouldInedent(String string, String string2) {
        return string == "org.eclipse.php.PHP_DEFAULT" || string2 == "org.eclipse.php.PHP_DEFAULT";
    }

    protected static boolean isBlanks(IStructuredDocument iStructuredDocument, int n, int n2, int n3) throws BadLocationException {
        return iStructuredDocument.get(n, n2 - n).trim().length() == 0 || iStructuredDocument.get(n, n3 - n).trim().length() == 0;
    }

    protected int getLastTokenOffset(IStructuredDocument iStructuredDocument, IRegion iRegion, int n) {
        int n2 = iRegion.getOffset();
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        int n3 = iStructuredDocumentRegion.getStartOffset();
        int n4 = n;
        while (n2 <= n4) {
            if (iStructuredDocument.getLength() == n4) {
                --n4;
                continue;
            }
            ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n4);
            if (iTextRegion == null) {
                if ((iStructuredDocumentRegion = iStructuredDocumentRegion.getPrevious()) != null) {
                    n3 = iStructuredDocumentRegion.getStartOffset();
                    iTextRegion = iStructuredDocumentRegion.getLastRegion();
                    n4 = iTextRegion.getStart() + n3 - 1;
                    continue;
                }
                return -1;
            }
            if (iTextRegion.getStart() + n3 < n2) {
                return -1;
            }
            if (iTextRegion.getTextEnd() + n3 > n) {
                n4 = iTextRegion.getStart() + n3 - 1;
                continue;
            }
            if (!PhpLexer.isPHPCommentState(iTextRegion.getType()) && iTextRegion.getType() != "WHITESPACE") {
                return iStructuredDocumentRegion.getStartOffset(iTextRegion);
            }
            n4 = iTextRegion.getStart() + n3 - 1;
        }
        return -1;
    }
}

