/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.hover;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.internal.text.link.contentassist.HTML2TextReader;
import org.eclipse.jface.internal.text.revisions.HTMLPrinter;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.php.internal.ui.text.IInformationControlExtension4;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class BrowserInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
IInformationControlExtension4,
DisposeListener {
    private static final int BORDER = 1;
    private static final int MIN_WIDTH = 80;
    private static final int MIN_HEIGHT = 80;
    private static boolean fgIsAvailable = false;
    private static boolean fgAvailabilityChecked = false;
    private Shell fShell;
    private Browser fBrowser;
    private boolean fBrowserHasContent;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private Font fStatusTextFont;
    private Label fStatusTextField;
    private String fStatusFieldText;
    private boolean fHideScrollBars;
    private Listener fDeactivateListener;
    private ListenerList fFocusListeners = new ListenerList();
    private Label fSeparator;
    private String fInputText;
    private TextLayout fTextLayout;
    private TextStyle fBoldStyle;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAvailable(Composite composite) {
        if (fgAvailabilityChecked) return fgIsAvailable;
        try {
            try {
                if (composite == null) {
                    composite = PHPUiPlugin.getActiveWorkbenchShell();
                }
                if (composite == null) {
                    Object var2_1 = null;
                    fgAvailabilityChecked = true;
                    return false;
                }
                Browser browser = new Browser(composite, 0);
                browser.dispose();
                fgIsAvailable = true;
            }
            catch (SWTError sWTError) {
                fgIsAvailable = false;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            fgAvailabilityChecked = true;
            throw throwable;
        }
        {
            Object var2_3 = null;
            fgAvailabilityChecked = true;
            return fgIsAvailable;
        }
    }

    public BrowserInformationControl(Shell shell, int n, int n2) {
        this(shell, n, n2, null);
    }

    public BrowserInformationControl(Shell shell, int n, int n2, String string) {
        GridData gridData;
        int n3;
        this.fStatusFieldText = string;
        this.fShell = new Shell(shell, 0x84000 | n);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        this.fTextLayout = new TextLayout((Device)display);
        Shell shell2 = this.fShell;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = n3 = (n & 8) == 0 ? 0 : 1;
        gridLayout.marginWidth = n3;
        shell2.setLayout((Layout)gridLayout);
        if (string != null) {
            shell2 = new Composite((Composite)shell2, 0);
            gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.verticalSpacing = 1;
            gridLayout.horizontalSpacing = 1;
            shell2.setLayout((Layout)gridLayout);
            gridData = new GridData(1808);
            shell2.setLayoutData((Object)gridData);
            shell2.setForeground(display.getSystemColor(28));
            shell2.setBackground(display.getSystemColor(29));
        }
        this.fBrowser = new Browser((Composite)shell2, 0);
        this.fHideScrollBars = (n2 & 0x200) == 0 && (n2 & 0x100) == 0;
        gridData = new GridData(1809);
        this.fBrowser.setLayoutData((Object)gridData);
        this.fBrowser.setForeground(display.getSystemColor(28));
        this.fBrowser.setBackground(display.getSystemColor(29));
        this.fBrowser.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    BrowserInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.fBrowser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent locationEvent) {
                String string = locationEvent.location;
                if (!("about:blank".equals(string) || "carbon".equals(SWT.getPlatform()) && string.startsWith("applewebdata:"))) {
                    locationEvent.doit = false;
                }
            }
        });
        this.fBrowser.setMenu(new Menu((Decorations)this.fShell, 0));
        if (string != null) {
            this.fSeparator = new Label((Composite)shell2, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusTextField = new Label((Composite)shell2, 131072);
            this.fStatusTextField.setText(string);
            Font font = this.fStatusTextField.getFont();
            FontData[] fontDataArray = font.getFontData();
            int n4 = 0;
            while (n4 < fontDataArray.length) {
                fontDataArray[n4].setHeight(fontDataArray[n4].getHeight() * 9 / 10);
                ++n4;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusTextField.getDisplay(), fontDataArray);
            this.fStatusTextField.setFont(this.fStatusTextFont);
            gridData = new GridData(802);
            this.fStatusTextField.setLayoutData((Object)gridData);
            this.fStatusTextField.setForeground(display.getSystemColor(17));
            this.fStatusTextField.setBackground(display.getSystemColor(29));
        }
        this.addDisposeListener(this);
        this.createTextLayout();
    }

    public BrowserInformationControl(Shell shell, int n) {
        this(shell, 12, n);
    }

    public BrowserInformationControl(Shell shell) {
        this(shell, 0);
    }

    public void setInformation(String string) {
        boolean bl = this.fBrowserHasContent = string != null && string.length() > 0;
        if (!this.fBrowserHasContent) {
            string = "<html><body ></html>";
        }
        this.fInputText = string;
        int n = this.fShell.getStyle();
        boolean bl2 = (n & 0x4000000) != 0;
        String[] stringArray = null;
        if (bl2 && !this.fHideScrollBars) {
            stringArray = new String[]{"direction:rtl;", "word-wrap:break-word;"};
        } else if (bl2 && this.fHideScrollBars) {
            stringArray = new String[]{"direction:rtl;", "overflow:hidden;", "word-wrap:break-word;"};
        } else if (this.fHideScrollBars) {
            stringArray = new String[]{"overflow:hidden;", "word-wrap: break-word;"};
        }
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            HTMLPrinter.insertStyles((StringBuffer)stringBuffer, (String[])stringArray);
            string = stringBuffer.toString();
        }
        this.fBrowser.setText(string);
    }

    public void setStatusText(String string) {
        this.fStatusFieldText = string;
    }

    public void setVisible(boolean bl) {
        if (this.fShell.isVisible() == bl) {
            return;
        }
        if (bl && this.fStatusTextField != null) {
            boolean bl2;
            boolean bl3 = bl2 = this.fStatusFieldText != null;
            if (bl2) {
                this.fStatusTextField.setText(this.fStatusFieldText);
            }
            this.fStatusTextField.setVisible(bl2);
            this.fSeparator.setVisible(bl2);
        }
        this.fShell.setVisible(bl);
        if (!bl) {
            this.setInformation("");
        }
    }

    private void createTextLayout() {
        this.fTextLayout = new TextLayout((Device)this.fBrowser.getDisplay());
        Font font = this.fBrowser.getFont();
        this.fTextLayout.setFont(font);
        this.fTextLayout.setWidth(-1);
        FontData[] fontDataArray = font.getFontData();
        int n = 0;
        while (n < fontDataArray.length) {
            fontDataArray[n].setStyle(1);
            ++n;
        }
        font = new Font((Device)this.fShell.getDisplay(), fontDataArray);
        this.fBoldStyle = new TextStyle(font, null, null);
        this.fTextLayout.setText("    ");
        n = this.fTextLayout.getBounds().width;
        this.fTextLayout.setTabs(new int[]{n});
        this.fTextLayout.setText("");
    }

    public void dispose() {
        this.fTextLayout.dispose();
        this.fTextLayout = null;
        this.fBoldStyle.font.dispose();
        this.fBoldStyle = null;
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fShell = null;
        this.fBrowser = null;
        this.fStatusTextFont = null;
    }

    public void setSize(int n, int n2) {
        this.fShell.setSize(Math.min(n, this.fMaxWidth), Math.min(n2, this.fMaxHeight));
    }

    public void setLocation(Point point) {
        this.fShell.setLocation(point);
    }

    public void setSizeConstraints(int n, int n2) {
        this.fMaxWidth = n;
        this.fMaxHeight = n2;
    }

    public Point computeSizeHint() {
        Rectangle rectangle;
        String string;
        TextPresentation textPresentation = new TextPresentation();
        HTML2TextReader hTML2TextReader = new HTML2TextReader((Reader)new StringReader(this.fInputText), textPresentation);
        try {
            string = hTML2TextReader.getString();
        }
        catch (IOException iOException) {
            string = "";
        }
        this.fTextLayout.setText(string);
        Iterator iterator = textPresentation.getAllStyleRangeIterator();
        while (iterator.hasNext()) {
            rectangle = (StyleRange)iterator.next();
            if (rectangle.fontStyle != 1) continue;
            this.fTextLayout.setStyle(this.fBoldStyle, rectangle.start, rectangle.start + rectangle.length - 1);
        }
        rectangle = this.fTextLayout.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        n += 15;
        n2 += 25;
        if (this.fStatusFieldText != null && this.fSeparator != null) {
            this.fTextLayout.setText(this.fStatusFieldText);
            Rectangle rectangle2 = this.fTextLayout.getBounds();
            Rectangle rectangle3 = this.fSeparator.getBounds();
            n = Math.max(n, rectangle2.width);
            n2 = n2 + rectangle2.height + rectangle3.height;
        }
        if (this.fMaxWidth != -1) {
            n = Math.min(this.fMaxWidth, n);
        }
        if (this.fMaxHeight != -1) {
            n2 = Math.min(this.fMaxHeight, n2);
        }
        n = Math.max(80, n);
        n2 = Math.max(80, n2);
        return new Point(n, n2);
    }

    public Rectangle computeTrim() {
        return this.fShell.computeTrim(0, 0, 0, 0);
    }

    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.fShell.addDisposeListener(disposeListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.fShell.removeDisposeListener(disposeListener);
    }

    public void setForegroundColor(Color color) {
        this.fBrowser.setForeground(color);
    }

    public void setBackgroundColor(Color color) {
        this.fBrowser.setBackground(color);
    }

    public boolean isFocusControl() {
        return this.fBrowser.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fBrowser.setFocus();
    }

    public void addFocusListener(FocusListener focusListener) {
        this.fBrowser.addFocusListener(focusListener);
        if (this.fFocusListeners.isEmpty()) {
            this.fDeactivateListener = new Listener(){

                public void handleEvent(Event event) {
                    Object[] objectArray = BrowserInformationControl.this.fFocusListeners.getListeners();
                    int n = 0;
                    while (n < objectArray.length) {
                        ((FocusListener)objectArray[n]).focusLost(new FocusEvent(event));
                        ++n;
                    }
                }
            };
            this.fBrowser.getShell().addListener(27, this.fDeactivateListener);
        }
        this.fFocusListeners.add((Object)focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.fBrowser.removeFocusListener(focusListener);
        this.fFocusListeners.remove((Object)focusListener);
        if (this.fFocusListeners.isEmpty()) {
            this.fBrowser.getShell().removeListener(27, this.fDeactivateListener);
            this.fDeactivateListener = null;
        }
    }

    public boolean hasContents() {
        return this.fBrowserHasContent;
    }
}

