/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.workingset;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.php.core.phpModel.parser.IPhpModel;
import org.eclipse.php.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.functions.PHPFunctionsPart;
import org.eclipse.php.ui.workingset.ViewAction;
import org.eclipse.php.ui.workingset.ViewActionGroup;
import org.eclipse.ui.IEditorPart;

public class FunctionsViewGroup
extends ViewActionGroup {
    public static final int PHP4 = 1;
    public static final int PHP5 = 2;
    private PHPFunctionsPart fPart;
    private ViewAction showPHP4FunctionsAction;
    private ViewAction showPHP5FunctionsAction;
    private int currentMode;
    private UpdateViewJob updateViewJob;

    public FunctionsViewGroup(PHPFunctionsPart pHPFunctionsPart) {
        this.fPart = pHPFunctionsPart;
        this.fillContextMenu(this.fPart.getViewSite().getActionBars().getMenuManager());
    }

    public void dispose() {
        super.dispose();
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.showPHP4FunctionsAction = new ViewAction(this, 1);
        this.showPHP4FunctionsAction.setText("PHP 4");
        this.showPHP5FunctionsAction = new ViewAction(this, 2);
        this.showPHP5FunctionsAction.setText("PHP 5");
        iMenuManager.add((IAction)this.showPHP4FunctionsAction);
        iMenuManager.add((IAction)this.showPHP5FunctionsAction);
    }

    public void setMode(int n) {
        if (n == this.currentMode) {
            return;
        }
        IPhpModel iPhpModel = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.currentMode == 1 ? "php4" : "php5").getModel();
        this.fPart.getViewer().setInput((Object)iPhpModel);
        this.currentMode = n;
        this.updateActions();
    }

    private void updateActions() {
        if (this.currentMode == 1) {
            this.showPHP4FunctionsAction.setChecked(true);
            this.showPHP5FunctionsAction.setChecked(false);
        } else {
            this.showPHP5FunctionsAction.setChecked(true);
            this.showPHP4FunctionsAction.setChecked(false);
        }
    }

    public void handleUpdateInput(IEditorPart iEditorPart) {
        if (iEditorPart != null && iEditorPart instanceof PHPStructuredEditor) {
            PHPStructuredEditor pHPStructuredEditor = (PHPStructuredEditor)iEditorPart;
            IFile iFile = pHPStructuredEditor.getFile();
            String string = PhpVersionProjectPropertyHandler.getVersion((IProject)iFile.getProject());
            this.setMode(this.getVersion(string));
        } else {
            this.setMode(this.getVersion(PhpVersionProjectPropertyHandler.getVersion()));
        }
    }

    private String getVersion(int n) {
        if (n == 1) {
            return "php4";
        }
        return "php5";
    }

    private int getVersion(String string) {
        if ("php4".equals(string)) {
            return 1;
        }
        return 2;
    }

    class UpdateViewJob
    extends Job {
        public UpdateViewJob() {
            super("updateViewJob");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            FunctionsViewGroup.this.fPart.getViewer().setInput((Object)PHPLanguageManagerProvider.instance().getPHPLanguageManager(FunctionsViewGroup.this.currentMode == 1 ? "php4" : "php5").getModel());
            FunctionsViewGroup.this.fPart.getViewer().refresh();
            return Status.OK_STATUS;
        }
    }
}

