/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.preferences.phps;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.debug.core.preferences.PHPexeItem;
import org.eclipse.php.debug.core.preferences.PHPexes;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.debug.ui.preferences.phps.AddPHPexeDialog;
import org.eclipse.php.debug.ui.preferences.phps.IAddPHPexeDialogRequestor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class InstalledPHPsBlock
implements IAddPHPexeDialogRequestor,
ISelectionProvider {
    private Composite fControl;
    private List fPHPexes = new ArrayList();
    private CheckboxTableViewer fPHPExeList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private Button fSearchButton;
    private float fWeight1 = 0.33333334f;
    private float fWeight2 = 0.33333334f;
    private boolean fResizingTable = false;
    private int fSortColumn = 0;
    PHPexes phpExes;
    private ListenerList fSelectionListeners = new ListenerList(1);
    private ISelection fPrevSelection = new StructuredSelection();

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.add((Object)iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.fPHPExeList.getCheckedElements());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.remove((Object)iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && !iSelection.equals(this.fPrevSelection)) {
            this.fPrevSelection = iSelection;
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object == null) {
                this.fPHPExeList.setCheckedElements(new Object[0]);
            } else {
                this.fPHPExeList.setCheckedElements(new Object[]{object});
                this.fPHPExeList.reveal(object);
            }
            this.fireSelectionChanged();
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Font font = composite.getFont();
        composite2.setFont(font);
        this.fControl = composite2;
        Label label = new Label(composite2, 0);
        label.setText(PHPDebugUIMessages.InstalledPHPsBlock_15);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        Table table = new Table(composite2, 67618);
        gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(PHPDebugUIMessages.InstalledPHPsBlock_0);
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InstalledPHPsBlock.this.sortByName();
            }
        });
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText(PHPDebugUIMessages.InstalledPHPsBlock_1);
        tableColumn2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InstalledPHPsBlock.this.sortByLocation();
            }
        });
        this.fPHPExeList = new CheckboxTableViewer(table);
        this.fPHPExeList.setLabelProvider((IBaseLabelProvider)new VMLabelProvider());
        this.fPHPExeList.setContentProvider((IContentProvider)new PHPsContentProvider());
        this.sortByName();
        this.fPHPExeList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                InstalledPHPsBlock.this.enableButtons();
            }
        });
        this.fPHPExeList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                if (checkStateChangedEvent.getChecked()) {
                    InstalledPHPsBlock.this.setCheckedPHP((PHPexeItem)checkStateChangedEvent.getElement());
                } else {
                    InstalledPHPsBlock.this.setCheckedPHP(null);
                }
            }
        });
        this.fPHPExeList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                if (!InstalledPHPsBlock.this.fPHPExeList.getSelection().isEmpty()) {
                    InstalledPHPsBlock.this.editPHPexe();
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
                    InstalledPHPsBlock.this.removePHPexes();
                }
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(2));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setFont(font);
        this.fAddButton = this.createPushButton(composite3, PHPDebugUIMessages.InstalledPHPsBlock_3);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InstalledPHPsBlock.this.addPHPexe();
            }
        });
        this.fEditButton = this.createPushButton(composite3, PHPDebugUIMessages.InstalledPHPsBlock_4);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InstalledPHPsBlock.this.editPHPexe();
            }
        });
        this.fRemoveButton = this.createPushButton(composite3, PHPDebugUIMessages.InstalledPHPsBlock_5);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InstalledPHPsBlock.this.removePHPexes();
            }
        });
        Label label2 = new Label(composite3, 0);
        label2.setVisible(false);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 1;
        gridData2.heightHint = 4;
        label2.setLayoutData((Object)gridData2);
        this.fSearchButton = this.createPushButton(composite3, PHPDebugUIMessages.InstalledPHPsBlock_6);
        this.fSearchButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InstalledPHPsBlock.this.search();
            }
        });
        this.configureTableResizing(composite2, composite3, table, tableColumn, tableColumn2);
        this.fillWithWorkspacePHPs();
        this.enableButtons();
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = this.fSelectionListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
            ++n;
        }
    }

    private void sortByType() {
        this.fPHPExeList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof PHPexeItem && object2 instanceof PHPexeItem) {
                    String string;
                    PHPexeItem pHPexeItem = (PHPexeItem)object;
                    PHPexeItem pHPexeItem2 = (PHPexeItem)object2;
                    String string2 = pHPexeItem.getName();
                    int n = string2.compareToIgnoreCase(string = pHPexeItem2.getName());
                    if (n != 0) {
                        return n;
                    }
                    return pHPexeItem.getName().compareToIgnoreCase(pHPexeItem2.getName());
                }
                return super.compare(viewer, object, object2);
            }

            public boolean isSorterProperty(Object object, String string) {
                return true;
            }
        });
        this.fSortColumn = 3;
    }

    private void sortByName() {
        this.fPHPExeList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof PHPexeItem && object2 instanceof PHPexeItem) {
                    PHPexeItem pHPexeItem = (PHPexeItem)object;
                    PHPexeItem pHPexeItem2 = (PHPexeItem)object2;
                    return pHPexeItem.getName().compareToIgnoreCase(pHPexeItem2.getName());
                }
                return super.compare(viewer, object, object2);
            }

            public boolean isSorterProperty(Object object, String string) {
                return true;
            }
        });
        this.fSortColumn = 1;
    }

    private void sortByLocation() {
        this.fPHPExeList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof PHPexeItem && object2 instanceof PHPexeItem) {
                    PHPexeItem pHPexeItem = (PHPexeItem)object;
                    PHPexeItem pHPexeItem2 = (PHPexeItem)object2;
                    return pHPexeItem.getLocation().getAbsolutePath().compareToIgnoreCase(pHPexeItem2.getLocation().getAbsolutePath());
                }
                return super.compare(viewer, object, object2);
            }

            public boolean isSorterProperty(Object object, String string) {
                return true;
            }
        });
        this.fSortColumn = 2;
    }

    private void enableButtons() {
        int n = ((IStructuredSelection)this.fPHPExeList.getSelection()).size();
        this.fEditButton.setEnabled(n == 1);
        this.fRemoveButton.setEnabled(n > 0);
    }

    protected Button createPushButton(Composite composite, String string) {
        return SWTUtil.createPushButton((Composite)composite, (String)string, null);
    }

    protected void configureTableResizing(final Composite composite, final Composite composite2, final Table table, final TableColumn tableColumn, final TableColumn tableColumn2) {
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                InstalledPHPsBlock.this.resizeTable(composite, composite2, table, tableColumn, tableColumn2);
            }
        });
        table.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                table.removeListener(9, (Listener)this);
                InstalledPHPsBlock.this.resizeTable(composite, composite2, table, tableColumn, tableColumn2);
            }
        });
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (tableColumn.getWidth() > 0 && !InstalledPHPsBlock.this.fResizingTable) {
                    InstalledPHPsBlock.this.fWeight1 = InstalledPHPsBlock.this.getColumnWeight(0);
                }
            }
        });
        tableColumn2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (tableColumn2.getWidth() > 0 && !InstalledPHPsBlock.this.fResizingTable) {
                    InstalledPHPsBlock.this.fWeight2 = InstalledPHPsBlock.this.getColumnWeight(1);
                }
            }
        });
    }

    private void resizeTable(Composite composite, Composite composite2, Table table, TableColumn tableColumn, TableColumn tableColumn2) {
        Point point;
        Rectangle rectangle;
        this.fResizingTable = true;
        int n = -1;
        int n2 = -1;
        if (composite.isVisible()) {
            rectangle = composite.getClientArea();
            n = rectangle.width;
            n2 = rectangle.height;
        } else {
            rectangle = composite.computeSize(-1, -1);
            n = rectangle.x;
            n2 = rectangle.y;
        }
        rectangle = table.computeSize(-1, -1);
        int n3 = n - 2 * table.getBorderWidth();
        if (rectangle.y > n2) {
            point = table.getVerticalBar().getSize();
            n3 -= point.x;
        }
        point = table.getSize();
        if (point.x > (n3 -= composite2.getSize().x)) {
            tableColumn.setWidth(Math.round((float)n3 * this.fWeight1));
            tableColumn2.setWidth(Math.round((float)n3 * this.fWeight2));
            table.setSize(n3, n2);
        } else {
            table.setSize(n3, n2);
            tableColumn.setWidth(Math.round((float)n3 * this.fWeight1));
            tableColumn2.setWidth(Math.round((float)n3 * this.fWeight2));
        }
        this.fResizingTable = false;
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setPHPs(PHPexeItem[] pHPexeItemArray) {
        this.fPHPexes.clear();
        int n = 0;
        while (n < pHPexeItemArray.length) {
            this.fPHPexes.add(pHPexeItemArray[n]);
            ++n;
        }
        this.fPHPExeList.setInput((Object)this.fPHPexes);
        this.fPHPExeList.refresh();
    }

    public PHPexeItem[] getPHPs() {
        return this.fPHPexes.toArray(new PHPexeItem[this.fPHPexes.size()]);
    }

    private void addPHPexe() {
        AddPHPexeDialog addPHPexeDialog = new AddPHPexeDialog(this, this.getShell(), this.phpExes, null);
        addPHPexeDialog.setTitle(PHPDebugUIMessages.InstalledPHPsBlock_7);
        if (addPHPexeDialog.open() != 0) {
            return;
        }
        this.fPHPExeList.refresh();
    }

    public void phpExeAdded(PHPexeItem pHPexeItem) {
        this.fPHPexes.add(pHPexeItem);
        this.fPHPExeList.refresh();
        if (this.fPHPexes.size() == 1) {
            this.setCheckedPHP(pHPexeItem);
        }
    }

    public boolean isDuplicateName(String string) {
        int n = 0;
        while (n < this.fPHPexes.size()) {
            PHPexeItem pHPexeItem = (PHPexeItem)this.fPHPexes.get(n);
            if (pHPexeItem.getName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void editPHPexe() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fPHPExeList.getSelection();
        PHPexeItem pHPexeItem = (PHPexeItem)iStructuredSelection.getFirstElement();
        if (pHPexeItem == null) {
            return;
        }
        AddPHPexeDialog addPHPexeDialog = new AddPHPexeDialog(this, this.getShell(), this.phpExes, pHPexeItem);
        addPHPexeDialog.setTitle(PHPDebugUIMessages.InstalledPHPsBlock_8);
        if (addPHPexeDialog.open() != 0) {
            return;
        }
        this.fPHPExeList.refresh((Object)pHPexeItem);
    }

    private void removePHPexes() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fPHPExeList.getSelection();
        PHPexeItem[] pHPexeItemArray = new PHPexeItem[iStructuredSelection.size()];
        Iterator iterator = iStructuredSelection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            pHPexeItemArray[n] = (PHPexeItem)iterator.next();
            ++n;
        }
        this.removePHPs(pHPexeItemArray);
    }

    public void removePHPs(PHPexeItem[] pHPexeItemArray) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getSelection();
        int n = 0;
        while (n < pHPexeItemArray.length) {
            this.fPHPexes.remove(pHPexeItemArray[n]);
            this.phpExes.removeItem(pHPexeItemArray[n]);
            ++n;
        }
        this.fPHPExeList.refresh();
        IStructuredSelection iStructuredSelection2 = (IStructuredSelection)this.getSelection();
        if (!iStructuredSelection2.equals(iStructuredSelection)) {
            PHPexeItem[] pHPexeItemArray2 = this.getPHPs();
            if (iStructuredSelection2.size() == 0 && pHPexeItemArray2.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)pHPexeItemArray2[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
    }

    protected void search() {
        Object object;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setMessage(PHPDebugUIMessages.InstalledPHPsBlock_9);
        directoryDialog.setText(PHPDebugUIMessages.InstalledPHPsBlock_10);
        String string = directoryDialog.open();
        if (string == null) {
            return;
        }
        final HashSet<File> hashSet = new HashSet<File>();
        Iterator iterator = this.fPHPexes.iterator();
        while (iterator.hasNext()) {
            hashSet.add(((PHPexeItem)iterator.next()).getPhpEXE().getParentFile());
        }
        final File file = new File(string);
        final ArrayList arrayList = new ArrayList();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(PHPDebugUIMessages.InstalledPHPsBlock_11, -1);
                InstalledPHPsBlock.this.search(file, arrayList, hashSet, iProgressMonitor);
                iProgressMonitor.done();
            }
        };
        try {
            object = new ProgressMonitorDialog(this.getShell());
            object.run(true, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            PHPDebugUIPlugin.log(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (arrayList.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PHPDebugUIMessages.InstalledPHPsBlock_12, (String)MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_13, string));
        } else {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (File)iterator.next();
                String string2 = PHPDebugUIMessages.InstalledPHPsBlock_16;
                String string3 = new String(string2);
                int n = 1;
                while (this.isDuplicateName(string3)) {
                    string3 = String.valueOf(string2) + '(' + n++ + ')';
                }
                PHPexeItem pHPexeItem = new PHPexeItem(string3, (File)object, true);
                this.phpExes.addItem(pHPexeItem);
                this.phpExeAdded(pHPexeItem);
            }
        }
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    protected void search(File file, List list, Set set, IProgressMonitor iProgressMonitor) {
        String[] stringArray;
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (!set.contains(file) && (stringArray = PHPexeItem.findPHPExecutable((File)file)) != null) {
            list.add(stringArray);
        }
        if ((stringArray = file.list()) == null) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < stringArray.length) {
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                try {
                    iProgressMonitor.subTask(MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_14, Integer.toString(list.size()), file2.getCanonicalPath()));
                }
                catch (IOException iOException) {}
                if (!set.contains(file2)) {
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    File file3 = PHPexeItem.findPHPExecutable((File)file2);
                    if (file3 != null) {
                        list.add(file3);
                        set.add(file2);
                    }
                    arrayList.add(file2);
                }
            }
            ++n;
        }
        while (!arrayList.isEmpty()) {
            File file4 = (File)arrayList.remove(0);
            this.search(file4, list, set, iProgressMonitor);
            if (!iProgressMonitor.isCanceled()) continue;
            return;
        }
    }

    public void setCheckedPHP(PHPexeItem pHPexeItem) {
        if (pHPexeItem == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)pHPexeItem));
        }
    }

    public PHPexeItem getCheckedPHP() {
        Object[] objectArray = this.fPHPExeList.getCheckedElements();
        if (objectArray.length == 0) {
            return null;
        }
        return (PHPexeItem)objectArray[0];
    }

    public void saveColumnSettings(IDialogSettings iDialogSettings, String string) {
        int n = 0;
        while (n < 2) {
            iDialogSettings.put(String.valueOf(string) + ".column" + n, this.getColumnWeight(n));
            ++n;
        }
        iDialogSettings.put(String.valueOf(string) + ".sortColumn", this.fSortColumn);
    }

    private float getColumnWeight(int n) {
        Table table;
        int n2 = table.getSize().x;
        table = this.fPHPExeList.getTable();
        int n3 = table.getColumn(n).getWidth();
        if (n2 > n3) {
            return (float)n3 / (float)n2;
        }
        return 0.33333334f;
    }

    public void restoreColumnSettings(IDialogSettings iDialogSettings, String string) {
        this.fWeight1 = this.restoreColumnWeight(iDialogSettings, string, 0);
        this.fWeight2 = this.restoreColumnWeight(iDialogSettings, string, 1);
        this.fPHPExeList.getTable().layout(true);
        try {
            this.fSortColumn = iDialogSettings.getInt(String.valueOf(string) + ".sortColumn");
        }
        catch (NumberFormatException numberFormatException) {
            this.fSortColumn = 1;
        }
        switch (this.fSortColumn) {
            case 1: {
                this.sortByName();
                break;
            }
            case 2: {
                this.sortByLocation();
                break;
            }
            case 3: {
                this.sortByType();
            }
        }
    }

    private float restoreColumnWeight(IDialogSettings iDialogSettings, String string, int n) {
        try {
            return iDialogSettings.getFloat(String.valueOf(string) + ".column" + n);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.33333334f;
        }
    }

    protected void fillWithWorkspacePHPs() {
        PHPexeItem[] pHPexeItemArray = this.phpExes.getItems();
        this.setPHPs(pHPexeItemArray);
    }

    public InstalledPHPsBlock(PHPexes pHPexes) {
        this.phpExes = pHPexes;
    }

    class PHPsContentProvider
    implements IStructuredContentProvider {
        PHPsContentProvider() {
        }

        public Object[] getElements(Object object) {
            return InstalledPHPsBlock.this.fPHPexes.toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    class VMLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        VMLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof PHPexeItem) {
                PHPexeItem pHPexeItem = (PHPexeItem)object;
                switch (n) {
                    case 0: {
                        return pHPexeItem.getName();
                    }
                    case 1: {
                        return pHPexeItem.getLocation().getAbsolutePath();
                    }
                }
            }
            return object.toString();
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }
    }
}

