/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.operations.AddServletOperation;
import org.eclipse.jst.j2ee.internal.web.operations.INewServletClassDataModelProperties;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class NewServletClassDataModelProvider
extends NewJavaClassDataModelProvider
implements INewServletClassDataModelProperties {
    private static final String SERVLET_SUPERCLASS = "javax.servlet.http.HttpServlet";
    private static final String[] SERVLET_INTERFACES = new String[]{"javax.servlet.Servlet"};
    private static final String ANNOTATED_TEMPLATE_DEFAULT = "servletXDoclet.javajet";
    private static final String NON_ANNOTATED_TEMPLATE_DEFAULT = "servletXDocletNonAnnotated.javajet";
    private List interfaceList;
    private static boolean useAnnotations = false;

    public IDataModelOperation getDefaultOperation() {
        return new AddServletOperation(this.getDataModel());
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("IAnnotationsDataModel.useAnnotations".equals(propertyName)) {
            return !this.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS") && this.isAnnotationsSupported();
        }
        return super.isPropertyEnabled(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("NewServletClassDataModel.INIT");
        propertyNames.add("NewServletClassDataModel.DO_POST");
        propertyNames.add("NewServletClassDataModel.DESTROY");
        propertyNames.add("NewServletClassDataModel.TO_STRING");
        propertyNames.add("NewServletClassDataModel.DO_PUT");
        propertyNames.add("NewServletClassDataModel.DO_GET");
        propertyNames.add("NewServletClassDataModel.GET_SERVLET_INFO");
        propertyNames.add("NewServletClassDataModel.DO_DELETE");
        propertyNames.add("NewServletClassDataModel.IS_SERVLET_TYPE");
        propertyNames.add("NewServletClassDataModel.INIT_PARAM");
        propertyNames.add("NewServletClassDataModel.URL_MAPPINGS");
        propertyNames.add("IAnnotationsDataModel.useAnnotations");
        propertyNames.add("NewServletClassDataModel.DISPLAY_NAME");
        propertyNames.add("NewServletClassDataModel.DESCRIPTION");
        propertyNames.add("NewServletClassDataModel.NON_ANNOTATED_TEMPLATE_FILE");
        propertyNames.add("NewServletClassDataModel.TEMPLATE_FILE");
        propertyNames.add("NewServletClassDataModel.USE_EXISTING_CLASS");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("NewServletClassDataModel.DO_POST")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewServletClassDataModel.DO_GET")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewServletClassDataModel.IS_SERVLET_TYPE")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            return NewServletClassDataModelProvider.shouldDefaultAnnotations();
        }
        if (propertyName.equals("NewServletClassDataModel.DISPLAY_NAME")) {
            String className = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
            if (className.endsWith(".jsp")) {
                int index = className.lastIndexOf("/");
                className = className.substring(index + 1, className.length() - 4);
            } else {
                int index = className.lastIndexOf(".");
                className = className.substring(index + 1);
            }
            return className;
        }
        if (propertyName.equals("NewServletClassDataModel.URL_MAPPINGS")) {
            return this.getDefaultUrlMapping();
        }
        if (propertyName.equals("NewJavaClassDataModel.INTERFACES")) {
            return this.getServletInterfaces();
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return SERVLET_SUPERCLASS;
        }
        if (propertyName.equals("NewServletClassDataModel.TEMPLATE_FILE")) {
            return ANNOTATED_TEMPLATE_DEFAULT;
        }
        if (propertyName.equals("NewServletClassDataModel.NON_ANNOTATED_TEMPLATE_FILE")) {
            return NON_ANNOTATED_TEMPLATE_DEFAULT;
        }
        if (propertyName.equals("NewServletClassDataModel.USE_EXISTING_CLASS")) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object getDefaultUrlMapping() {
        ArrayList<String[]> urlMappings = null;
        String text = (String)this.getProperty("NewServletClassDataModel.DISPLAY_NAME");
        if (text != null) {
            urlMappings = new ArrayList<String[]>();
            urlMappings.add(new String[]{"/" + text});
        }
        return urlMappings;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            useAnnotations = (Boolean)propertyValue;
            if (useAnnotations && !this.isAnnotationsSupported()) {
                return true;
            }
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        }
        if (propertyName.equals("NewJavaClassDataModel.SOURCE_FOLDER")) {
            String sourceFolder = (String)propertyValue;
            int index = sourceFolder.indexOf(File.separator);
            String projectName = sourceFolder;
            if (index == 0) {
                projectName = sourceFolder.substring(1);
            }
            if ((index = projectName.indexOf(File.separator)) != -1) {
                projectName = projectName.substring(0, index);
                this.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", projectName);
            }
        }
        boolean result = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME") && !this.getDataModel().isPropertySet("NewServletClassDataModel.DISPLAY_NAME")) {
            this.getDataModel().notifyPropertyChange("NewServletClassDataModel.DISPLAY_NAME", 2);
        }
        if (propertyName.equals("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) {
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        }
        if (this.getBooleanProperty("IAnnotationsDataModel.useAnnotations") && !this.isAnnotationsSupported()) {
            this.setBooleanProperty("IAnnotationsDataModel.useAnnotations", false);
        }
        if (propertyName.equals("NewServletClassDataModel.USE_EXISTING_CLASS")) {
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
            if (((Boolean)propertyValue).booleanValue()) {
                this.setProperty("IAnnotationsDataModel.useAnnotations", Boolean.FALSE);
            }
            this.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", null);
            this.setProperty("NewJavaClassDataModel.CLASS_NAME", null);
        }
        return result;
    }

    protected boolean isAnnotationsSupported() {
        boolean bl;
        block10: {
            WebArtifactEdit webEdit;
            block8: {
                block9: {
                    if (!this.getDataModel().isPropertySet("IArtifactEditOperationDataModelProperties.PROJECT_NAME")) {
                        return true;
                    }
                    if (this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME").equals("")) {
                        return true;
                    }
                    IProject project = ProjectUtilities.getProject((String)this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
                    String moduleName = this.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME");
                    if (project == null || moduleName == null || moduleName.equals("")) {
                        return true;
                    }
                    webEdit = null;
                    webEdit = WebArtifactEdit.getWebArtifactEditForRead(project);
                    if (webEdit != null) break block8;
                    Object var5_4 = null;
                    if (webEdit == null) break block9;
                    webEdit.dispose();
                }
                return true;
            }
            try {
                bl = webEdit.getJ2EEVersion() > 12;
                Object var5_5 = null;
                if (webEdit == null) break block10;
            }
            catch (Exception e) {
                block11: {
                    try {
                        e.printStackTrace();
                        Object var5_6 = null;
                        if (webEdit == null) break block11;
                    }
                    catch (Throwable throwable) {
                        block12: {
                            Object var5_7 = null;
                            if (webEdit == null) break block12;
                            webEdit.dispose();
                        }
                        throw throwable;
                    }
                    webEdit.dispose();
                }
                return false;
            }
            webEdit.dispose();
        }
        return bl;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS") && this.getStringProperty(propertyName).equals(SERVLET_SUPERCLASS)) {
            return WTPCommonPlugin.OK_STATUS;
        }
        IStatus result = super.validate(propertyName);
        if (result != null && !result.isOK()) {
            return result;
        }
        if (propertyName.equals("NewServletClassDataModel.INIT_PARAM")) {
            return this.validateInitParamList((List)this.getProperty(propertyName));
        }
        if (propertyName.equals("NewServletClassDataModel.URL_MAPPINGS")) {
            return this.validateURLMappingList((List)this.getProperty(propertyName));
        }
        if (propertyName.equals("NewServletClassDataModel.DISPLAY_NAME")) {
            return this.validateDisplayName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME")) {
            result = this.validateJavaClassName(this.getStringProperty(propertyName));
            if (result.isOK() && !this.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS")) {
                result = this.canCreateTypeInClasspath(this.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
            }
            return result;
        }
        return result;
    }

    protected IStatus validateJavaClassName(String className) {
        if (this.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS")) {
            return WTPCommonPlugin.OK_STATUS;
        }
        IStatus status = super.validateJavaClassName(className);
        if (status.isOK()) {
            if (className.equals("Servlet")) {
                String msg = WebMessages.ERR_SERVLET_JAVA_CLASS_NAME_INVALID;
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            return WTPCommonPlugin.OK_STATUS;
        }
        return status;
    }

    private IStatus validateInitParamList(List prop) {
        boolean dup;
        if (prop != null && !prop.isEmpty() && (dup = this.hasDuplicatesInStringArrayList(prop))) {
            String msg = WebMessages.ERR_DUPLICATED_INIT_PARAMETER;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateURLMappingList(List prop) {
        if (prop != null && !prop.isEmpty()) {
            boolean dup = this.hasDuplicatesInStringArrayList(prop);
            if (dup) {
                String msg = WebMessages.ERR_DUPLICATED_URL_MAPPING;
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        } else {
            String msg = WebMessages.ERR_SERVLET_MAPPING_URL_PATTERN_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private boolean hasDuplicatesInStringArrayList(List input) {
        if (input == null) {
            return false;
        }
        int n = input.size();
        boolean dup = false;
        int i = 0;
        while (i < n) {
            String[] sArray1 = (String[])input.get(i);
            int j = i + 1;
            while (j < n) {
                String[] sArray2 = (String[])input.get(j);
                if (this.isTwoStringArraysEqual(sArray1, sArray2)) {
                    dup = true;
                    break;
                }
                ++j;
            }
            if (dup) break;
            ++i;
        }
        return dup;
    }

    private boolean isTwoStringArraysEqual(String[] sArray1, String[] sArray2) {
        if (sArray1 == null || sArray2 == null) {
            return false;
        }
        int n1 = sArray1.length;
        int n2 = sArray1.length;
        if (n1 == 0 || n2 == 0) {
            return false;
        }
        if (n1 != n2) {
            return false;
        }
        return sArray1[0].equals(sArray2[0]);
    }

    private List getServletInterfaces() {
        if (this.interfaceList == null) {
            this.interfaceList = new ArrayList();
            int i = 0;
            while (i < SERVLET_INTERFACES.length) {
                this.interfaceList.add(SERVLET_INTERFACES[i]);
                ++i;
            }
        }
        return this.interfaceList;
    }

    /*
     * Exception decompiling
     */
    private IStatus validateDisplayName(String prop) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 221->224)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Boolean shouldDefaultAnnotations() {
        if (useAnnotations) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

