/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;

public class PathHelper {
    public static final String BACKWARD_SLASH = "\\";
    public static final String FORWARD_SLASH = "/";
    public static final String RELATIVE_PATH_SIG = "../";

    public static String adjustPath(String path) {
        int i = 0;
        while ((i = path.indexOf(RELATIVE_PATH_SIG)) > 0) {
            String part1 = path.substring(0, i - 1);
            String part2 = path.substring(i + RELATIVE_PATH_SIG.length() - 1);
            int j = part1.lastIndexOf(FORWARD_SLASH);
            if (j == -1) {
                return "";
            }
            part1 = part1.substring(0, j);
            path = String.valueOf(part1) + part2;
        }
        return path;
    }

    public static String appendTrailingURLSlash(String input) {
        if (!input.endsWith(FORWARD_SLASH)) {
            input = String.valueOf(input) + FORWARD_SLASH;
        }
        return input;
    }

    public static String convertToRelative(String input, String base) {
        StringTokenizer inputTokenizer = new StringTokenizer(input, FORWARD_SLASH);
        StringTokenizer baseTokenizer = new StringTokenizer(base, FORWARD_SLASH);
        String token1 = "";
        String token2 = "";
        while (inputTokenizer.hasMoreTokens() && baseTokenizer.hasMoreTokens() && (token1 = baseTokenizer.nextToken()).equals(token2 = inputTokenizer.nextToken())) {
        }
        String output = "";
        while (baseTokenizer.hasMoreTokens()) {
            baseTokenizer.nextToken();
            output = String.valueOf(output) + RELATIVE_PATH_SIG;
        }
        output = String.valueOf(output) + token2;
        while (inputTokenizer.hasMoreTokens()) {
            output = String.valueOf(output) + FORWARD_SLASH + inputTokenizer.nextToken();
        }
        return output;
    }

    public static String getContainingFolderPath(String path) {
        int filePathSlashIndex;
        String retValue = path;
        int urlSlashIndex = path.lastIndexOf(FORWARD_SLASH);
        int index = filePathSlashIndex = path.lastIndexOf(File.separator);
        if (urlSlashIndex > filePathSlashIndex) {
            index = urlSlashIndex;
        }
        if (index >= 0) {
            retValue = path.substring(0, index);
        }
        return retValue;
    }

    public static String removeLeadingPathSeparator(String path) {
        if (path.startsWith(File.separator)) {
            path = path.substring(File.separator.length());
        }
        return path;
    }

    public static String removeLeadingSeparator(String path) {
        if (path.startsWith(File.separator)) {
            path = path.substring(File.separator.length());
        } else if (path.startsWith(FORWARD_SLASH) || path.startsWith(BACKWARD_SLASH)) {
            path = path.substring(FORWARD_SLASH.length());
        }
        return path;
    }

    public static String switchToFilePathSlashes(String path) {
        path = path.replace(FORWARD_SLASH.charAt(0), File.separatorChar);
        path = path.replace(BACKWARD_SLASH.charAt(0), File.separatorChar);
        return path;
    }

    public static String switchToForwardSlashes(String path) {
        path = path.replace(File.separatorChar, FORWARD_SLASH.charAt(0));
        path = path.replace(BACKWARD_SLASH.charAt(0), FORWARD_SLASH.charAt(0));
        return path;
    }
}

