/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.debugger;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.php.debug.core.Logger;
import org.eclipse.php.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;

public class PHPWebServerDebuggerInitializer {
    private ILaunch launch;

    public PHPWebServerDebuggerInitializer(ILaunch iLaunch) {
        this.launch = iLaunch;
    }

    public void debug() throws DebugException {
        IDebugParametersInitializer iDebugParametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(this.launch.getLaunchMode());
        String string = String.valueOf(this.launch.getAttribute("uriginalURL")) + "?" + iDebugParametersInitializer.generateQuery(this.launch);
        try {
            this.connect(new URL(string), Integer.parseInt(this.launch.getAttribute("port")), false);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.logException("Malformed URL Exception " + string, malformedURLException);
            String string2 = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string2, (Throwable)malformedURLException));
        }
    }

    private void connect(URL uRL, int n, boolean bl) throws DebugException {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            String string = uRLConnection.getHeaderFieldKey(1);
            if (string == null) {
                Logger.log(2, "No HeaderKey returned by server. Most likely not started");
                String string2 = PHPDebugCoreMessages.DebuggerConnection_Problem_1;
                throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string2, null));
            }
            int n2 = 1;
            while ((string = uRLConnection.getHeaderFieldKey(n2)) != null) {
                if (string.equals("X-Zend-Debug-Server")) {
                    String string3 = uRLConnection.getHeaderField(string);
                    if (string3.equals("OK")) break;
                    Logger.log(2, "Unexpected Header Value returned by Server. " + string3);
                    String string4 = String.valueOf(PHPDebugCoreMessages.DebuggerConnection_Problem_2) + " - " + string3;
                    throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string4, null));
                }
                ++n2;
            }
            InputStream inputStream = uRLConnection.getInputStream();
            while (inputStream.read() != -1) {
            }
        }
        catch (UnknownHostException unknownHostException) {
            Logger.log(2, "Unknown Host Exception.");
            String string = PHPDebugCoreMessages.DebuggerConnection_Problem_3;
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string, (Throwable)unknownHostException));
        }
        catch (ConnectException connectException) {
            Logger.logException("Unable to connect to URL " + uRL, connectException);
            String string = MessageFormat.format(PHPDebugCoreMessages.DebuggerConnection_Failed_1, uRL.toString());
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string, null));
        }
        catch (IOException iOException) {
            Logger.logException("Unable to connect to URL " + uRL, iOException);
            String string = MessageFormat.format(PHPDebugCoreMessages.DebuggerConnection_Failed_1, uRL.toString());
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string, null));
        }
        catch (Exception exception) {
            Logger.logException("Unexpected exception communicating with server", exception);
            String string = exception.getMessage();
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string, (Throwable)exception));
        }
    }
}

