/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class SourceRangeComputer {
    private final ISourceRange fSourceRange;
    private final String fCuSource;

    private SourceRangeComputer(ISourceRange sourceRange, String cuSource) {
        this.fSourceRange = sourceRange;
        this.fCuSource = cuSource;
    }

    public static String computeSource(ISourceReference elem) throws JavaModelException {
        String cuSource = SourceRangeComputer.getCuSource(elem);
        ISourceRange range = SourceRangeComputer.computeSourceRange(elem, cuSource);
        return cuSource.substring(range.getOffset(), range.getOffset() + range.getLength());
    }

    private static String getCuSource(ISourceReference elem) throws JavaModelException {
        ICompilationUnit cu = SourceReferenceUtil.getCompilationUnit(elem);
        if (cu != null && cu.exists()) {
            return cu.getSource();
        }
        if (elem instanceof IMember) {
            IMember member = (IMember)elem;
            if (!member.isBinary()) {
                return null;
            }
            IClassFile classFile = (IClassFile)member.getAncestor(6);
            if (classFile == null) {
                return null;
            }
            return classFile.getSource();
        }
        return null;
    }

    public static ISourceRange computeSourceRange(ISourceReference element, String cuSource) throws JavaModelException {
        if (!element.exists()) {
            return element.getSourceRange();
        }
        if (cuSource == null) {
            return element.getSourceRange();
        }
        return SourceRangeComputer.computeSourceRange(element.getSourceRange(), cuSource);
    }

    public static ISourceRange computeSourceRange(ISourceRange sourceRange, String cuSource) {
        SourceRangeComputer inst = new SourceRangeComputer(sourceRange, cuSource);
        try {
            int offset = inst.computeOffset();
            int end = inst.computeEnd();
            return new SourceRange(offset, end - offset);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
            return null;
        }
    }

    private int computeEnd() throws BadLocationException {
        int end = this.fSourceRange.getOffset() + this.fSourceRange.getLength();
        try {
            IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
            scanner.setSource(this.fCuSource.toCharArray());
            scanner.resetTo(end, this.fCuSource.length() - 1);
            Document document = new Document(this.fCuSource);
            int startLine = document.getLineOfOffset(scanner.getCurrentTokenEndPosition() + 1);
            int token = scanner.getNextToken();
            while (token != 158) {
                switch (token) {
                    case 1000: {
                        break;
                    }
                    case 64: {
                        break;
                    }
                    case 1001: {
                        if (startLine == document.getLineOfOffset(scanner.getCurrentTokenStartPosition() + 1)) break;
                        return this.stopProcessing(end, scanner, (IDocument)document, startLine);
                    }
                    case 1002: {
                        if (startLine == document.getLineOfOffset(scanner.getCurrentTokenStartPosition() + 1)) break;
                        return this.stopProcessing(end, scanner, (IDocument)document, startLine);
                    }
                    default: {
                        return this.stopProcessing(end, scanner, (IDocument)document, startLine);
                    }
                }
                token = scanner.getNextToken();
            }
            return end;
        }
        catch (InvalidInputException invalidInputException) {
            return end;
        }
    }

    private int stopProcessing(int end, IScanner scanner, IDocument buff, int startLine) throws BadLocationException {
        int currentTokenEndLine;
        int currentTokenStartLine = buff.getLineOfOffset(scanner.getCurrentTokenStartPosition() + 1);
        if (this.endOnCurrentTokenStart(startLine, currentTokenStartLine, currentTokenEndLine = buff.getLineOfOffset(scanner.getCurrentTokenEndPosition() + 1))) {
            return scanner.getCurrentTokenEndPosition() - scanner.getCurrentTokenSource().length + 1;
        }
        IRegion tokenStartLine = buff.getLineInformation(currentTokenStartLine);
        if (tokenStartLine != null) {
            return tokenStartLine.getOffset();
        }
        return end;
    }

    private boolean endOnCurrentTokenStart(int startLine, int currentTokenStartLine, int currentTokenEndLine) {
        if (startLine == currentTokenEndLine) {
            return true;
        }
        return startLine == currentTokenStartLine && currentTokenStartLine != currentTokenEndLine;
    }

    private int computeOffset() throws BadLocationException {
        int offset = this.fSourceRange.getOffset();
        try {
            Document document = new Document(this.fCuSource);
            int lineOffset = document.getLineInformationOfOffset(offset).getOffset();
            IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
            scanner.setSource(document.get().toCharArray());
            scanner.resetTo(lineOffset, document.getLength() - 1);
            int token = scanner.getNextToken();
            while (token != 158) {
                switch (token) {
                    case 1000: {
                        break;
                    }
                    case 64: {
                        break;
                    }
                    default: {
                        if (scanner.getCurrentTokenStartPosition() == offset) {
                            return lineOffset;
                        }
                        return offset;
                    }
                }
                token = scanner.getNextToken();
            }
            return offset;
        }
        catch (InvalidInputException invalidInputException) {
            return offset;
        }
    }
}

