/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.ContributorTrackingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.internal.navigator.extensions.OverridePolicy;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;

public class NavigatorContentServiceContentProvider
implements ITreeContentProvider,
ITreePathContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final NavigatorContentService contentService;
    private final boolean isContentServiceSelfManaged;
    private Viewer viewer;

    public NavigatorContentServiceContentProvider(String aViewerId) {
        this.contentService = new NavigatorContentService(aViewerId);
        this.isContentServiceSelfManaged = true;
    }

    public NavigatorContentServiceContentProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.isContentServiceSelfManaged = false;
    }

    public synchronized Object[] getElements(Object anInputElement) {
        Set rootContentExtensions = this.contentService.findRootContentExtensions(anInputElement);
        if (rootContentExtensions.size() == 0) {
            return NO_CHILDREN;
        }
        ContributorTrackingSet finalElementsSet = new ContributorTrackingSet(this.contentService);
        ContributorTrackingSet localSet = new ContributorTrackingSet(this.contentService);
        Object[] contributedChildren = null;
        Iterator itr = rootContentExtensions.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension foundExtension = (NavigatorContentExtension)itr.next();
            try {
                if (this.isOverridingExtensionInSet(foundExtension.getDescriptor(), rootContentExtensions)) continue;
                contributedChildren = foundExtension.internalGetContentProvider().getElements(anInputElement);
                localSet.setContents(contributedChildren);
                NavigatorContentExtension[] overridingExtensions = foundExtension.getOverridingExtensionsForTriggerPoint(anInputElement);
                if (overridingExtensions.length > 0) {
                    localSet = this.pipelineElements(anInputElement, overridingExtensions, localSet);
                }
                finalElementsSet.addAll(localSet);
            }
            catch (RuntimeException re) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), re);
            }
            catch (Error e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), e);
            }
        }
        return finalElementsSet.toArray();
    }

    public synchronized Object[] getChildren(Object aParentElement) {
        return this.internalGetChildren(aParentElement);
    }

    private Object[] internalGetChildren(Object aParentElementOrPath) {
        Object aParentElement = this.internalAsElement(aParentElementOrPath);
        Set enabledExtensions = this.contentService.findContentExtensionsByTriggerPoint(aParentElement);
        if (enabledExtensions.size() == 0) {
            return NO_CHILDREN;
        }
        ContributorTrackingSet finalChildrenSet = new ContributorTrackingSet(this.contentService);
        ContributorTrackingSet localSet = new ContributorTrackingSet(this.contentService);
        Object[] contributedChildren = null;
        Iterator itr = enabledExtensions.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension foundExtension = (NavigatorContentExtension)itr.next();
            try {
                if (this.isOverridingExtensionInSet(foundExtension.getDescriptor(), enabledExtensions)) continue;
                contributedChildren = foundExtension.internalGetContentProvider().getChildren(aParentElementOrPath);
                NavigatorContentExtension[] overridingExtensions = foundExtension.getOverridingExtensionsForTriggerPoint(aParentElement);
                localSet.setContents(contributedChildren);
                if (overridingExtensions.length > 0) {
                    localSet = this.pipelineChildren(aParentElement, overridingExtensions, localSet);
                }
                finalChildrenSet.addAll(localSet);
            }
            catch (RuntimeException re) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), re);
            }
            catch (Error e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), e);
            }
        }
        return finalChildrenSet.toArray();
    }

    private ContributorTrackingSet pipelineChildren(Object aParentOrPath, NavigatorContentExtension[] theOverridingExtensions, ContributorTrackingSet theCurrentChildren) {
        ContributorTrackingSet pipelinedChildren = theCurrentChildren;
        int i = 0;
        while (i < theOverridingExtensions.length) {
            if (theOverridingExtensions[i].getContentProvider() instanceof IPipelinedTreeContentProvider) {
                IPipelinedTreeContentProvider pipelinedContentProvider = (IPipelinedTreeContentProvider)theOverridingExtensions[i].getContentProvider();
                pipelinedChildren.setContributor((NavigatorContentDescriptor)theOverridingExtensions[i].getDescriptor());
                pipelinedContentProvider.getPipelinedChildren(aParentOrPath, pipelinedChildren);
                pipelinedChildren.setContributor(null);
                NavigatorContentExtension[] overridingExtensions = theOverridingExtensions[i].getOverridingExtensionsForTriggerPoint(aParentOrPath);
                if (overridingExtensions.length > 0) {
                    pipelinedChildren = this.pipelineChildren(aParentOrPath, overridingExtensions, pipelinedChildren);
                }
            }
            ++i;
        }
        return pipelinedChildren;
    }

    private ContributorTrackingSet pipelineElements(Object anInputElement, NavigatorContentExtension[] theOverridingExtensions, ContributorTrackingSet theCurrentElements) {
        ContributorTrackingSet pipelinedElements = theCurrentElements;
        int i = 0;
        while (i < theOverridingExtensions.length) {
            if (theOverridingExtensions[i].getContentProvider() instanceof IPipelinedTreeContentProvider) {
                IPipelinedTreeContentProvider pipelinedContentProvider = (IPipelinedTreeContentProvider)theOverridingExtensions[i].getContentProvider();
                pipelinedElements.setContributor((NavigatorContentDescriptor)theOverridingExtensions[i].getDescriptor());
                pipelinedContentProvider.getPipelinedElements(anInputElement, pipelinedElements);
                pipelinedElements.setContributor(null);
                NavigatorContentExtension[] overridingExtensions = theOverridingExtensions[i].getOverridingExtensionsForTriggerPoint(anInputElement);
                if (overridingExtensions.length > 0) {
                    pipelinedElements = this.pipelineElements(anInputElement, overridingExtensions, pipelinedElements);
                }
            }
            ++i;
        }
        return pipelinedElements;
    }

    private boolean isOverridingExtensionInSet(INavigatorContentDescriptor aDescriptor, Set theEnabledExtensions) {
        return aDescriptor.getSuppressedExtensionId() != null && aDescriptor.getOverridePolicy() == OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt && theEnabledExtensions.contains(this.contentService.getExtension(aDescriptor.getOverriddenDescriptor()));
    }

    private boolean isOverridingDescriptorInSet(INavigatorContentDescriptor aDescriptor, Set theEnabledDescriptors) {
        return aDescriptor.getSuppressedExtensionId() != null && aDescriptor.getOverridePolicy() == OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt && theEnabledDescriptors.contains(aDescriptor.getOverriddenDescriptor());
    }

    public synchronized Object getParent(Object anElement) {
        Set extensions = this.contentService.findContentExtensionsWithPossibleChild(anElement);
        Iterator itr = extensions.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension foundExtension = (NavigatorContentExtension)itr.next();
            try {
                if (this.isOverridingExtensionInSet(foundExtension.getDescriptor(), extensions)) continue;
                Object parent = foundExtension.internalGetContentProvider().getParent(anElement);
                NavigatorContentExtension[] overridingExtensions = foundExtension.getOverridingExtensionsForPossibleChild(anElement);
                if (overridingExtensions.length > 0) {
                    parent = this.pipelineParent(anElement, overridingExtensions, parent);
                }
                if (parent == null) continue;
                return parent;
            }
            catch (RuntimeException re) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), re);
            }
            catch (Error e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), e);
            }
        }
        return null;
    }

    private Object pipelineParent(Object anInputElement, NavigatorContentExtension[] theOverridingExtensions, Object theCurrentParent) {
        Object aSuggestedParent = null;
        int i = 0;
        while (i < theOverridingExtensions.length) {
            if (theOverridingExtensions[i].getContentProvider() instanceof IPipelinedTreeContentProvider) {
                IPipelinedTreeContentProvider pipelinedContentProvider = (IPipelinedTreeContentProvider)theOverridingExtensions[i].getContentProvider();
                aSuggestedParent = pipelinedContentProvider.getPipelinedParent(anInputElement, aSuggestedParent);
                NavigatorContentExtension[] overridingExtensions = theOverridingExtensions[i].getOverridingExtensionsForTriggerPoint(anInputElement);
                if (overridingExtensions.length > 0) {
                    aSuggestedParent = this.pipelineParent(anInputElement, overridingExtensions, aSuggestedParent);
                }
            }
            ++i;
        }
        return aSuggestedParent != null ? aSuggestedParent : theCurrentParent;
    }

    public synchronized boolean hasChildren(Object anElement) {
        Set resultInstances = this.contentService.findContentExtensionsByTriggerPoint(anElement);
        Iterator itr = resultInstances.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension ext = (NavigatorContentExtension)itr.next();
            if (!ext.isLoaded()) {
                return true;
            }
            if (!ext.internalGetContentProvider().hasChildren(anElement)) continue;
            return true;
        }
        return false;
    }

    public synchronized void dispose() {
        if (this.isContentServiceSelfManaged) {
            this.contentService.dispose();
        }
    }

    public synchronized void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
        this.contentService.updateService(aViewer, anOldInput, aNewInput);
    }

    public Object[] getChildren(TreePath parentPath) {
        return this.internalGetChildren(parentPath);
    }

    public boolean hasChildren(TreePath path) {
        Object anElement = this.internalAsElement(path);
        Set resultInstances = this.contentService.findContentExtensionsByTriggerPoint(anElement);
        Iterator itr = resultInstances.iterator();
        while (itr.hasNext()) {
            ITreePathContentProvider tpcp;
            NavigatorContentExtension ext = (NavigatorContentExtension)itr.next();
            if (!ext.isLoaded()) {
                return true;
            }
            ITreeContentProvider cp = ext.internalGetContentProvider();
            if (!(cp instanceof ITreePathContentProvider ? (tpcp = (ITreePathContentProvider)cp).hasChildren(path) : cp.hasChildren(anElement))) continue;
            return true;
        }
        return false;
    }

    public TreePath[] getParents(Object anElement) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        TreePathCompiler compiler = new TreePathCompiler(anElement);
        Set compilers = this.findPaths(compiler);
        Iterator iter = compilers.iterator();
        while (iter.hasNext()) {
            TreePathCompiler c = (TreePathCompiler)iter.next();
            paths.add(c.createParentPath());
        }
        return paths.toArray(new TreePath[paths.size()]);
    }

    private Object internalAsElement(Object parentElementOrPath) {
        if (parentElementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)parentElementOrPath;
            if (tp.getSegmentCount() > 0) {
                return tp.getLastSegment();
            }
            return this.viewer.getInput();
        }
        return parentElementOrPath;
    }

    private Set findPaths(TreePathCompiler aPathCompiler) {
        Set parents = this.findParents(aPathCompiler.getFirstSegment());
        HashSet<TreePathCompiler> parentPaths = new HashSet<TreePathCompiler>();
        Set foundPaths = Collections.EMPTY_SET;
        if (parents.size() > 0) {
            Iterator parentIter = parents.iterator();
            while (parentIter.hasNext()) {
                Object parent = parentIter.next();
                TreePathCompiler c = new TreePathCompiler(aPathCompiler);
                c.addParent(parent);
                foundPaths = this.findPaths(c);
                if (foundPaths.isEmpty()) {
                    parentPaths.add(c);
                    continue;
                }
                parentPaths.addAll(foundPaths);
            }
        }
        return parentPaths;
    }

    private Set findParents(Object anElement) {
        Set descriptors = this.contentService.findDescriptorsWithPossibleChild(anElement, false);
        HashSet<Object> parents = new HashSet<Object>();
        Object parent = null;
        Iterator itr = descriptors.iterator();
        while (itr.hasNext()) {
            NavigatorContentDescriptor foundDescriptor = (NavigatorContentDescriptor)itr.next();
            NavigatorContentExtension foundExtension = this.contentService.getExtension(foundDescriptor);
            try {
                if (this.isOverridingDescriptorInSet(foundExtension.getDescriptor(), descriptors)) continue;
                if (foundExtension.getContentProvider() instanceof ITreePathContentProvider) {
                    TreePath[] parentTreePaths = ((ITreePathContentProvider)foundExtension.internalGetContentProvider()).getParents(anElement);
                    int i = 0;
                    while (i < parentTreePaths.length) {
                        parent = parentTreePaths[i].getLastSegment();
                        if ((parent = this.findParent(foundExtension, anElement, parent)) != null) {
                            parents.add(parent);
                        }
                        ++i;
                    }
                    continue;
                }
                parent = foundExtension.internalGetContentProvider().getParent(anElement);
                if ((parent = this.findParent(foundExtension, anElement, parent)) == null) continue;
                parents.add(parent);
            }
            catch (RuntimeException re) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), re);
            }
            catch (Error e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), e);
            }
        }
        return parents;
    }

    private Object findParent(NavigatorContentExtension anExtension, Object anElement, Object aSuggestedParent) {
        Object lastValidParent = aSuggestedParent;
        Object suggestedOverriddenParent = null;
        NavigatorContentExtension[] overridingExtensions = anExtension.getOverridingExtensionsForPossibleChild(anElement);
        int i = 0;
        while (i < overridingExtensions.length) {
            if (overridingExtensions[i].getContentProvider() instanceof IPipelinedTreeContentProvider) {
                IPipelinedTreeContentProvider piplineContentProvider = (IPipelinedTreeContentProvider)overridingExtensions[i].getContentProvider();
                suggestedOverriddenParent = piplineContentProvider.getPipelinedParent(anElement, lastValidParent);
                if (suggestedOverriddenParent != null) {
                    lastValidParent = suggestedOverriddenParent;
                }
                lastValidParent = this.findParent(overridingExtensions[i], anElement, lastValidParent);
            }
            ++i;
        }
        return lastValidParent;
    }

    class TreePathCompiler {
        private final LinkedList segments = new LinkedList();

        public TreePathCompiler(Object segment) {
            this.segments.add(segment);
        }

        public TreePathCompiler(TreePathCompiler aCompiler) {
            this.segments.addAll(aCompiler.segments);
        }

        public TreePathCompiler(TreePath aPath) {
            int i = 0;
            while (i < aPath.getSegmentCount()) {
                this.segments.addLast(aPath.getSegment(i));
                ++i;
            }
        }

        public void addParent(Object segment) {
            this.segments.addFirst(segment);
        }

        public void addChild(Object segment) {
            this.segments.addLast(segment);
        }

        public TreePath createPath() {
            return new TreePath(this.segments.toArray());
        }

        public TreePath createParentPath() {
            LinkedList parentSegments = new LinkedList(this.segments);
            parentSegments.removeLast();
            return new TreePath(parentSegments.toArray());
        }

        public Object getLastSegment() {
            return this.segments.getLast();
        }

        public Object getFirstSegment() {
            return this.segments.getFirst();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            Iterator iter = this.segments.iterator();
            while (iter.hasNext()) {
                Object segment = iter.next();
                buffer.append(segment).append("::");
            }
            return buffer.toString();
        }
    }
}

