/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.ui.actions.FoldingMessages;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;

public class FoldingActionGroup
extends ActionGroup {
    private ProjectionViewer fViewer;
    private PreferenceAction fToggle;
    private TextOperationAction fExpand;
    private TextOperationAction fCollapse;
    private TextOperationAction fExpandAll;
    private IProjectionListener fProjectionListener;
    static /* synthetic */ Class class$0;

    public FoldingActionGroup(final ITextEditor iTextEditor, ITextViewer iTextViewer) {
        if (iTextViewer instanceof ProjectionViewer) {
            this.fViewer = (ProjectionViewer)iTextViewer;
            this.fProjectionListener = new IProjectionListener(){

                public void projectionEnabled() {
                    FoldingActionGroup.this.update();
                }

                public void projectionDisabled() {
                    FoldingActionGroup.this.update();
                }
            };
            this.fViewer.addProjectionListener(this.fProjectionListener);
            this.fToggle = new PreferenceAction(FoldingMessages.getResourceBundle(), "Projection.Toggle.", 2){

                public void run() {
                    IPreferenceStore iPreferenceStore;
                    boolean bl = (iPreferenceStore = PHPUiPlugin.getDefault().getPreferenceStore()).getBoolean("foldingEnabled");
                    iPreferenceStore.setValue("foldingEnabled", !bl);
                    SSEUIPlugin.getDefault().getPreferenceStore().setValue("foldingEnabled", !bl);
                }

                public void update() {
                    ITextOperationTarget iTextOperationTarget;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    boolean bl = (iTextOperationTarget = (ITextOperationTarget)iTextEditor.getAdapter((Class)clazz)) != null && iTextOperationTarget.canDoOperation(19);
                    this.setEnabled(bl);
                }
            };
            this.fToggle.setChecked(PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("foldingEnabled"));
            this.fToggle.setActionDefinitionId("org.eclipse.ui.edit.text.folding.toggle");
            iTextEditor.setAction("FoldingToggle", (IAction)this.fToggle);
            this.fExpandAll = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.ExpandAll.", iTextEditor, 20, true);
            this.fExpandAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand_all");
            iTextEditor.setAction("FoldingExpandAll", (IAction)this.fExpandAll);
            this.fExpand = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Expand.", iTextEditor, 17, true);
            this.fExpand.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand");
            iTextEditor.setAction("FoldingExpand", (IAction)this.fExpand);
            this.fCollapse = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Collapse.", iTextEditor, 18, true);
            this.fCollapse.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse");
            iTextEditor.setAction("FoldingCollapse", (IAction)this.fCollapse);
        }
    }

    protected boolean isEnabled() {
        return this.fViewer != null;
    }

    public void dispose() {
        if (this.isEnabled()) {
            this.fViewer.removeProjectionListener(this.fProjectionListener);
            this.fViewer = null;
        }
        super.dispose();
    }

    protected void update() {
        if (this.isEnabled()) {
            this.fToggle.update();
            this.fToggle.setChecked(this.fViewer.getProjectionAnnotationModel() != null);
            this.fExpand.update();
            this.fExpandAll.update();
            this.fCollapse.update();
        }
    }

    public void fillMenu(IMenuManager iMenuManager) {
        if (this.isEnabled()) {
            this.update();
            iMenuManager.add((IAction)this.fToggle);
            iMenuManager.add((IAction)this.fExpandAll);
            iMenuManager.add((IAction)this.fExpand);
            iMenuManager.add((IAction)this.fCollapse);
        }
    }

    public void updateActionBars() {
        this.update();
    }

    static abstract class PreferenceAction
    extends ResourceAction
    implements IUpdate {
        PreferenceAction(ResourceBundle resourceBundle, String string, int n) {
            super(resourceBundle, string, n);
        }
    }
}

