/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.PHPElementLabelProvider;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.StandardPHPElementContentProvider;
import org.eclipse.php.ui.util.PHPElementSorter;
import org.eclipse.php.ui.util.StatusInfo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ProjectSelectionDialog
extends SelectionStatusDialog {
    private TableViewer fTableViewer;
    private Set fProjectsWithSpecifics;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private static final String DIALOG_SETTINGS_SHOW_ALL = "ProjectSelectionDialog.show_all";
    private ViewerFilter fFilter;

    public ProjectSelectionDialog(Shell shell, Set set) {
        super(shell);
        this.setTitle(PHPUIMessages.ProjectSelectionDialog_title);
        this.setMessage(PHPUIMessages.ProjectSelectionDialog_desciption);
        this.fProjectsWithSpecifics = set;
        int n = this.getShellStyle();
        this.setShellStyle(n | 0x400 | 0x10);
        this.fFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                return ProjectSelectionDialog.this.fProjectsWithSpecifics.contains(object2);
            }
        };
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Font font = composite.getFont();
        composite2.setFont(font);
        this.createMessageArea(composite2);
        this.fTableViewer = new TableViewer(composite2, 2816);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ProjectSelectionDialog.this.doSelectionChanged(((IStructuredSelection)selectionChangedEvent.getSelection()).toArray());
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 250;
        gridData.widthHint = 300;
        this.fTableViewer.getTable().setLayoutData((Object)gridData);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new PHPElementLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new StandardPHPElementContentProvider());
        this.fTableViewer.setSorter((ViewerSorter)new PHPElementSorter());
        this.fTableViewer.getControl().setFont(font);
        Button button = new Button(composite2, 32);
        button.setText(PHPUIMessages.ProjectSelectionDialog_filter);
        button.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProjectSelectionDialog.this.updateFilter(((Button)selectionEvent.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ProjectSelectionDialog.this.updateFilter(((Button)selectionEvent.widget).getSelection());
            }
        });
        IDialogSettings iDialogSettings = PHPUiPlugin.getDefault().getDialogSettings();
        boolean bl = !iDialogSettings.getBoolean(DIALOG_SETTINGS_SHOW_ALL) && !this.fProjectsWithSpecifics.isEmpty();
        button.setSelection(bl);
        this.updateFilter(bl);
        this.fTableViewer.setInput((Object)PHPWorkspaceModelManager.getInstance());
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void updateFilter(boolean bl) {
        if (bl) {
            this.fTableViewer.addFilter(this.fFilter);
        } else {
            this.fTableViewer.removeFilter(this.fFilter);
        }
        PHPUiPlugin.getDefault().getDialogSettings().put(DIALOG_SETTINGS_SHOW_ALL, !bl);
    }

    private void doSelectionChanged(Object[] objectArray) {
        if (objectArray.length != 1) {
            this.updateStatus(new StatusInfo(4, ""));
            this.setSelectionResult(null);
        } else {
            this.updateStatus(new StatusInfo());
            this.setSelectionResult(objectArray);
        }
    }

    protected void computeResult() {
    }
}

