/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.project.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.project.ui.wizards.PHPProjectWizardBasePage;
import org.eclipse.php.ui.preferences.IStatusChangeListener;
import org.eclipse.php.ui.preferences.ui.PHPVersionConfigurationBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class PHPVersionGroup
implements SelectionListener {
    private final Group fGroup;
    private final Link fPreferenceLink;
    private final PHPProjectWizardBasePage fPage;
    protected Button fEnableProjectSettings;
    protected PHPVersionConfigurationBlock fConfigurationBlock;

    public PHPVersionGroup(Composite composite, PHPProjectWizardBasePage pHPProjectWizardBasePage) {
        this.fPage = pHPProjectWizardBasePage;
        this.fGroup = new Group(composite, 0);
        this.fGroup.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        this.fGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.fGroup.setLayoutData((Object)gridData);
        this.fGroup.setText(PHPUIMessages.PHPVersionGroup_OptionBlockTitle);
        Composite composite2 = new Composite((Composite)this.fGroup, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.fEnableProjectSettings = new Button(composite2, 32);
        this.fEnableProjectSettings.setText(PHPUIMessages.PHPVersionGroup_EnableProjectSettings);
        this.fEnableProjectSettings.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fEnableProjectSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPVersionGroup.this.updateEnableState();
            }
        });
        this.fPreferenceLink = new Link(composite2, 0);
        this.fPreferenceLink.setFont(this.fGroup.getFont());
        this.fPreferenceLink.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        this.fPreferenceLink.setText(PHPUIMessages.PHPVersionGroup_ConfigWorkspaceSettings);
        this.fPreferenceLink.addSelectionListener((SelectionListener)this);
        Composite composite3 = new Composite((Composite)this.fGroup, 0);
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite3.setLayout((Layout)new GridLayout(2, false));
        this.fConfigurationBlock = this.createConfigurationBlock(this.getNewStatusChangedListener(), this.getProject(), null);
        this.fConfigurationBlock.createContents(composite3);
        this.fConfigurationBlock.setEnabled(false);
    }

    private void updateEnableState() {
        if (this.fEnableProjectSettings.getSelection()) {
            this.fConfigurationBlock.setEnabled(true);
        } else {
            this.fConfigurationBlock.performRevert();
            this.fConfigurationBlock.setEnabled(false);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.widgetDefaultSelected(selectionEvent);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        String string = "org.eclipse.php.ui.preferences.ui.PHPBasePreferencePage";
        Object var3_3 = null;
        PreferencesUtil.createPreferenceDialogOn((Shell)this.fPage.getShell(), (String)string, (String[])new String[]{string}, var3_3).open();
        if (!this.fEnableProjectSettings.getSelection()) {
            this.fConfigurationBlock.performRevert();
        }
    }

    protected IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject("DUMMY______________Project");
    }

    protected IStatusChangeListener getNewStatusChangedListener() {
        return new IStatusChangeListener(){

            public void statusChanged(IStatus iStatus) {
            }
        };
    }

    public void setPropertiesInDataModel(IDataModel iDataModel) {
        if (this.fEnableProjectSettings.getSelection()) {
            String string = this.fConfigurationBlock.getPHPVersionValue();
            boolean bl = this.fConfigurationBlock.getUseAspTagsValue();
            iDataModel.setBooleanProperty("use_asp_tags_as_php", bl);
            iDataModel.setStringProperty("phpVersion", string);
        }
    }

    protected PHPVersionConfigurationBlock createConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        return new PHPVersionConfigurationBlock(iStatusChangeListener, iProject, iWorkbenchPreferenceContainer);
    }

    public PHPVersionConfigurationBlock getVersionBlock() {
        return this.fConfigurationBlock;
    }
}

