/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.projectOutline;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.php.internal.ui.actions.OpenEditorActionGroup;
import org.eclipse.php.ui.actions.SortAction;
import org.eclipse.php.ui.projectOutline.CollapseAllAction;
import org.eclipse.php.ui.projectOutline.ProjectOutlinePart;
import org.eclipse.php.ui.projectOutline.ToggleLinkingAction;
import org.eclipse.php.ui.workingset.ViewActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;

public class ProjectOutlineViewGroup
extends ViewActionGroup {
    public static final int PHP4 = 1;
    public static final int PHP5 = 2;
    private ProjectOutlinePart fPart;
    private ToggleAllAction toggleAllAction;
    private SortAction sortAction;
    private ToggleLinkingAction toggleLinking;
    private CollapseAllAction collapseAllAction;
    private OpenEditorActionGroup fOpenEditorActionGroup;

    public ProjectOutlineViewGroup(ProjectOutlinePart projectOutlinePart) {
        this.fPart = projectOutlinePart;
        this.toggleAllAction = new ToggleAllAction(this);
        this.toggleAllAction.setText("Show All");
        this.sortAction = new SortAction(projectOutlinePart.getViewer());
        this.collapseAllAction = new CollapseAllAction(projectOutlinePart);
        this.toggleLinking = new ToggleLinkingAction(projectOutlinePart);
        this.fOpenEditorActionGroup = new OpenEditorActionGroup((IViewPart)projectOutlinePart);
    }

    public void dispose() {
        this.fOpenEditorActionGroup.dispose();
        super.dispose();
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.fOpenEditorActionGroup.fillContextMenu(iMenuManager);
        this.toggleAllAction.setChecked(this.fPart.isShowAll());
    }

    void updateActions() {
    }

    public void setMode(int n) {
    }

    void fillToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.collapseAllAction);
        iToolBarManager.add((IAction)this.sortAction);
        iToolBarManager.add((IAction)this.toggleLinking);
    }

    void fillMenu(IMenuManager iMenuManager) {
        this.toggleAllAction.setChecked(this.fPart.isShowAll());
        iMenuManager.add((IAction)this.toggleAllAction);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.fOpenEditorActionGroup.fillActionBars(iActionBars);
        this.fillToolBar(iActionBars.getToolBarManager());
        this.fillMenu(iActionBars.getMenuManager());
    }

    public void setContext(ActionContext actionContext) {
        super.setContext(actionContext);
        this.fOpenEditorActionGroup.setContext(actionContext);
    }

    public void updateActionBars() {
        super.updateActionBars();
        this.fOpenEditorActionGroup.updateActionBars();
    }

    public class ToggleAllAction
    extends Action {
        public ToggleAllAction(ViewActionGroup viewActionGroup) {
            super("", 2);
            Assert.isNotNull((Object)((Object)viewActionGroup));
        }

        public void run() {
            ProjectOutlineViewGroup.this.fPart.setShowAll(this.isChecked());
        }
    }
}

