/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.util;

import java.text.Collator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.ui.MembersOrderPreferenceCache;
import org.eclipse.php.ui.projectOutline.ProjectOutlineContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PHPElementSorter
extends ViewerSorter {
    private static final int PROJECTS = 1;
    private static final int PACKAGEFRAGMENTROOTS = 2;
    private static final int PACKAGEFRAGMENT = 3;
    private static final int COMPILATIONUNITS = 4;
    private static final int CLASSFILES = 5;
    private static final int RESOURCEFOLDERS = 7;
    private static final int RESOURCES = 8;
    private static final int STORAGE = 9;
    private static final int PACKAGE_DECL = 10;
    private static final int IMPORT_CONTAINER = 11;
    private static final int IMPORT_DECLARATION = 12;
    private static final int MEMBERSOFFSET = 15;
    private static final int OUTLINE_NODES = 16;
    private static final int JAVAELEMENTS = 50;
    private static final int OTHERS = 51;
    private MembersOrderPreferenceCache fMemberOrderCache = PHPUiPlugin.getDefault().getMemberOrderPreferenceCache();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.ui.util.PHPElementSorter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PHPElementSorter() {
        super(null);
    }

    public boolean isSorterProperty(Object object, Object object2) {
        return true;
    }

    public int category(Object object) {
        if (object instanceof PHPCodeData) {
            if (object instanceof PHPFunctionData) {
                PHPFunctionData pHPFunctionData = (PHPFunctionData)object;
                int n = pHPFunctionData.getModifiers();
                if (PHPModifier.isStatic((int)n)) {
                    return this.getMemberCategory(7);
                }
                return this.getMemberCategory(3);
            }
            if (object instanceof PHPClassVarData) {
                PHPClassVarData pHPClassVarData = (PHPClassVarData)object;
                int n = pHPClassVarData.getModifiers();
                if (PHPModifier.isStatic((int)n)) {
                    return this.getMemberCategory(6);
                }
                return this.getMemberCategory(5);
            }
            if (object instanceof PHPClassVarData) {
                return this.getMemberCategory(0);
            }
            if (object instanceof PHPClassVarData) {
                return this.getMemberCategory(0);
            }
            if (object instanceof PHPProjectModel) {
                return 1;
            }
            if (object instanceof PHPClassData) {
                return 5;
            }
            if (object instanceof PHPFileData) {
                return 4;
            }
            return 50;
        }
        if (object instanceof IFile) {
            return 8;
        }
        if (object instanceof IProject) {
            return 1;
        }
        if (object instanceof IContainer) {
            return 7;
        }
        if (object instanceof IStorage) {
            return 9;
        }
        if (object instanceof ProjectOutlineContentProvider.OutlineNode) {
            return 16;
        }
        return 51;
    }

    private int getMemberCategory(int n) {
        int n2 = this.fMemberOrderCache.getCategoryIndex(n);
        return n2 + 15;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        int n;
        int n2;
        int n3 = this.category(object);
        if (n3 != (n2 = this.category(object2))) {
            return n3 - n2;
        }
        if (n3 == 1 || n3 == 8 || n3 == 7 || n3 == 9 || n3 == 51) {
            String string = this.getNonPHPElementLabel(viewer, object);
            String string2 = this.getNonPHPElementLabel(viewer, object2);
            if (string != null && string2 != null) {
                return this.getCollator().compare(string, string2);
            }
            return 0;
        }
        if (n3 == 16 && n2 == 16) {
            if (!($assertionsDisabled || object instanceof ProjectOutlineContentProvider.OutlineNode && object2 instanceof ProjectOutlineContentProvider.OutlineNode)) {
                throw new AssertionError();
            }
            return ((Comparable)object).compareTo(object2);
        }
        if (object instanceof PHPCodeData && this.fMemberOrderCache.isSortByVisibility()) {
            int n4 = this.getVisibilityCode(object);
            int n5 = this.getVisibilityCode(object2);
            n = this.fMemberOrderCache.getVisibilityIndex(n4) - this.fMemberOrderCache.getVisibilityIndex(n5);
            if (n != 0) {
                return n;
            }
        }
        String string = this.getElementName(object);
        String string3 = this.getElementName(object2);
        if (object instanceof PHPClassData) {
            if (string.length() == 0) {
                if (string3.length() == 0) {
                    return this.getCollator().compare(((PHPClassData)object).getSuperClassData().getName(), ((PHPClassData)object2).getSuperClassData().getName());
                }
                return 1;
            }
            if (string3.length() == 0) {
                return -1;
            }
        }
        if ((n = this.getCollator().compare(string, string3)) != 0) {
            return n;
        }
        if (object instanceof PHPFunctionData) {
            PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = ((PHPFunctionData)object).getParameters();
            PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray2 = ((PHPFunctionData)object2).getParameters();
            int n6 = Math.min(pHPFunctionParameterArray.length, pHPFunctionParameterArray2.length);
            int n7 = 0;
            while (n7 < n6) {
                n = this.getCollator().compare(pHPFunctionParameterArray[n7].getClassType(), pHPFunctionParameterArray2[n7].getClassType());
                if (n != 0) {
                    return n;
                }
                ++n7;
            }
            return pHPFunctionParameterArray.length - pHPFunctionParameterArray2.length;
        }
        return 0;
    }

    private int getVisibilityCode(Object object) {
        if (object instanceof PHPClassData) {
            PHPClassData pHPClassData = (PHPClassData)object;
            return pHPClassData.getModifiers();
        }
        if (object instanceof PHPFunctionData) {
            PHPFunctionData pHPFunctionData = (PHPFunctionData)object;
            return pHPFunctionData.getModifiers();
        }
        if (object instanceof PHPClassVarData) {
            PHPClassVarData pHPClassVarData = (PHPClassVarData)object;
            return pHPClassVarData.getModifiers();
        }
        return 0;
    }

    private String getNonPHPElementLabel(Viewer viewer, Object object) {
        IBaseLabelProvider iBaseLabelProvider;
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iBaseLabelProvider = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return iBaseLabelProvider.getLabel(object);
            }
        }
        if (viewer instanceof ContentViewer && (iBaseLabelProvider = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            return ((ILabelProvider)iBaseLabelProvider).getText(object);
        }
        return null;
    }

    public final Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        return this.collator;
    }

    private String getElementName(Object object) {
        if (object instanceof PHPCodeData) {
            return ((PHPCodeData)object).getName();
        }
        return object.toString();
    }
}

