/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.workingset;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.workingset.WorkingSetFilterActionGroup;
import org.eclipse.php.ui.workingset.WorkingSetMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;

public class EditWorkingSetAction
extends Action {
    private IWorkbenchPartSite fSite;
    private Shell fShell;
    private WorkingSetFilterActionGroup fActionGroup;

    public EditWorkingSetAction(WorkingSetFilterActionGroup workingSetFilterActionGroup, IWorkbenchPartSite iWorkbenchPartSite) {
        this(workingSetFilterActionGroup);
        this.fSite = iWorkbenchPartSite;
    }

    public EditWorkingSetAction(WorkingSetFilterActionGroup workingSetFilterActionGroup, Shell shell) {
        this(workingSetFilterActionGroup);
        this.fShell = shell;
    }

    private EditWorkingSetAction(WorkingSetFilterActionGroup workingSetFilterActionGroup) {
        super(WorkingSetMessages.EditWorkingSetAction_text);
        Assert.isNotNull((Object)workingSetFilterActionGroup);
        this.setToolTipText(WorkingSetMessages.EditWorkingSetAction_toolTip);
        this.setEnabled(workingSetFilterActionGroup.getWorkingSet() != null);
        this.fActionGroup = workingSetFilterActionGroup;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.edit_working_set_action");
    }

    public void run() {
        Shell shell = this.getShell();
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet iWorkingSet = this.fActionGroup.getWorkingSet();
        if (iWorkingSet == null) {
            this.setEnabled(false);
            return;
        }
        IWorkingSetEditWizard iWorkingSetEditWizard = iWorkingSetManager.createWorkingSetEditWizard(iWorkingSet);
        if (iWorkingSetEditWizard == null) {
            String string = WorkingSetMessages.EditWorkingSetAction_error_nowizard_title;
            String string2 = WorkingSetMessages.EditWorkingSetAction_error_nowizard_message;
            MessageDialog.openError((Shell)shell, (String)string, (String)string2);
            return;
        }
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)iWorkingSetEditWizard);
        wizardDialog.create();
        if (wizardDialog.open() == 0) {
            this.fActionGroup.setWorkingSet(iWorkingSetEditWizard.getSelection(), true);
        }
    }

    private Shell getShell() {
        if (this.fSite != null) {
            return this.fSite.getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return PHPUiPlugin.getActiveWorkbenchShell();
    }
}

