/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.internal.ui.actions.context.StandardActionAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousStepFiltersAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;

public class StepFiltersAdapter
extends StandardActionAdapter
implements IAsynchronousStepFiltersAdapter {
    static /* synthetic */ Class class$0;

    public void supportsStepFilters(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Job job = new Job("supportsStepFilters"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean supported = false;
                IDebugTarget[] debugTargets = StepFiltersAdapter.this.getDebugTargets(element);
                int i = 0;
                while (i < debugTargets.length) {
                    IStepFilters filters = StepFiltersAdapter.this.getTarget(debugTargets[i]);
                    if (filters != null && filters.supportsStepFilters()) {
                        supported = true;
                    }
                    if (supported) break;
                    ++i;
                }
                requestMonitor.setResult(supported);
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setRule(this.createUpdateSchedulingRule());
        job.schedule();
    }

    public void isStepFiltersEnabled(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Job job = new Job("isStepFiltersEnabled"){

            protected IStatus run(IProgressMonitor monitor) {
                IDebugTarget[] debugTargets = StepFiltersAdapter.this.getDebugTargets(element);
                int i = 0;
                while (i < debugTargets.length) {
                    IStepFilters filters = StepFiltersAdapter.this.getTarget(element);
                    if (filters != null) {
                        requestMonitor.setResult(filters.isStepFiltersEnabled());
                    } else {
                        requestMonitor.setResult(false);
                    }
                    ++i;
                }
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setRule(this.createUpdateSchedulingRule());
        job.schedule();
    }

    public void setStepFiltersEnabled(final Object element, final boolean enabled, final IAsynchronousRequestMonitor requestMonitor) {
        Job job = new Job("setStepFiltersEnabled"){

            protected IStatus run(IProgressMonitor monitor) {
                IDebugTarget[] debugTargets = StepFiltersAdapter.this.getDebugTargets(element);
                int i = 0;
                while (i < debugTargets.length) {
                    IStepFilters filters = StepFiltersAdapter.this.getTarget(debugTargets[i]);
                    if (filters != null && filters.isStepFiltersEnabled() != enabled) {
                        filters.setStepFiltersEnabled(enabled);
                    }
                    ++i;
                }
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private IStepFilters getTarget(Object element) {
        if (element instanceof IStepFilters) {
            return (IStepFilters)element;
        }
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IStepFilters");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IStepFilters)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    private IDebugTarget[] getDebugTargets(Object element) {
        if (element instanceof IDebugElement) {
            IDebugElement debugElement = (IDebugElement)element;
            return new IDebugTarget[]{debugElement.getDebugTarget()};
        }
        if (element instanceof ILaunch) {
            ILaunch launch = (ILaunch)element;
            return launch.getDebugTargets();
        }
        if (element instanceof IProcess) {
            IProcess process = (IProcess)element;
            return process.getLaunch().getDebugTargets();
        }
        return new IDebugTarget[0];
    }
}

