/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.junit.launcher.ITestFinder;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;

public class JUnit3TestFinder
implements ITestFinder {
    public void findTestsInContainer(Object[] elements, Set result, IProgressMonitor pm) {
        try {
            TestSearchEngine.doFindJUnit3Tests(elements, result, pm);
        }
        catch (InterruptedException interruptedException) {}
    }

    public boolean isTest(IType type) throws JavaModelException {
        return this.hasSuiteMethod(type) || this.isTestType(type);
    }

    protected boolean hasSuiteMethod(IType type) throws JavaModelException {
        IMethod method = type.getMethod("suite", new String[0]);
        if (method == null || !method.exists()) {
            return false;
        }
        if (!(Flags.isStatic((int)method.getFlags()) && Flags.isPublic((int)method.getFlags()) && Flags.isPublic((int)method.getDeclaringType().getFlags()))) {
            return false;
        }
        return Signature.getSimpleName((String)Signature.toString((String)method.getReturnType())).equals("Test");
    }

    protected boolean isTestType(IType type) throws JavaModelException {
        if (!TestSearchEngine.hasValidModifiers(type)) {
            return false;
        }
        IType[] interfaces = type.newSupertypeHierarchy(null).getAllSuperInterfaces(type);
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getFullyQualifiedName('.').equals("junit.framework.Test")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

