/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationRequest;
import org.apache.catalina.core.ApplicationResponse;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;

final class ApplicationDispatcher
implements RequestDispatcher {
    private ServletRequest appRequest = null;
    private ServletResponse appResponse = null;
    private Context context = null;
    private int debug = 0;
    private boolean including = false;
    private static final String info = "org.apache.catalina.core.ApplicationDispatcher/1.0";
    private String name = null;
    private ServletRequest outerRequest = null;
    private ServletResponse outerResponse = null;
    private String pathInfo = null;
    private String queryString = null;
    private String servletPath = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private InstanceSupport support = null;
    private Wrapper wrapper = null;
    private ServletRequest wrapRequest = null;
    private ServletResponse wrapResponse = null;

    public ApplicationDispatcher(Wrapper wrapper, String servletPath, String pathInfo, String queryString, String name) {
        String jspFile;
        this.wrapper = wrapper;
        this.context = (Context)wrapper.getParent();
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.name = name;
        this.support = wrapper instanceof StandardWrapper ? ((StandardWrapper)wrapper).getInstanceSupport() : new InstanceSupport(wrapper);
        if (this.debug >= 1) {
            this.log("servletPath=" + this.servletPath + ", pathInfo=" + this.pathInfo + ", queryString=" + queryString + ", name=" + this.name);
        }
        if ((jspFile = wrapper.getJspFile()) != null) {
            if (this.debug >= 1) {
                this.log("-->servletPath=" + jspFile);
            }
            this.servletPath = jspFile;
        }
    }

    public String getInfo() {
        return info;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedForward dp = new PrivilegedForward(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                throw (IOException)e;
            }
        } else {
            this.doForward(request, response);
        }
    }

    private void doForward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (response.isCommitted()) {
            if (this.debug >= 1) {
                this.log("  Forward on committed response --> ISE");
            }
            throw new IllegalStateException(sm.getString("applicationDispatcher.forward.ise"));
        }
        try {
            response.resetBuffer();
        }
        catch (IllegalStateException e) {
            if (this.debug >= 1) {
                this.log("  Forward resetBuffer() returned ISE: " + e);
            }
            throw e;
        }
        this.setup(request, response, false);
        HttpServletRequest hrequest = null;
        if (request instanceof HttpServletRequest) {
            hrequest = (HttpServletRequest)request;
        }
        HttpServletResponse hresponse = null;
        if (response instanceof HttpServletResponse) {
            hresponse = (HttpServletResponse)response;
        }
        if (hrequest == null || hresponse == null) {
            if (this.debug >= 1) {
                this.log(" Non-HTTP Forward");
            }
            this.invoke(request, response);
        } else if (this.servletPath == null && this.pathInfo == null) {
            if (this.debug >= 1) {
                this.log(" Named Dispatcher Forward");
            }
            this.invoke(request, response);
        } else {
            if (this.debug >= 1) {
                this.log(" Path Based Forward");
            }
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest();
            StringBuffer sb = new StringBuffer();
            String contextPath = this.context.getPath();
            if (contextPath != null) {
                sb.append(contextPath);
            }
            if (this.servletPath != null) {
                sb.append(this.servletPath);
            }
            if (this.pathInfo != null) {
                sb.append(this.pathInfo);
            }
            wrequest.setContextPath(contextPath);
            wrequest.setRequestURI(sb.toString());
            wrequest.setServletPath(this.servletPath);
            wrequest.setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                wrequest.setQueryString(this.queryString);
                wrequest.mergeParameters(this.queryString);
            }
            this.invoke(this.outerRequest, response);
            this.unwrapRequest();
        }
        if (this.debug >= 1) {
            this.log(" Committing and closing response");
        }
        if (response instanceof ResponseFacade) {
            ((ResponseFacade)response).finish();
        } else {
            try {
                response.flushBuffer();
            }
            catch (IllegalStateException f) {
                // empty catch block
            }
            try {
                PrintWriter writer = response.getWriter();
                writer.flush();
                writer.close();
            }
            catch (IllegalStateException e) {
                try {
                    ServletOutputStream stream = response.getOutputStream();
                    stream.flush();
                    stream.close();
                }
                catch (IllegalStateException f) {
                }
                catch (IOException f) {}
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedInclude dp = new PrivilegedInclude(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                pe.printStackTrace();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                throw (IOException)e;
            }
        } else {
            this.doInclude(request, response);
        }
    }

    private void doInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.setup(request, response, true);
        ServletResponse wresponse = this.wrapResponse();
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            if (this.debug >= 1) {
                this.log(" Non-HTTP Include");
            }
            this.invoke(request, this.outerResponse);
            this.unwrapResponse();
        } else if (this.name != null) {
            if (this.debug >= 1) {
                this.log(" Named Dispatcher Include");
            }
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest();
            wrequest.setAttribute("org.apache.catalina.NAMED", this.name);
            if (this.servletPath != null) {
                wrequest.setServletPath(this.servletPath);
            }
            this.invoke(this.outerRequest, this.outerResponse);
            this.unwrapRequest();
            this.unwrapResponse();
        } else {
            if (this.debug >= 1) {
                this.log(" Path Based Include");
            }
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest();
            StringBuffer sb = new StringBuffer();
            String contextPath = this.context.getPath();
            if (contextPath != null) {
                sb.append(contextPath);
            }
            if (this.servletPath != null) {
                sb.append(this.servletPath);
            }
            if (this.pathInfo != null) {
                sb.append(this.pathInfo);
            }
            if (sb.length() > 0) {
                wrequest.setAttribute("javax.servlet.include.request_uri", sb.toString());
            }
            if (contextPath != null) {
                wrequest.setAttribute("javax.servlet.include.context_path", contextPath);
            }
            if (this.servletPath != null) {
                wrequest.setAttribute("javax.servlet.include.servlet_path", this.servletPath);
            }
            if (this.pathInfo != null) {
                wrequest.setAttribute("javax.servlet.include.path_info", this.pathInfo);
            }
            if (this.queryString != null) {
                wrequest.setAttribute("javax.servlet.include.query_string", this.queryString);
                wrequest.mergeParameters(this.queryString);
            }
            this.invoke(this.outerRequest, this.outerResponse);
            this.unwrapRequest();
            this.unwrapResponse();
        }
    }

    private void invoke(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ClassLoader contextClassLoader;
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        if (oldCCL != (contextClassLoader = this.context.getLoader().getClassLoader())) {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        } else {
            oldCCL = null;
        }
        HttpServletRequest hrequest = null;
        if (request instanceof HttpServletRequest) {
            hrequest = (HttpServletRequest)request;
        }
        HttpServletResponse hresponse = null;
        if (response instanceof HttpServletResponse) {
            hresponse = (HttpServletResponse)response;
        }
        Servlet servlet = null;
        IOException ioException = null;
        Throwable servletException = null;
        RuntimeException runtimeException = null;
        boolean unavailable = false;
        if (this.wrapper.isUnavailable()) {
            this.log(sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            if (hresponse != null) {
                long available = this.wrapper.getAvailable();
                if (available > 0L && available < Long.MAX_VALUE) {
                    hresponse.setDateHeader("Retry-After", available);
                }
                hresponse.sendError(503, sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            }
            unavailable = true;
        }
        try {
            if (!unavailable) {
                servlet = this.wrapper.allocate();
            }
        }
        catch (ServletException e) {
            this.log(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servletException = e;
            servlet = null;
        }
        catch (Throwable e) {
            this.log(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servlet = null;
        }
        try {
            String jspFile = this.wrapper.getJspFile();
            if (jspFile != null) {
                request.setAttribute("org.apache.catalina.jsp_file", (Object)jspFile);
            } else {
                request.removeAttribute("org.apache.catalina.jsp_file");
            }
            this.support.fireInstanceEvent("beforeDispatch", servlet, request, response);
            if (servlet != null) {
                if (hrequest != null && hresponse != null) {
                    servlet.service((ServletRequest)((HttpServletRequest)request), (ServletResponse)((HttpServletResponse)response));
                } else {
                    servlet.service(request, response);
                }
            }
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
        }
        catch (IOException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            ioException = e;
        }
        catch (UnavailableException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            servletException = e;
            this.wrapper.unavailable(e);
        }
        catch (ServletException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            servletException = e;
        }
        catch (RuntimeException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            runtimeException = e;
        }
        try {
            if (servlet != null) {
                this.wrapper.deallocate(servlet);
            }
        }
        catch (ServletException e) {
            this.log(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
            servletException = e;
        }
        catch (Throwable e) {
            this.log(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
        }
        if (oldCCL != null) {
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        if (ioException != null) {
            throw ioException;
        }
        if (servletException != null) {
            throw servletException;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    private void log(String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("ApplicationDispatcher[" + this.context.getPath() + "]: " + message);
        } else {
            System.out.println("ApplicationDispatcher[" + this.context.getPath() + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("ApplicationDispatcher[" + this.context.getPath() + "] " + message, throwable);
        } else {
            System.out.println("ApplicationDispatcher[" + this.context.getPath() + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    private void setup(ServletRequest request, ServletResponse response, boolean including) {
        this.appRequest = request;
        this.appResponse = response;
        this.outerRequest = request;
        this.outerResponse = response;
        this.including = including;
    }

    private void unwrapRequest() {
        if (this.wrapRequest == null) {
            return;
        }
        ServletRequest previous = null;
        ServletRequest current = this.outerRequest;
        while (current != null && !(current instanceof Request) && !(current instanceof RequestFacade)) {
            if (current == this.wrapRequest) {
                ServletRequest next = ((ServletRequestWrapper)current).getRequest();
                if (previous == null) {
                    this.outerRequest = next;
                    break;
                }
                ((ServletRequestWrapper)previous).setRequest(next);
                break;
            }
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
    }

    private void unwrapResponse() {
        if (this.wrapResponse == null) {
            return;
        }
        ServletResponse previous = null;
        ServletResponse current = this.outerResponse;
        while (current != null && !(current instanceof Response) && !(current instanceof ResponseFacade)) {
            if (current == this.wrapResponse) {
                ServletResponse next = ((ServletResponseWrapper)current).getResponse();
                if (previous == null) {
                    this.outerResponse = next;
                    break;
                }
                ((ServletResponseWrapper)previous).setResponse(next);
                break;
            }
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
    }

    private ServletRequest wrapRequest() {
        ServletRequest previous = null;
        ServletRequest current = this.outerRequest;
        while (!(current == null || "org.apache.catalina.servlets.InvokerHttpRequest".equals(current.getClass().getName()) || !(current instanceof ServletRequestWrapper) || current instanceof ApplicationHttpRequest || current instanceof ApplicationRequest || current instanceof Request)) {
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
        Object wrapper = null;
        wrapper = current instanceof ApplicationHttpRequest || current instanceof HttpRequest || current instanceof HttpServletRequest ? new ApplicationHttpRequest((HttpServletRequest)current) : new ApplicationRequest(current);
        if (previous == null) {
            this.outerRequest = wrapper;
        } else {
            ((ServletRequestWrapper)previous).setRequest((ServletRequest)wrapper);
        }
        this.wrapRequest = wrapper;
        return wrapper;
    }

    private ServletResponse wrapResponse() {
        ServletResponse previous = null;
        ServletResponse current = this.outerResponse;
        while (current != null && current instanceof ServletResponseWrapper && !(current instanceof ApplicationHttpResponse) && !(current instanceof ApplicationResponse) && !(current instanceof Response)) {
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
        Object wrapper = null;
        wrapper = current instanceof ApplicationHttpResponse || current instanceof HttpResponse || current instanceof HttpServletResponse ? new ApplicationHttpResponse((HttpServletResponse)current, this.including) : new ApplicationResponse(current, this.including);
        if (previous == null) {
            this.outerResponse = wrapper;
        } else {
            ((ServletResponseWrapper)previous).setResponse((ServletResponse)wrapper);
        }
        this.wrapResponse = wrapper;
        return wrapper;
    }

    protected class PrivilegedForward
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedForward(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doForward(this.request, this.response);
            return null;
        }
    }

    protected class PrivilegedInclude
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedInclude(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInclude(this.request, this.response);
            return null;
        }
    }
}

