/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.communication;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.php.debug.core.Logger;
import org.eclipse.php.debug.core.communication.DebugConnectionThread;
import org.eclipse.php.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;

public class DebuggerCommunicationDaemon
implements ICommunicationDaemon {
    protected Object lock = new Object();
    protected ServerSocket serverSocket;
    protected boolean isAlive;

    public void init() {
        this.resetSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListen() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isAlive && this.serverSocket != null) {
                this.startListenThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopListen() {
        Object object = this.lock;
        synchronized (object) {
            this.isAlive = false;
            if (this.serverSocket == null) return;
            try {
                try {
                    if (!this.serverSocket.isClosed()) {
                        this.serverSocket.close();
                    }
                }
                catch (SocketException socketException) {
                }
                catch (IOException iOException) {
                    Logger.logException("Problem while closing the debugger ServerSocket.", iOException);
                }
                Object var3_5 = null;
                this.serverSocket = null;
                return;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.serverSocket = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSocket() {
        this.stopListen();
        int n = this.getReceiverPort();
        try {
            Object object = this.lock;
            synchronized (object) {
                this.serverSocket = new ServerSocket(n);
            }
        }
        catch (BindException bindException) {
            this.handleMultipleBindingError();
        }
        catch (IOException iOException) {
            Logger.logException("Error while restting the socket for the debug requests.", iOException);
        }
    }

    public void handleMultipleBindingError() {
        int n = this.getReceiverPort();
        Logger.log(4, "Port " + n + " is in use. Please select a different port for the debugger.");
    }

    protected int getReceiverPort() {
        return PHPProjectPreferences.getDebugPort(null);
    }

    protected void startConnectionThread(Socket socket) {
        new DebugConnectionThread(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startListenThread() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isAlive) {
                return;
            }
            this.isAlive = true;
        }
        new Thread(new ReceiverThread()).start();
    }

    public boolean isEnabled() {
        return true;
    }

    private class ReceiverThread
    implements Runnable {
        private ReceiverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (DebuggerCommunicationDaemon.this.isAlive) {
                    Socket socket = DebuggerCommunicationDaemon.this.serverSocket.accept();
                    DebuggerCommunicationDaemon.this.startConnectionThread(socket);
                }
            }
            catch (IOException iOException) {
                Object object = DebuggerCommunicationDaemon.this.lock;
                synchronized (object) {
                    if (DebuggerCommunicationDaemon.this.isAlive) {
                        Logger.logException("Error while listening to incoming debug requests. Listen thread terminated!", iOException);
                        DebuggerCommunicationDaemon.this.isAlive = false;
                    }
                }
            }
        }
    }
}

