/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.debugger;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.debug.core.debugger.Debugger;
import org.eclipse.php.debug.core.debugger.DefaultExpression;
import org.eclipse.php.debug.core.debugger.Expression;
import org.eclipse.php.debug.core.debugger.ExpressionValue;
import org.eclipse.php.debug.core.debugger.ExpressionsManager;
import org.eclipse.php.debug.core.debugger.ExpressionsValueDeserializer;
import org.eclipse.php.debug.core.debugger.StackVariable;

public class DefaultExpressionsManager
implements ExpressionsManager {
    private static final Expression[] EMPTY_VARIABLE_ARRAY = new Expression[0];
    private Debugger debugger;
    private Map hashResultDepthOne = new HashMap();
    private Map hashResultDepthZero = new HashMap();
    private String[] localsVariablePath = new String[]{"get_defined_vars()"};
    private String[] globalVariablePath = new String[]{"$GLOBALS"};

    public DefaultExpressionsManager(Debugger debugger) {
        this.debugger = debugger;
    }

    public String getExpressionValue(Expression expression, int n) {
        if (!this.debugger.isActive()) {
            return "N";
        }
        if (expression instanceof StackVariable) {
            return this.getStackVariableValue((StackVariable)expression, n);
        }
        String[] stringArray = DefaultExpressionsManager.minimizeArray(expression.getName());
        return this.getVariableValue(stringArray, n);
    }

    public boolean assignValue(Expression expression, String string, int n) {
        String[] stringArray = DefaultExpressionsManager.minimizeArray(expression.getName());
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        boolean bl = this.debugger.assignValue(stringArray[0], string, n, stringArray2);
        String string2 = this.debugger.getVariableValue(stringArray[0], n, stringArray2);
        if (bl) {
            String string3 = DefaultExpressionsManager.buildKey(stringArray);
            if (n == 1) {
                this.hashResultDepthOne.put(string3, string2);
            } else if (n == 0) {
                this.hashResultDepthZero.put(string3, string2);
            }
        }
        return bl;
    }

    private String getVariableValue(String[] stringArray, int n) {
        String string = DefaultExpressionsManager.buildKey(stringArray);
        if (this.hashResultDepthOne.containsKey(string)) {
            return (String)this.hashResultDepthOne.get(string);
        }
        if (n == 0 && this.hashResultDepthZero.containsKey(string)) {
            return (String)this.hashResultDepthZero.get(string);
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        String string2 = this.debugger.getVariableValue(stringArray[0], n, stringArray2);
        if (string2 != null) {
            if (n == 1) {
                this.hashResultDepthOne.put(string, string2);
            } else if (n == 0) {
                this.hashResultDepthZero.put(string, string2);
            }
        } else {
            string2 = "N";
        }
        return string2;
    }

    private static String buildKey(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(stringArray.length * 5);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String[] minimizeArray(String[] stringArray) {
        String string = stringArray[0];
        if (string.startsWith("$GLOBALS[GLOBALS]")) {
            stringArray[0] = string = "$GLOBALS" + string.substring(17);
            return DefaultExpressionsManager.minimizeArray(stringArray);
        }
        if (stringArray.length < 2) {
            return stringArray;
        }
        if (stringArray[0].equals("get_defined_vars()") && stringArray[1].equals("GLOBALS")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            stringArray2[0] = "$GLOBALS";
            System.arraycopy(stringArray, 2, stringArray2, 1, stringArray.length - 2);
            return DefaultExpressionsManager.minimizeArray(stringArray2);
        }
        if (stringArray[0].equals("$GLOBALS") && stringArray[1].equals("GLOBALS")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            stringArray3[0] = stringArray[0];
            System.arraycopy(stringArray, 2, stringArray3, 1, stringArray.length - 2);
            return DefaultExpressionsManager.minimizeArray(stringArray3);
        }
        return stringArray;
    }

    public Expression[] getLocalVariables() {
        return this.getLocalVariables(1);
    }

    public Expression[] getLocalVariables(int n) {
        String string = this.getVariableValue(this.localsVariablePath, n);
        ExpressionValue expressionValue = ExpressionsValueDeserializer.deserializer(null, string);
        Expression[] expressionArray = expressionValue.getChildren();
        if (expressionArray == null) {
            expressionArray = EMPTY_VARIABLE_ARRAY;
        }
        int n2 = 0;
        while (n2 < expressionArray.length) {
            String string2 = expressionArray[n2].getFullName();
            if (string2.equals("$GLOBALS")) {
                Expression[] expressionArray2 = new Expression[expressionArray.length - 1];
                System.arraycopy(expressionArray, 0, expressionArray2, 0, n2);
                System.arraycopy(expressionArray, n2 + 1, expressionArray2, n2, expressionArray.length - n2 - 1);
                expressionArray = expressionArray2;
                break;
            }
            ++n2;
        }
        this.hashResultDepthOne.put("LOCLAS", expressionArray);
        return expressionArray;
    }

    public Expression[] getGlobalVariables() {
        return this.getGlobalVariables(1);
    }

    public Expression[] getGlobalVariables(int n) {
        String string = this.getVariableValue(this.globalVariablePath, n);
        ExpressionValue expressionValue = ExpressionsValueDeserializer.deserializer(null, string);
        Expression[] expressionArray = expressionValue.getChildren();
        if (expressionArray == null) {
            expressionArray = EMPTY_VARIABLE_ARRAY;
        }
        int n2 = 0;
        while (n2 < expressionArray.length) {
            String string2 = expressionArray[n2].getFullName();
            if (string2.equals("$GLOBALS")) {
                Expression[] expressionArray2 = new Expression[expressionArray.length - 1];
                System.arraycopy(expressionArray, 0, expressionArray2, 0, n2);
                System.arraycopy(expressionArray, n2 + 1, expressionArray2, n2, expressionArray.length - n2 - 1);
                expressionArray = expressionArray2;
                break;
            }
            ++n2;
        }
        this.hashResultDepthOne.put("GlOBAS", expressionArray);
        return expressionArray;
    }

    private String getStackVariableValue(StackVariable stackVariable, int n) {
        int n2 = stackVariable.getStackDepth();
        String[] stringArray = stackVariable.getName();
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        return this.debugger.getStackVariableValue(n2, stringArray[0], n, stringArray2);
    }

    public void clear() {
        this.hashResultDepthOne.clear();
        this.hashResultDepthZero.clear();
    }

    public Expression buildExpression(String string) {
        return new DefaultExpression(string);
    }

    public void update(Expression expression, int n) {
        String string = this.getExpressionValue(expression, n);
        expression.setValue(ExpressionsValueDeserializer.deserializer(expression, string));
    }
}

