/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.debugger;

import java.io.File;
import org.eclipse.php.debug.core.communication.DebugConnectionThread;
import org.eclipse.php.debug.core.communication.ResponseHandler;
import org.eclipse.php.debug.core.debugger.Breakpoint;
import org.eclipse.php.debug.core.debugger.DebugError;
import org.eclipse.php.debug.core.debugger.Debugger;
import org.eclipse.php.debug.core.debugger.IDebugHandler;
import org.eclipse.php.debug.core.debugger.IRemoteDebugger;
import org.eclipse.php.debug.core.debugger.PHPstack;
import org.eclipse.php.debug.core.debugger.StackLayer;
import org.eclipse.php.debug.core.debugger.messages.AddBreakpointRequest;
import org.eclipse.php.debug.core.debugger.messages.AddBreakpointResponse;
import org.eclipse.php.debug.core.debugger.messages.AssignValueRequest;
import org.eclipse.php.debug.core.debugger.messages.CancelAllBreakpointsRequest;
import org.eclipse.php.debug.core.debugger.messages.CancelAllBreakpointsResponse;
import org.eclipse.php.debug.core.debugger.messages.CancelBreakpointRequest;
import org.eclipse.php.debug.core.debugger.messages.CancelBreakpointResponse;
import org.eclipse.php.debug.core.debugger.messages.DebugScriptEndedNotification;
import org.eclipse.php.debug.core.debugger.messages.DebugSessionClosedNotification;
import org.eclipse.php.debug.core.debugger.messages.DebugSessionStartedNotification;
import org.eclipse.php.debug.core.debugger.messages.DebuggerErrorNotification;
import org.eclipse.php.debug.core.debugger.messages.EvalRequest;
import org.eclipse.php.debug.core.debugger.messages.EvalResponse;
import org.eclipse.php.debug.core.debugger.messages.GetCallStackRequest;
import org.eclipse.php.debug.core.debugger.messages.GetCallStackResponse;
import org.eclipse.php.debug.core.debugger.messages.GetStackVariableValueRequest;
import org.eclipse.php.debug.core.debugger.messages.GetStackVariableValueResponse;
import org.eclipse.php.debug.core.debugger.messages.GetVariableValueRequest;
import org.eclipse.php.debug.core.debugger.messages.GetVariableValueResponse;
import org.eclipse.php.debug.core.debugger.messages.GoRequest;
import org.eclipse.php.debug.core.debugger.messages.GoResponse;
import org.eclipse.php.debug.core.debugger.messages.HeaderOutputNotification;
import org.eclipse.php.debug.core.debugger.messages.IDebugNotificationMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugRequestMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugResponseMessage;
import org.eclipse.php.debug.core.debugger.messages.OutputNotification;
import org.eclipse.php.debug.core.debugger.messages.ParsingErrorNotification;
import org.eclipse.php.debug.core.debugger.messages.PauseDebuggerRequest;
import org.eclipse.php.debug.core.debugger.messages.PauseDebuggerResponse;
import org.eclipse.php.debug.core.debugger.messages.ReadyNotification;
import org.eclipse.php.debug.core.debugger.messages.StartRequest;
import org.eclipse.php.debug.core.debugger.messages.StartResponse;
import org.eclipse.php.debug.core.debugger.messages.StepIntoRequest;
import org.eclipse.php.debug.core.debugger.messages.StepIntoResponse;
import org.eclipse.php.debug.core.debugger.messages.StepOutRequest;
import org.eclipse.php.debug.core.debugger.messages.StepOutResponse;
import org.eclipse.php.debug.core.debugger.messages.StepOverRequest;
import org.eclipse.php.debug.core.debugger.messages.StepOverResponse;

public class RemoteDebugger
implements IRemoteDebugger {
    public static final int PROTOCOL_ID = 2006040701;
    private DebugConnectionThread connection;
    private IDebugHandler debugHandler;

    public RemoteDebugger(IDebugHandler iDebugHandler, DebugConnectionThread debugConnectionThread) {
        this.connection = debugConnectionThread;
        this.debugHandler = iDebugHandler;
        this.connection.setCommunicationAdministrator(this);
        this.connection.setCommunicationClient(this);
    }

    public IDebugHandler getDebugHandler() {
        return this.debugHandler;
    }

    public DebugConnectionThread getConnectionThread() {
        return this.connection;
    }

    public void closeConnection() {
        this.connection.closeConnection();
    }

    public void setPeerResponseTimeout(int n) {
        this.connection.setPeerResponseTimeout(n);
    }

    public void connectionEstablished() {
        this.debugHandler.connectionEstablished();
    }

    public void connectionClosed() {
        this.debugHandler.connectionClosed();
    }

    public void handleNotification(Object object) {
        if (object instanceof OutputNotification) {
            String string = ((OutputNotification)object).getOutput();
            this.debugHandler.newOutput(string);
        } else if (object instanceof ReadyNotification) {
            ReadyNotification readyNotification = (ReadyNotification)object;
            String string = readyNotification.getFileName();
            int n = readyNotification.getLineNumber();
            this.debugHandler.ready(RemoteDebugger.convertToSystemDependentFileName(string), n);
        } else if (object instanceof DebugSessionStartedNotification) {
            DebugSessionStartedNotification debugSessionStartedNotification = (DebugSessionStartedNotification)object;
            int n = debugSessionStartedNotification.getServerProtocolID();
            if (n != 2006040701) {
                this.debugHandler.wrongDebugServer();
                return;
            }
            String string = debugSessionStartedNotification.getFileName();
            String string2 = debugSessionStartedNotification.getUri();
            String string3 = debugSessionStartedNotification.getQuery();
            String string4 = debugSessionStartedNotification.getOptions();
            this.debugHandler.sessionStarted(string, string2, string3, string4);
        } else if (object instanceof HeaderOutputNotification) {
            this.debugHandler.newHeaderOutput(((HeaderOutputNotification)object).getOutput());
        } else if (object instanceof ParsingErrorNotification) {
            ParsingErrorNotification parsingErrorNotification = (ParsingErrorNotification)object;
            String string = parsingErrorNotification.getErrorText();
            String string5 = RemoteDebugger.convertToSystemDependentFileName(parsingErrorNotification.getFileName());
            int n = parsingErrorNotification.getLineNumber();
            int n2 = parsingErrorNotification.getErrorLevel();
            DebugError debugError = new DebugError(n2, string5, n, string);
            this.debugHandler.parsingErrorOccured(debugError);
        } else if (object instanceof DebuggerErrorNotification) {
            DebuggerErrorNotification debuggerErrorNotification = (DebuggerErrorNotification)object;
            int n = debuggerErrorNotification.getErrorLevel();
            DebugError debugError = new DebugError();
            String string = debuggerErrorNotification.getErrorText();
            if (string != null && !string.equals("")) {
                debugError.setErrorText(string);
            }
            debugError.setCode(n);
            this.debugHandler.debuggerErrorOccured(debugError);
        } else if (object instanceof DebugScriptEndedNotification) {
            this.debugHandler.handleScriptEnded();
        }
    }

    public void closeDebugSession() {
        if (this.connection.isConnected()) {
            this.connection.sendNotification(new DebugSessionClosedNotification());
        }
    }

    public void handleMultipleBindings() {
        this.debugHandler.multipleBindOccured();
    }

    public void handlePeerResponseTimeout() {
        this.debugHandler.connectionTimedout();
    }

    public static String convertToSystemIndependentFileName(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace('\\', '/');
        return string;
    }

    private static final String convertToSystemDependentFileName(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace('/', File.separatorChar);
        string = string.replace('\\', File.separatorChar);
        return string;
    }

    public IDebugResponseMessage sendCustomRequest(IDebugRequestMessage iDebugRequestMessage) {
        IDebugResponseMessage iDebugResponseMessage = null;
        if (this.isActive()) {
            try {
                Object object = this.connection.sendRequest(iDebugRequestMessage);
                if (object instanceof IDebugResponseMessage) {
                    iDebugResponseMessage = (IDebugResponseMessage)object;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return iDebugResponseMessage;
    }

    public boolean sendCustomNotification(IDebugNotificationMessage iDebugNotificationMessage) {
        if (this.isActive()) {
            try {
                this.connection.sendNotification(iDebugNotificationMessage);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public boolean addBreakpoint(Breakpoint breakpoint, Debugger.BreakpointAddedResponseHandler breakpointAddedResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            AddBreakpointRequest addBreakpointRequest = new AddBreakpointRequest();
            Breakpoint breakpoint2 = (Breakpoint)breakpoint.clone();
            String string = RemoteDebugger.convertToSystemIndependentFileName(breakpoint2.getFileName());
            breakpoint2.setFileName(string);
            addBreakpointRequest.setBreakpoint(breakpoint2);
            this.connection.sendRequest(addBreakpointRequest, new ThisHandleResponse(breakpointAddedResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        if (!this.isActive()) {
            return;
        }
        try {
            AddBreakpointRequest addBreakpointRequest = new AddBreakpointRequest();
            Breakpoint breakpoint2 = (Breakpoint)breakpoint.clone();
            String string = RemoteDebugger.convertToSystemIndependentFileName(breakpoint2.getFileName());
            breakpoint2.setFileName(string);
            addBreakpointRequest.setBreakpoint(breakpoint2);
            AddBreakpointResponse addBreakpointResponse = (AddBreakpointResponse)this.connection.sendRequest(addBreakpointRequest);
            if (addBreakpointResponse != null && addBreakpointResponse.getStatus() == 0) {
                breakpoint.setID(addBreakpointResponse.getBreakpointID());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean removeBreakpoint(int n, Debugger.BreakpointRemovedResponseHandler breakpointRemovedResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        CancelBreakpointRequest cancelBreakpointRequest = new CancelBreakpointRequest();
        cancelBreakpointRequest.setBreakpointID(n);
        this.connection.sendRequest(cancelBreakpointRequest, new ThisHandleResponse(breakpointRemovedResponseHandler));
        return true;
    }

    public boolean removeBreakpoint(int n) {
        if (!this.isActive()) {
            return false;
        }
        try {
            CancelBreakpointRequest cancelBreakpointRequest = new CancelBreakpointRequest();
            cancelBreakpointRequest.setBreakpointID(n);
            CancelBreakpointResponse cancelBreakpointResponse = (CancelBreakpointResponse)this.connection.sendRequest(cancelBreakpointRequest);
            return cancelBreakpointResponse != null && cancelBreakpointResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean removeBreakpoint(Breakpoint breakpoint, Debugger.BreakpointRemovedResponseHandler breakpointRemovedResponseHandler) {
        return this.removeBreakpoint(breakpoint.getID(), breakpointRemovedResponseHandler);
    }

    public boolean removeBreakpoint(Breakpoint breakpoint) {
        return this.removeBreakpoint(breakpoint.getID());
    }

    public boolean removeAllBreakpoints(Debugger.AllBreakpointRemovedResponseHandler allBreakpointRemovedResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        CancelAllBreakpointsRequest cancelAllBreakpointsRequest = new CancelAllBreakpointsRequest();
        this.connection.sendRequest(cancelAllBreakpointsRequest, new ThisHandleResponse(allBreakpointRemovedResponseHandler));
        return true;
    }

    public boolean removeAllBreakpoints() {
        if (!this.isActive()) {
            return false;
        }
        try {
            CancelAllBreakpointsRequest cancelAllBreakpointsRequest = new CancelAllBreakpointsRequest();
            CancelAllBreakpointsResponse cancelAllBreakpointsResponse = (CancelAllBreakpointsResponse)this.connection.sendRequest(cancelAllBreakpointsRequest);
            return cancelAllBreakpointsResponse != null && cancelAllBreakpointsResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean stepInto(Debugger.StepIntoResponseHandler stepIntoResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        StepIntoRequest stepIntoRequest = new StepIntoRequest();
        this.connection.sendRequest(stepIntoRequest, new ThisHandleResponse(stepIntoResponseHandler));
        return true;
    }

    public boolean stepInto() {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepIntoRequest stepIntoRequest = new StepIntoRequest();
            StepIntoResponse stepIntoResponse = (StepIntoResponse)this.connection.sendRequest(stepIntoRequest);
            return stepIntoResponse != null && stepIntoResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean stepOver(Debugger.StepOverResponseHandler stepOverResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOverRequest stepOverRequest = new StepOverRequest();
            this.connection.sendRequest(stepOverRequest, new ThisHandleResponse(stepOverResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean stepOver() {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOverRequest stepOverRequest = new StepOverRequest();
            StepOverResponse stepOverResponse = (StepOverResponse)this.connection.sendRequest(stepOverRequest);
            return stepOverResponse != null && stepOverResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean stepOut(Debugger.StepOutResponseHandler stepOutResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOutRequest stepOutRequest = new StepOutRequest();
            this.connection.sendRequest(stepOutRequest, new ThisHandleResponse(stepOutResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean stepOut() {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOutRequest stepOutRequest = new StepOutRequest();
            StepOutResponse stepOutResponse = (StepOutResponse)this.connection.sendRequest(stepOutRequest);
            return stepOutResponse != null && stepOutResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean go(Debugger.GoResponseHandler goResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            GoRequest goRequest = new GoRequest();
            this.connection.sendRequest(goRequest, new ThisHandleResponse(goResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean go() {
        if (!this.isActive()) {
            return false;
        }
        try {
            GoRequest goRequest = new GoRequest();
            GoResponse goResponse = (GoResponse)this.connection.sendRequest(goRequest);
            return goResponse != null && goResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean start(Debugger.StartResponseHandler startResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        StartRequest startRequest = new StartRequest();
        try {
            this.connection.sendRequest(startRequest, new ThisHandleResponse(startResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean start() {
        if (!this.isActive()) {
            return false;
        }
        StartRequest startRequest = new StartRequest();
        try {
            StartResponse startResponse = (StartResponse)this.connection.sendRequest(startRequest);
            return startResponse != null && startResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean pause(Debugger.PauseResponseHandler pauseResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        PauseDebuggerRequest pauseDebuggerRequest = new PauseDebuggerRequest();
        try {
            this.connection.sendRequest(pauseDebuggerRequest, new ThisHandleResponse(pauseResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean pause() {
        if (!this.isActive()) {
            return false;
        }
        PauseDebuggerRequest pauseDebuggerRequest = new PauseDebuggerRequest();
        try {
            PauseDebuggerResponse pauseDebuggerResponse = (PauseDebuggerResponse)this.connection.sendRequest(pauseDebuggerRequest);
            return pauseDebuggerResponse != null && pauseDebuggerResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean eval(String string, Debugger.EvalResponseHandler evalResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        EvalRequest evalRequest = new EvalRequest();
        evalRequest.setCommand(string);
        try {
            this.connection.sendRequest(evalRequest, new ThisHandleResponse(evalResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean assignValue(String string, String string2, int n, String[] stringArray, Debugger.AssignValueResponseHandler assignValueResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        AssignValueRequest assignValueRequest = new AssignValueRequest();
        assignValueRequest.setVar(string);
        assignValueRequest.setValue(string2);
        assignValueRequest.setDepth(n);
        assignValueRequest.setPath(stringArray);
        try {
            this.connection.sendRequest(assignValueRequest, new ThisHandleResponse(assignValueResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean assignValue(String string, String string2, int n, String[] stringArray) {
        if (!this.isActive()) {
            return false;
        }
        AssignValueRequest assignValueRequest = new AssignValueRequest();
        assignValueRequest.setVar(string);
        assignValueRequest.setValue(string2);
        assignValueRequest.setDepth(n);
        assignValueRequest.setPath(stringArray);
        try {
            this.connection.sendRequest(assignValueRequest);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public String eval(String string) {
        if (!this.isActive()) {
            return null;
        }
        EvalRequest evalRequest = new EvalRequest();
        evalRequest.setCommand(string);
        try {
            EvalResponse evalResponse = (EvalResponse)this.connection.sendRequest(evalRequest);
            String string2 = null;
            if (evalResponse != null) {
                string2 = evalResponse.getStatus() == 0 ? evalResponse.getResult() : "---ERROR---";
            }
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void finish() {
        this.connection.closeConnection();
    }

    public boolean isActive() {
        return this.connection != null && this.connection.isConnected();
    }

    public boolean getVariableValue(String string, int n, String[] stringArray, Debugger.VariableValueResponseHandler variableValueResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        GetVariableValueRequest getVariableValueRequest = new GetVariableValueRequest();
        getVariableValueRequest.setVar(string);
        getVariableValueRequest.setDepth(n);
        getVariableValueRequest.setPath(stringArray);
        try {
            this.connection.sendRequest(getVariableValueRequest, new ThisHandleResponse(variableValueResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public String getVariableValue(String string, int n, String[] stringArray) throws IllegalArgumentException {
        if (!this.isActive()) {
            return null;
        }
        GetVariableValueRequest getVariableValueRequest = new GetVariableValueRequest();
        getVariableValueRequest.setVar(string);
        getVariableValueRequest.setDepth(n);
        getVariableValueRequest.setPath(stringArray);
        GetVariableValueResponse getVariableValueResponse = null;
        try {
            getVariableValueResponse = (GetVariableValueResponse)this.connection.sendRequest(getVariableValueRequest);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (getVariableValueResponse == null || getVariableValueResponse.getStatus() != 0) {
            return null;
        }
        String string2 = getVariableValueResponse.getVarResult();
        return string2;
    }

    public boolean getCallStack(Debugger.GetCallStackResponseHandler getCallStackResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        GetCallStackRequest getCallStackRequest = new GetCallStackRequest();
        try {
            this.connection.sendRequest(getCallStackRequest, new ThisHandleResponse(getCallStackResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public PHPstack getCallStack() {
        if (!this.isActive()) {
            return null;
        }
        GetCallStackRequest getCallStackRequest = new GetCallStackRequest();
        PHPstack pHPstack = null;
        try {
            GetCallStackResponse getCallStackResponse = (GetCallStackResponse)this.connection.sendRequest(getCallStackRequest);
            if (getCallStackResponse != null) {
                pHPstack = getCallStackResponse.getPHPstack();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        RemoteDebugger.convertToSystem(pHPstack);
        return pHPstack;
    }

    private static void convertToSystem(PHPstack pHPstack) {
        if (pHPstack != null) {
            int n = 0;
            while (n < pHPstack.getSize()) {
                StackLayer stackLayer = pHPstack.getLayer(n);
                stackLayer.setCallerLineNumber(stackLayer.getCallerLineNumber() - 1);
                stackLayer.setCalledLineNumber(stackLayer.getCalledLineNumber() - 1);
                stackLayer.setCallerFileName(RemoteDebugger.convertToSystemDependentFileName(stackLayer.getCallerFileName()));
                stackLayer.setCalledFileName(RemoteDebugger.convertToSystemDependentFileName(stackLayer.getCalledFileName()));
                ++n;
            }
        }
    }

    public boolean getStackVariableValue(int n, String string, int n2, String[] stringArray, Debugger.GetStackVariableValueResponseHandler getStackVariableValueResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        GetStackVariableValueRequest getStackVariableValueRequest = new GetStackVariableValueRequest();
        getStackVariableValueRequest.setVar(string);
        getStackVariableValueRequest.setDepth(n2);
        getStackVariableValueRequest.setLayerDepth(n);
        getStackVariableValueRequest.setPath(stringArray);
        try {
            this.connection.sendRequest(getStackVariableValueRequest, new ThisHandleResponse(getStackVariableValueResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public String getStackVariableValue(int n, String string, int n2, String[] stringArray) {
        if (!this.isActive()) {
            return null;
        }
        GetStackVariableValueRequest getStackVariableValueRequest = new GetStackVariableValueRequest();
        getStackVariableValueRequest.setVar(string);
        getStackVariableValueRequest.setDepth(n2);
        getStackVariableValueRequest.setLayerDepth(n);
        getStackVariableValueRequest.setPath(stringArray);
        GetStackVariableValueResponse getStackVariableValueResponse = null;
        try {
            getStackVariableValueResponse = (GetStackVariableValueResponse)this.connection.sendRequest(getStackVariableValueRequest);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (getStackVariableValueResponse == null || getStackVariableValueResponse.getStatus() != 0) {
            return null;
        }
        String string2 = getStackVariableValueResponse.getVarResult();
        return string2;
    }

    private static class ThisHandleResponse
    implements ResponseHandler {
        Object responseHandler;

        public ThisHandleResponse(Object object) {
            this.responseHandler = object;
        }

        public void handleResponse(Object object, Object object2) {
            boolean bl;
            boolean bl2 = bl = object2 != null && ((IDebugResponseMessage)object2).getStatus() == 0;
            if (object instanceof AddBreakpointRequest) {
                AddBreakpointRequest addBreakpointRequest = (AddBreakpointRequest)object;
                Breakpoint breakpoint = addBreakpointRequest.getBreakpoint();
                String string = RemoteDebugger.convertToSystemDependentFileName(breakpoint.getFileName());
                int n = breakpoint.getLineNumber();
                int n2 = -1;
                if (object2 != null) {
                    n2 = ((AddBreakpointResponse)object2).getBreakpointID();
                }
                ((Debugger.BreakpointAddedResponseHandler)this.responseHandler).breakpointAdded(string, n, n2, bl);
            } else if (object instanceof CancelBreakpointRequest) {
                ((Debugger.BreakpointRemovedResponseHandler)this.responseHandler).breakpointRemoved(((CancelBreakpointRequest)object).getBreakpointID(), bl);
            } else if (object instanceof CancelAllBreakpointsRequest) {
                ((Debugger.AllBreakpointRemovedResponseHandler)this.responseHandler).allBreakpointRemoved(bl);
            } else if (object instanceof StartRequest) {
                ((Debugger.StartResponseHandler)this.responseHandler).started(bl);
            } else if (object instanceof EvalRequest) {
                ((Debugger.EvalResponseHandler)this.responseHandler).evaled(((EvalRequest)object).getCommand(), bl ? ((EvalResponse)object2).getResult() : null, bl);
            } else if (object instanceof StepIntoRequest) {
                ((Debugger.StepIntoResponseHandler)this.responseHandler).stepInto(bl);
            } else if (object instanceof StepOverRequest) {
                ((Debugger.StepOverResponseHandler)this.responseHandler).stepOver(bl);
            } else if (object instanceof StepOutRequest) {
                ((Debugger.StepOutResponseHandler)this.responseHandler).stepOut(bl);
            } else if (object instanceof GoRequest) {
                ((Debugger.GoResponseHandler)this.responseHandler).go(bl);
            } else if (object instanceof PauseDebuggerRequest) {
                ((Debugger.PauseResponseHandler)this.responseHandler).pause(bl);
            } else if (object instanceof AssignValueRequest) {
                AssignValueRequest assignValueRequest = (AssignValueRequest)object;
                String string = assignValueRequest.getVar();
                String string2 = assignValueRequest.getValue();
                int n = assignValueRequest.getDepth();
                String[] stringArray = assignValueRequest.getPath();
                ((Debugger.AssignValueResponseHandler)this.responseHandler).valueAssigned(string, string2, n, stringArray, bl);
            } else if (object instanceof GetVariableValueRequest) {
                GetVariableValueRequest getVariableValueRequest = (GetVariableValueRequest)object;
                String string = getVariableValueRequest.getVar();
                int n = getVariableValueRequest.getDepth();
                String[] stringArray = getVariableValueRequest.getPath();
                String string3 = null;
                if (object2 != null) {
                    string3 = ((GetVariableValueResponse)object2).getVarResult();
                }
                ((Debugger.VariableValueResponseHandler)this.responseHandler).variableValue(string, n, stringArray, string3, bl);
            } else if (object instanceof GetCallStackRequest) {
                PHPstack pHPstack = null;
                if (object2 != null) {
                    pHPstack = ((GetCallStackResponse)object2).getPHPstack();
                }
                RemoteDebugger.convertToSystem(pHPstack);
                ((Debugger.GetCallStackResponseHandler)this.responseHandler).callStack(pHPstack, bl);
            } else if (object instanceof GetStackVariableValueRequest) {
                GetStackVariableValueRequest getStackVariableValueRequest = (GetStackVariableValueRequest)object;
                int n = getStackVariableValueRequest.getLayerDepth();
                String string = getStackVariableValueRequest.getVar();
                int n3 = getStackVariableValueRequest.getDepth();
                String[] stringArray = getStackVariableValueRequest.getPath();
                String string4 = null;
                if (object2 != null) {
                    string4 = ((GetStackVariableValueResponse)object2).getVarResult();
                }
                ((Debugger.GetStackVariableValueResponseHandler)this.responseHandler).stackVariableValue(n, string, n3, stringArray, string4, bl);
            }
        }
    }
}

