/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.documentModel.validate;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.documentModel.PHPFileVisitor;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPMarker;
import org.eclipse.php.core.phpModel.phpElementData.PHPTask;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.core.preferences.TaskTagsProvider;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class PHPProblemsValidator
implements IValidator {
    private TaskTagsProvider taskTagsProvider = TaskTagsProvider.getInstance();

    static boolean shouldValidate(IFile iFile) {
        IFile iFile2 = iFile;
        do {
            if (!iFile2.isDerived() && !iFile2.isTeamPrivateMember() && iFile2.isAccessible() && (iFile2.getName().charAt(0) != '.' || iFile2.getType() != 2)) continue;
            return false;
        } while (((iFile2 = iFile2.getParent()).getType() & 4) == 0);
        return true;
    }

    public void cleanup(IReporter iReporter) {
    }

    public void validate(IValidationContext iValidationContext, IReporter iReporter) throws ValidationException {
        String[] stringArray = iValidationContext.getURIs();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (stringArray.length > 0) {
            IFile iFile = null;
            int n = 0;
            while (n < stringArray.length && !iReporter.isCancelled()) {
                iFile = iWorkspaceRoot.getFile((IPath)new Path(stringArray[n]));
                if (iFile != null && iFile.exists()) {
                    this.validateFile(iFile, iReporter);
                }
                ++n;
            }
        } else {
            PHPFileVisitor pHPFileVisitor = new PHPFileVisitor(iReporter);
            try {
                ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)pHPFileVisitor, 2);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            IFile[] iFileArray = pHPFileVisitor.getFiles();
            int n = 0;
            while (n < iFileArray.length && !iReporter.isCancelled()) {
                this.validateFile(iFileArray[n], iReporter);
                ++n;
            }
        }
    }

    private void validateFile(IFile iFile, IReporter iReporter) {
        PHPFileData pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(iFile.getFullPath().toString(), true);
        if (pHPFileData == null) {
            return;
        }
        IPHPMarker[] iPHPMarkerArray = pHPFileData.getMarkers();
        IMarker[] iMarkerArray = null;
        Map[] mapArray = null;
        iReporter.removeAllMessages((IValidator)this, (Object)iFile);
        try {
            iMarkerArray = iFile.findMarkers("org.eclipse.core.resources.taskmarker", false, 2);
            mapArray = new Map[iMarkerArray.length];
            int n = 0;
            while (n < mapArray.length) {
                mapArray[n] = iMarkerArray[n].getAttributes();
                ++n;
            }
            iFile.deleteMarkers("org.eclipse.core.resources.taskmarker", false, 2);
        }
        catch (CoreException coreException) {}
        if (iPHPMarkerArray != null) {
            Object object;
            TaskTag[] taskTagArray = this.taskTagsProvider.getProjectTaskTags(iFile.getProject());
            if (taskTagArray == null) {
                taskTagArray = this.taskTagsProvider.getWorkspaceTaskTags();
            }
            boolean bl = this.taskTagsProvider.getProjectTagsCaseSensitive(iFile.getProject());
            int n = 0;
            while (iPHPMarkerArray.length > n) {
                int n2;
                UserData userData;
                Object object2;
                String string = iPHPMarkerArray[n].getType();
                if (string.equals("TASK")) {
                    object = (PHPTask)iPHPMarkerArray[n];
                    object2 = String.valueOf(((PHPTask)object).getTaskName()) + " " + ((PHPMarker)object).getDescription();
                    userData = ((PHPMarker)object).getUserData();
                    n2 = this.getPriority(((PHPTask)object).getTaskName(), taskTagArray, bl);
                    try {
                        IMarker iMarker = iFile.createMarker("org.eclipse.core.resources.taskmarker");
                        iMarker.setAttribute("lineNumber", userData.getStopLine() + 1);
                        iMarker.setAttribute("charStart", userData.getStartPosition());
                        iMarker.setAttribute("charEnd", userData.getEndPosition() + 1);
                        iMarker.setAttribute("message", object2);
                        iMarker.setAttribute("priority", n2);
                    }
                    catch (CoreException coreException) {}
                } else if (string.equals("ERROR") || string.equals("WARNING") || string.equals("INFO")) {
                    object = iPHPMarkerArray[n].getDescription();
                    object2 = iPHPMarkerArray[n].getUserData();
                    userData = new LocalizedMessage(1, (String)object, (IResource)iFile);
                    n2 = object2.getStopLine() + 1;
                    userData.setLineNo(n2);
                    iReporter.addMessage((IValidator)this, (IMessage)userData);
                }
                ++n;
            }
            if (iMarkerArray != null) {
                n = 0;
                while (n < iMarkerArray.length) {
                    try {
                        boolean bl2 = iMarkerArray[n].exists();
                        if (!bl2 && mapArray[n].get("rulerPHPTask") != null) {
                            object = iFile.createMarker("org.eclipse.core.resources.taskmarker");
                            object.setAttributes(mapArray[n]);
                        }
                    }
                    catch (CoreException coreException) {}
                    ++n;
                }
            }
        }
    }

    private int getPriority(String string, TaskTag[] taskTagArray, boolean bl) {
        int n = 0;
        while (n < taskTagArray.length) {
            boolean bl2 = bl ? taskTagArray[n].getTag().equals(string) : taskTagArray[n].getTag().equalsIgnoreCase(string);
            if (bl2) {
                return taskTagArray[n].getPriority();
            }
            ++n;
        }
        return 1;
    }
}

