/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpModel;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.php.core.PHPCorePlugin;
import org.eclipse.php.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocTagData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.core.phpModel.phpElementData.PHPProjectModelVisitor;
import org.eclipse.php.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;

public class PHPModelUtil {
    public static boolean hasChildren(PHPCodeData pHPCodeData) {
        if (pHPCodeData instanceof PHPFunctionData) {
            return false;
        }
        if (pHPCodeData instanceof PHPClassData) {
            PHPClassData pHPClassData = (PHPClassData)pHPCodeData;
            return pHPClassData.getFunctions().length > 0 || pHPClassData.getVars().length > 0 || pHPClassData.getConsts().length > 0;
        }
        return !(pHPCodeData instanceof PHPVariableData) && !(pHPCodeData instanceof PHPKeywordData) && !(pHPCodeData instanceof PHPConstantData) && !(pHPCodeData instanceof PHPClassConstData);
    }

    public static PHPFileData getPHPFileContainer(PHPCodeData pHPCodeData) {
        PHPCodeData pHPCodeData2 = pHPCodeData.getContainer();
        while (pHPCodeData2 != null && !(pHPCodeData2 instanceof PHPFileData)) {
            pHPCodeData2 = pHPCodeData2.getContainer();
        }
        return (PHPFileData)pHPCodeData2;
    }

    public static IResource getResource(Object object) {
        if (object instanceof PHPCodeData) {
            Object object2;
            PHPFileData pHPFileData = null;
            if (!(object instanceof PHPFileData)) {
                pHPFileData = PHPModelUtil.getPHPFileContainer((PHPCodeData)object);
            }
            PHPFileData pHPFileData2 = pHPFileData;
            String string = null;
            PHPCodeData pHPCodeData = (PHPCodeData)object;
            if (pHPFileData2 != null) {
                string = pHPFileData2.getName();
            } else if (pHPCodeData.isUserCode()) {
                pHPCodeData.getContainer();
                object2 = pHPCodeData.getUserData();
                string = object2.getFileName();
            } else {
                return null;
            }
            object2 = new Path(string);
            if (object2.segmentCount() < 2) {
                return null;
            }
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)object2);
            return iFile;
        }
        if (object instanceof PHPProjectModel) {
            PHPProjectModel pHPProjectModel = (PHPProjectModel)object;
            IProject iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel(pHPProjectModel);
            return iProject;
        }
        if (object instanceof IResource) {
            return (IResource)object;
        }
        return null;
    }

    public static Object getExternalResource(Object object, IProject iProject) {
        if (!(object instanceof PHPCodeData)) {
            return null;
        }
        String string = ((PHPCodeData)object).getUserData().getFileName();
        File file = new File(string);
        if (file != null && file.exists()) {
            return file;
        }
        PHPFileData pHPFileData = null;
        pHPFileData = object instanceof PHPFileData ? (PHPFileData)object : PHPModelUtil.getPHPFileContainer((PHPCodeData)object);
        if (pHPFileData == null) {
            return null;
        }
        PHPProjectModel pHPProjectModel = null;
        if (iProject == null) {
            string = pHPFileData.getName();
            PHPProjectModel[] pHPProjectModelArray = PHPWorkspaceModelManager.getInstance().listModels();
            int n = 0;
            while (n < pHPProjectModelArray.length) {
                if (pHPProjectModelArray[n].getFileData(string) == pHPFileData) {
                    pHPProjectModel = pHPProjectModelArray[n];
                    break;
                }
                ++n;
            }
        } else {
            pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        }
        if (pHPProjectModel == null) {
            return null;
        }
        return pHPProjectModel.getExternalResource(pHPFileData);
    }

    public static IContainer getPHPFolderRoot(PHPCodeData pHPCodeData) {
        IResource iResource = PHPModelUtil.getResource(pHPCodeData);
        return iResource != null ? iResource.getProject() : null;
    }

    public static boolean isReadOnly(Object object) {
        return false;
    }

    public static boolean isExternal(Object object) {
        return false;
    }

    public static Object getParent(Object object) {
        if (object instanceof IResource) {
            if (object instanceof IProject) {
                return PHPWorkspaceModelManager.getInstance();
            }
            IContainer iContainer = ((IResource)object).getParent();
            if (iContainer instanceof IProject) {
                return PHPWorkspaceModelManager.getInstance().getModelForProject((IProject)iContainer);
            }
            return iContainer;
        }
        if (object instanceof PHPCodeData) {
            PHPCodeData pHPCodeData = ((PHPCodeData)object).getContainer();
            if (pHPCodeData == null && object instanceof PHPFileData) {
                IResource iResource = PHPModelUtil.getResource(object);
                IContainer iContainer = iResource.getParent();
                return iContainer;
            }
            return pHPCodeData;
        }
        if (object instanceof PHPProjectModel) {
            return PHPWorkspaceModelManager.getInstance();
        }
        return null;
    }

    public static PHPCodeData getElementAt(PHPCodeData pHPCodeData, int n) {
        throw new RuntimeException("test me");
    }

    public static int getModifier(PHPCodeData pHPCodeData) {
        if (pHPCodeData instanceof PHPClassData) {
            PHPClassData pHPClassData = (PHPClassData)pHPCodeData;
            return pHPClassData.getModifiers();
        }
        if (pHPCodeData instanceof PHPFunctionData) {
            PHPFunctionData pHPFunctionData = (PHPFunctionData)pHPCodeData;
            return pHPFunctionData.getModifiers();
        }
        if (pHPCodeData instanceof PHPClassVarData) {
            PHPClassVarData pHPClassVarData = (PHPClassVarData)pHPCodeData;
            return pHPClassVarData.getModifiers();
        }
        return 0;
    }

    public static PHPFileData getPHPFile(IFile iFile) {
        PHPFileData pHPFileData;
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iFile.getProject());
        if (pHPProjectModel != null && (pHPFileData = pHPProjectModel.getFileData(iFile.getFullPath().toString())) != null) {
            return pHPFileData;
        }
        return null;
    }

    public static boolean hasSuperClass(PHPClassData pHPClassData, String string) {
        PHPClassData pHPClassData2;
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData == null) {
            return false;
        }
        String string2 = pHPSuperClassNameData.getName();
        if (string2 == null) {
            return false;
        }
        UserData userData = pHPClassData.getUserData();
        String string3 = userData == null ? null : userData.getFileName();
        if (pHPSuperClassNameData.getName().compareToIgnoreCase(string) == 0) {
            return true;
        }
        IResource iResource = PHPModelUtil.getResource(pHPClassData);
        iResource = PHPModelUtil.getResource(pHPClassData);
        if (iResource == null) {
            return false;
        }
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iResource.getProject());
        while ((pHPClassData2 = pHPProjectModel.getClass(string3, pHPSuperClassNameData.getName())) != null) {
            string2 = pHPClassData2.getName();
            if (string2 == null) {
                return false;
            }
            if (string2.compareToIgnoreCase(string) == 0) {
                return true;
            }
            pHPSuperClassNameData = pHPClassData2.getSuperClassData();
            if (pHPSuperClassNameData == null) {
                return false;
            }
            userData = pHPClassData2.getUserData();
            string3 = userData == null ? null : userData.getFileName();
        }
        return false;
    }

    public static boolean isPhpFile(IFile iFile) {
        IContentDescription iContentDescription;
        try {
            iContentDescription = iFile.getContentDescription();
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
            return false;
        }
        if (iContentDescription == null) {
            if (PHPModelUtil.hasPhpExtention(iFile)) {
                PHPCorePlugin.logErrorMessage("content description null!");
            }
            return false;
        }
        return ContentTypeIdForPHP.ContentTypeID_PHP.equals(iContentDescription.getContentType().getId());
    }

    public static boolean hasPhpExtention(IFile iFile) {
        IContentType iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        String[] stringArray = iContentType.getFileSpecs(8);
        String string = iFile.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string2.equals(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static class PHPContainerStringConverter {
        public static String toString(Object object) {
            IPath iPath;
            if (object instanceof PHPCodeData) {
                while (object != null && !(object instanceof PHPFileData)) {
                    object = ((PHPCodeData)object).getContainer();
                }
            }
            if (object == null) {
                return "";
            }
            IResource iResource = PHPModelUtil.getResource(object);
            if (iResource != null && (iPath = iResource.getFullPath()) != null) {
                return iPath.toPortableString();
            }
            return "";
        }

        public static Object toContainer(String string) {
            PHPFileData pHPFileData;
            IPath iPath = Path.fromPortableString((String)string);
            if (iPath == null) {
                return null;
            }
            IFile iFile = null;
            try {
                iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (iFile != null && (pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(iFile, false)) != null) {
                return pHPFileData;
            }
            pHPFileData = null;
            try {
                pHPFileData = ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (pHPFileData != null) {
                return pHPFileData;
            }
            IProject iProject = null;
            try {
                iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iPath.segments()[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return iProject;
        }
    }

    static class FindElementVisitor
    implements PHPProjectModelVisitor {
        int offset;
        PHPCodeData foundElement;

        FindElementVisitor(int n) {
            this.offset = n;
        }

        boolean checkInside(PHPCodeData pHPCodeData) {
            boolean bl;
            UserData userData = pHPCodeData.getUserData();
            boolean bl2 = bl = userData.getStartPosition() <= this.offset && userData.getEndPosition() >= this.offset;
            if (bl) {
                this.foundElement = pHPCodeData;
            }
            return bl;
        }

        public void visit(PHPCodeData pHPCodeData) {
            this.checkInside(pHPCodeData);
        }

        public void visit(PHPFunctionData pHPFunctionData) {
            this.checkInside(pHPFunctionData);
        }

        public void visit(PHPClassData pHPClassData) {
            this.checkInside(pHPClassData);
        }

        public void visit(PHPClassData.PHPSuperClassNameData pHPSuperClassNameData) {
            this.checkInside(pHPSuperClassNameData);
        }

        public void visit(PHPClassData.PHPInterfaceNameData pHPInterfaceNameData) {
            this.checkInside(pHPInterfaceNameData);
        }

        public void visit(PHPClassVarData pHPClassVarData) {
            this.checkInside(pHPClassVarData);
        }

        public void visit(PHPClassConstData pHPClassConstData) {
            this.checkInside(pHPClassConstData);
        }

        public void visit(PHPIncludeFileData pHPIncludeFileData) {
            this.checkInside(pHPIncludeFileData);
        }

        public void visit(PHPKeywordData pHPKeywordData) {
            this.checkInside(pHPKeywordData);
        }

        public void visit(PHPFunctionData.PHPFunctionParameter pHPFunctionParameter) {
            this.checkInside(pHPFunctionParameter);
        }

        public void visit(PHPVariableData pHPVariableData) {
            this.checkInside(pHPVariableData);
        }

        public void visit(PHPFileData pHPFileData) {
            this.checkInside(pHPFileData);
        }

        public void visit(PHPConstantData pHPConstantData) {
            this.checkInside(pHPConstantData);
        }

        public void visit(PHPDocTagData pHPDocTagData) {
        }
    }
}

