/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpModel.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.core.PHPCorePlugin;
import org.eclipse.php.core.documentModel.IWorkspaceModelListener;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.ModelListener;
import org.eclipse.php.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.core.util.project.observer.ProjectRemovedObserversAttacher;

public class PHPWorkspaceModelManager
implements ModelListener {
    protected static final PHPWorkspaceModelManager instance = new PHPWorkspaceModelManager();
    protected static final HashMap models = new HashMap();
    private static final Set modelListeners = Collections.synchronizedSet(new HashSet(2));
    private static final Map workspaceModelListeners = Collections.synchronizedMap(new HashMap(2));
    private static final Set globalWorkspaceModelListeners = Collections.synchronizedSet(new HashSet(2));

    private PHPWorkspaceModelManager() {
    }

    public static PHPWorkspaceModelManager getInstance() {
        return instance;
    }

    public void startup() {
        this.initGlobalModelListeners();
        this.runBuild();
        this.attachProjectOpenObserver();
        this.initLanguageModels();
    }

    private void initLanguageModels() {
        PHPLanguageManagerProvider.instance();
    }

    private void initGlobalModelListeners() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core.workspaceModelListener");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("WorkspaceModelListener")) {
                WorkspaceModelListenerProxy workspaceModelListenerProxy = new WorkspaceModelListenerProxy(iConfigurationElement);
                IWorkspaceModelListener iWorkspaceModelListener = workspaceModelListenerProxy.getListener();
                this.addWorkspaceModelListener(iWorkspaceModelListener);
            }
            ++n;
        }
    }

    private void attachProjectOpenObserver() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
                if (iResourceDelta == null) {
                    return;
                }
                IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
                int n = 0;
                while (n < iResourceDeltaArray.length) {
                    iResourceDelta = iResourceDeltaArray[n];
                    IResource iResource = iResourceDelta.getResource();
                    IProject iProject = (IProject)iResource;
                    int n2 = iResourceDelta.getFlags();
                    if ((n2 & 0x4000) != 0 && iProject.isOpen()) {
                        PHPWorkspaceModelManager.this.runBuild(iProject);
                    }
                    ++n;
                }
            }
        });
    }

    private void runBuild(final IProject iProject) {
        WorkspaceJob workspaceJob = new WorkspaceJob("Creating php model ..."){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    iProject.build(15, iProgressMonitor);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        workspaceJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        workspaceJob.setUser(false);
        workspaceJob.schedule();
    }

    private void runBuild() {
        WorkspaceJob workspaceJob = new WorkspaceJob("Creating php model ..."){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    ResourcesPlugin.getWorkspace().build(6, iProgressMonitor);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        workspaceJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        workspaceJob.setUser(false);
        workspaceJob.schedule();
    }

    public void shutdown() {
        IProject[] iProjectArray = this.listProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            this.removeModel(iProjectArray[n]);
            ++n;
        }
    }

    public PHPFileData getModelForFile(String string, boolean bl) {
        Path path = new Path(string);
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        PHPProjectModel pHPProjectModel = this.getModelForProject(iProject, bl);
        if (pHPProjectModel == null) {
            return null;
        }
        PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
        if (pHPFileData == null && bl) {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            this.addFileToModel(iFile);
            pHPFileData = pHPProjectModel.getFileData(string);
        }
        return pHPFileData;
    }

    public PHPFileData getModelForFile(IFile iFile, boolean bl) {
        PHPProjectModel pHPProjectModel = this.getModelForProject(iFile.getProject(), bl);
        if (pHPProjectModel == null) {
            return null;
        }
        String string = iFile.getFullPath().toString();
        PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
        if (pHPFileData == null && bl) {
            this.addFileToModel(iFile);
            pHPFileData = pHPProjectModel.getFileData(string);
        }
        return pHPFileData;
    }

    public PHPFileData getModelForFile(String string) {
        return this.getModelForFile(string, false);
    }

    public PHPProjectModel getModelForProject(IProject iProject, boolean bl) {
        PHPProjectModel pHPProjectModel = (PHPProjectModel)models.get(iProject);
        if (pHPProjectModel == null && bl && iProject.isOpen() && iProject.exists() && iProject.isAccessible()) {
            boolean bl2;
            try {
                bl2 = iProject.hasNature("org.eclipse.php.core.PHPNature");
            }
            catch (CoreException coreException) {
                PHPCorePlugin.log(coreException);
                return null;
            }
            if (bl2) {
                pHPProjectModel = new PHPProjectModel();
                this.putModel(iProject, pHPProjectModel);
                this.attachProjectCloseObserver(iProject);
            }
        }
        return pHPProjectModel;
    }

    private void attachProjectCloseObserver(final IProject iProject) {
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(iProject, new IProjectClosedObserver(){

            public void closed() {
                PHPWorkspaceModelManager.this.removeModel(iProject);
            }
        });
    }

    public PHPProjectModel getModelForProject(IProject iProject) {
        return this.getModelForProject(iProject, false);
    }

    public IProject getProjectForModel(PHPProjectModel pHPProjectModel) {
        Iterator iterator = models.keySet().iterator();
        while (iterator.hasNext()) {
            IProject iProject = (IProject)iterator.next();
            PHPProjectModel pHPProjectModel2 = this.getModelForProject(iProject);
            if (!pHPProjectModel.equals(pHPProjectModel2)) continue;
            return iProject;
        }
        return null;
    }

    public IProject[] listProjects() {
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        IProject[] iProjectArray = models.keySet().iterator();
        while (iProjectArray.hasNext()) {
            IProject iProject = (IProject)iProjectArray.next();
            if (!iProject.exists() || !iProject.isOpen()) continue;
            arrayList.add(iProject);
        }
        iProjectArray = arrayList.toArray(new IProject[arrayList.size()]);
        return iProjectArray;
    }

    public PHPProjectModel[] listModels() {
        int n = 0;
        PHPProjectModel[] pHPProjectModelArray = new PHPProjectModel[models.size()];
        Iterator iterator = models.values().iterator();
        while (iterator.hasNext()) {
            pHPProjectModelArray[n++] = (PHPProjectModel)iterator.next();
        }
        return pHPProjectModelArray;
    }

    public void removeModel(IProject iProject) {
        PHPProjectModel pHPProjectModel = this.getModelForProject(iProject);
        if (pHPProjectModel != null) {
            pHPProjectModel.getPHPUserModel().removeModelListener(this);
            pHPProjectModel.dispose();
        }
        models.remove(iProject);
        this.fireProjectModelRemoved(iProject);
    }

    private void putModel(IProject iProject, PHPProjectModel pHPProjectModel) {
        PHPProjectModel pHPProjectModel2 = (PHPProjectModel)models.get(iProject);
        models.put(iProject, pHPProjectModel);
        pHPProjectModel.initialize(iProject);
        if (pHPProjectModel2 == null) {
            pHPProjectModel.getPHPUserModel().addModelListener(this);
        } else {
            this.copyUserModelListeners(pHPProjectModel.getPHPUserModel(), pHPProjectModel2.getPHPUserModel().getModelListenerList());
        }
        if (pHPProjectModel2 == null) {
            this.fireProjectModelAdded(iProject);
        } else {
            this.fireProjectModelChanged(iProject);
        }
    }

    private void copyUserModelListeners(PHPUserModel pHPUserModel, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ModelListener modelListener = (ModelListener)iterator.next();
            pHPUserModel.addModelListener(modelListener);
        }
    }

    public void addModelListener(ModelListener modelListener) {
        modelListeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        modelListeners.remove(modelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelListener[] getModelListenersIteratorCopy() {
        Set set = modelListeners;
        synchronized (set) {
            ModelListener[] modelListenerArray = new ModelListener[modelListeners.size()];
            modelListeners.toArray(modelListenerArray);
            return modelListenerArray;
        }
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        ModelListener[] modelListenerArray = this.getModelListenersIteratorCopy();
        int n = 0;
        while (n < modelListenerArray.length) {
            modelListenerArray[n].fileDataChanged(pHPFileData);
            ++n;
        }
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
        ModelListener[] modelListenerArray = this.getModelListenersIteratorCopy();
        int n = 0;
        while (n < modelListenerArray.length) {
            modelListenerArray[n].fileDataAdded(pHPFileData);
            ++n;
        }
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
        ModelListener[] modelListenerArray = this.getModelListenersIteratorCopy();
        int n = 0;
        while (n < modelListenerArray.length) {
            modelListenerArray[n].fileDataRemoved(pHPFileData);
            ++n;
        }
    }

    public void dataCleared() {
        ModelListener[] modelListenerArray = this.getModelListenersIteratorCopy();
        int n = 0;
        while (n < modelListenerArray.length) {
            modelListenerArray[n].dataCleared();
            ++n;
        }
    }

    public void addWorkspaceModelListener(String string, IWorkspaceModelListener iWorkspaceModelListener) {
        List<IWorkspaceModelListener> list = (List<IWorkspaceModelListener>)workspaceModelListeners.get(string);
        if (list == null) {
            list = Collections.synchronizedList(new ArrayList(2));
            workspaceModelListeners.put(string, list);
        }
        if (!list.contains(iWorkspaceModelListener)) {
            list.add(iWorkspaceModelListener);
        }
    }

    public void removeWorkspaceModelListener(String string, IWorkspaceModelListener iWorkspaceModelListener) {
        List list = (List)workspaceModelListeners.get(string);
        if (list == null) {
            return;
        }
        list.remove(iWorkspaceModelListener);
    }

    public void addFileToModel(IFile iFile) {
        if (!PHPModelUtil.isPhpFile(iFile)) {
            return;
        }
        PHPProjectModel pHPProjectModel = this.getModelForProject(iFile.getProject());
        pHPProjectModel.addFileToModel(iFile);
    }

    public void removeFileFromModel(IFile iFile) {
        PHPProjectModel pHPProjectModel = this.getModelForProject(iFile.getProject());
        if (pHPProjectModel == null) {
            return;
        }
        pHPProjectModel.removeFileFromModel(iFile);
    }

    public void addWorkspaceModelListener(IWorkspaceModelListener iWorkspaceModelListener) {
        globalWorkspaceModelListeners.add(iWorkspaceModelListener);
    }

    public void removeWorkspaceModelListener(IWorkspaceModelListener iWorkspaceModelListener) {
        globalWorkspaceModelListeners.remove(iWorkspaceModelListener);
    }

    public void fireProjectModelAdded(IProject iProject) {
        Object object;
        Object object2 = globalWorkspaceModelListeners.iterator();
        while (object2.hasNext()) {
            object = (IWorkspaceModelListener)object2.next();
            object.projectModelAdded(iProject);
        }
        object2 = (List)workspaceModelListeners.get(iProject.getName());
        if (object2 == null) {
            return;
        }
        object = object2.iterator();
        while (object.hasNext()) {
            IWorkspaceModelListener iWorkspaceModelListener = (IWorkspaceModelListener)object.next();
            iWorkspaceModelListener.projectModelAdded(iProject);
        }
    }

    public void fireProjectModelRemoved(IProject iProject) {
        Object object;
        Object object2 = globalWorkspaceModelListeners.iterator();
        while (object2.hasNext()) {
            object = (IWorkspaceModelListener)object2.next();
            object.projectModelRemoved(iProject);
        }
        object2 = (List)workspaceModelListeners.get(iProject.getName());
        if (object2 == null) {
            return;
        }
        object = object2.iterator();
        while (object.hasNext()) {
            IWorkspaceModelListener iWorkspaceModelListener = (IWorkspaceModelListener)object.next();
            iWorkspaceModelListener.projectModelRemoved(iProject);
        }
    }

    public void fireProjectModelChanged(IProject iProject) {
        Object object;
        Object object2 = globalWorkspaceModelListeners.iterator();
        while (object2.hasNext()) {
            object = (IWorkspaceModelListener)object2.next();
            object.projectModelChanged(iProject);
        }
        object2 = (List)workspaceModelListeners.get(iProject.getName());
        if (object2 == null) {
            return;
        }
        object = object2.iterator();
        while (object.hasNext()) {
            IWorkspaceModelListener iWorkspaceModelListener = (IWorkspaceModelListener)object.next();
            iWorkspaceModelListener.projectModelChanged(iProject);
        }
    }

    private class WorkspaceModelListenerProxy {
        private final IConfigurationElement element;
        private IWorkspaceModelListener listener;

        public WorkspaceModelListenerProxy(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IWorkspaceModelListener getListener() {
            if (this.listener == null) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(this, "Error creation PhpModel for extension-point org.eclipse.php.core.workspaceModelListener"){
                    final /* synthetic */ WorkspaceModelListenerProxy this$1;
                    {
                        this.this$1 = workspaceModelListenerProxy;
                        super(string);
                    }

                    public void run() throws Exception {
                        WorkspaceModelListenerProxy.access$1(this.this$1, (IWorkspaceModelListener)WorkspaceModelListenerProxy.access$0(this.this$1).createExecutableExtension("class"));
                    }
                });
            }
            return this.listener;
        }

        static /* synthetic */ IConfigurationElement access$0(WorkspaceModelListenerProxy workspaceModelListenerProxy) {
            return workspaceModelListenerProxy.element;
        }

        static /* synthetic */ void access$1(WorkspaceModelListenerProxy workspaceModelListenerProxy, IWorkspaceModelListener iWorkspaceModelListener) {
            workspaceModelListenerProxy.listener = iWorkspaceModelListener;
        }
    }
}

