/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.internal.databinding.provisional.observable.AbstractObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.IChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IMappingChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.MappingDiff;

public abstract class BaseObservableMapping
extends AbstractObservable {
    protected Object mappingChangeListeners = null;

    public void addMappingChangeListener(IMappingChangeListener listener) {
        ArrayList<Object> listenerList;
        if (this.mappingChangeListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.mappingChangeListeners = listener;
            if (!hadListeners) {
                this.firstListenerAdded();
            }
            return;
        }
        if (this.mappingChangeListeners instanceof IMappingChangeListener) {
            IChangeListener l = (IChangeListener)this.mappingChangeListeners;
            listenerList = new ArrayList<Object>();
            listenerList.add(l);
        } else {
            listenerList = (ArrayList<Object>)this.mappingChangeListeners;
        }
        if (listenerList.size() > 16) {
            HashSet<Object> listenerSet = new HashSet<Object>();
            listenerSet.addAll(listenerList);
            this.mappingChangeListeners = listenerList;
        }
        listenerList.add(listener);
    }

    public void removeMappingChangeListener(IMappingChangeListener listener) {
        if (this.mappingChangeListeners == listener) {
            this.mappingChangeListeners = null;
            if (!this.hasListeners()) {
                this.lastListenerRemoved();
            }
            return;
        }
        if (this.mappingChangeListeners instanceof Collection) {
            Collection listenerList = (Collection)this.mappingChangeListeners;
            listenerList.remove(listener);
            if (listenerList.size() == 0) {
                this.mappingChangeListeners = null;
                if (!this.hasListeners()) {
                    this.lastListenerRemoved();
                }
            }
        }
    }

    protected void fireMappingValueChange(MappingDiff diff) {
        if (this.mappingChangeListeners == null) {
            return;
        }
        if (this.mappingChangeListeners instanceof IMappingChangeListener) {
            ((IMappingChangeListener)this.mappingChangeListeners).handleMappingValueChange(this, diff);
            return;
        }
        Collection changeListenerCollection = (Collection)this.mappingChangeListeners;
        IMappingChangeListener[] listeners = changeListenerCollection.toArray(new IMappingChangeListener[changeListenerCollection.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].handleMappingValueChange(this, diff);
            ++i;
        }
    }
}

