/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.NewExampleAction;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class PHPNewWizardMenu
extends ContributionItem {
    private IAction showDlgAction;
    private IAction newProjectAction;
    private IAction newExampleAction;
    private Map actions = new HashMap(21);
    private boolean enabled = true;
    private IWorkbenchWindow window;
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager iMenuManager) {
            iMenuManager.markDirty();
            PHPNewWizardMenu.this.dirty = true;
        }
    };
    static /* synthetic */ Class class$0;

    public PHPNewWizardMenu(IMenuManager iMenuManager, IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        this(iWorkbenchWindow);
        this.fillMenu((IContributionManager)iMenuManager);
    }

    public PHPNewWizardMenu(IWorkbenchWindow iWorkbenchWindow) {
        this.window = iWorkbenchWindow;
        this.showDlgAction = ActionFactory.NEW.create(iWorkbenchWindow);
        this.newProjectAction = new NewProjectAction(iWorkbenchWindow);
        this.newExampleAction = new NewExampleAction(iWorkbenchWindow);
    }

    private void fillMenu(IContributionManager iContributionManager) {
        iContributionManager.removeAll();
        if (this.enabled) {
            iContributionManager.add(this.newProjectAction);
            String[] stringArray = null;
            IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
            if (iWorkbenchPage != null) {
                stringArray = ((WorkbenchPage)iWorkbenchPage).getNewWizardShortcuts();
            }
            if (stringArray != null) {
                if (stringArray.length > 0) {
                    iContributionManager.add((IContributionItem)new Separator());
                }
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    IAction iAction = this.getAction(string);
                    if (iAction != null && !WorkbenchActivityHelper.filterItem((Object)iAction)) {
                        iContributionManager.add(iAction);
                    }
                    ++n;
                }
            }
            if (this.hasExamples()) {
                iContributionManager.add((IContributionItem)new Separator());
                iContributionManager.add(this.newExampleAction);
            }
            iContributionManager.add((IContributionItem)new Separator());
            iContributionManager.add(this.showDlgAction);
        }
    }

    private IAction getAction(String string) {
        IWizardDescriptor iWizardDescriptor;
        IAction iAction = (IAction)this.actions.get(string);
        if (iAction == null && (iWizardDescriptor = WorkbenchPlugin.getDefault().getNewWizardRegistry().findWizard(string)) != null) {
            IConfigurationElement iConfigurationElement;
            iAction = new NewWizardShortcutAction(this.window, iWizardDescriptor);
            this.actions.put(string, iAction);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.IConfigurationElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iConfigurationElement = (IConfigurationElement)iWizardDescriptor.getAdapter((Class)clazz)) != null) {
                this.window.getExtensionTracker().registerObject(iConfigurationElement.getDeclaringExtension(), (Object)iAction, 2);
            }
        }
        return iAction;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void deregisterListeners() {
    }

    public void fill(Menu menu, int n) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager menuManager = new MenuManager();
        this.fillMenu((IContributionManager)menuManager);
        IContributionItem[] iContributionItemArray = menuManager.getItems();
        int n2 = 0;
        while (n2 < iContributionItemArray.length) {
            iContributionItemArray[n2].fill(menu, n++);
            ++n2;
        }
        this.dirty = false;
    }

    protected boolean registryHasCategory(String string) {
        return WorkbenchPlugin.getDefault().getNewWizardRegistry().findCategory(string) != null;
    }

    private boolean hasExamples() {
        return this.registryHasCategory("org.eclipse.ui.Examples");
    }
}

