/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.Logger;
import org.eclipse.php.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.autoEdit.MatchingCharAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class MatchingBracketAutoEditStrategy
extends MatchingCharAutoEditStrategy {
    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (TypingPreferences.closeBrackets && documentCommand.text != null) {
            char c;
            int n = documentCommand.text.length();
            if (n == 0 && documentCommand.length == 1) {
                try {
                    c = iDocument.getChar(documentCommand.offset);
                    if (c == '(' || c == '[') {
                        this.deletePairBreaket((IStructuredDocument)iDocument, documentCommand, c);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Logger.logException(badLocationException);
                }
            }
            if (n == 1) {
                c = documentCommand.text.charAt(0);
                if (c == '(' || c == '[') {
                    this.autoAddPairBracket((IStructuredDocument)iDocument, documentCommand);
                } else if (c == ')' || c == ']') {
                    this.insertClosingChar((IStructuredDocument)iDocument, documentCommand);
                }
            }
        }
    }

    private void autoAddPairBracket(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand) {
        block6: {
            int n = documentCommand.offset;
            int n2 = documentCommand.length;
            char c = documentCommand.text.charAt(0);
            boolean bl = false;
            String string = "";
            try {
                if (n + n2 < iStructuredDocument.getLength() && !this.shouldAddClosingBracket(iStructuredDocument, n + n2, false)) {
                    return;
                }
                string = iStructuredDocument.get(n, n2);
                iStructuredDocument.getUndoManager().disableUndoManagement();
                iStructuredDocument.replace(n, n2, documentCommand.text);
                bl = true;
                int n3 = this.isMatchingCharNeeded(iStructuredDocument, n, c);
                iStructuredDocument.replace(n, 1, string);
                iStructuredDocument.getUndoManager().enableUndoManagement();
                if (n3 == 0) {
                    char c2 = MatchingBracketAutoEditStrategy.getMatchingChar(c);
                    documentCommand.text = String.valueOf(documentCommand.text) + c2;
                    iStructuredDocument.replace(n, n2, documentCommand.text);
                    iStructuredDocument.getUndoManager().disableUndoManagement();
                    iStructuredDocument.replace(n + 1, 0, "");
                    iStructuredDocument.getUndoManager().enableUndoManagement();
                    ++documentCommand.offset;
                    documentCommand.length = 0;
                    documentCommand.text = "";
                }
            }
            catch (Exception exception) {
                Logger.logException(exception);
                if (!bl) break block6;
                try {
                    iStructuredDocument.replace(n, 1, string);
                    iStructuredDocument.getUndoManager().enableUndoManagement();
                }
                catch (BadLocationException badLocationException) {
                    Logger.logException(badLocationException);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int isMatchingCharNeeded(IStructuredDocument iStructuredDocument, int n, char c) {
        try {
            String string = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)(n + 1));
            if (string != "org.eclipse.php.PHP_DEFAULT" && string != "PHP_OPENTAG" && string != "PHP_CLOSETAG" && MatchingBracketAutoEditStrategy.isSpecialOpenCurlyInQuotes(iStructuredDocument, n)) {
                string = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)(n + 2));
            }
            if (iStructuredDocument.getLength() == n + 1) {
                string = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)n);
                if (string != "org.eclipse.php.PHP_DEFAULT" && string != "PHP_OPENTAG") {
                    if (string != "PHP_CLOSETAG") return 1;
                }
                if (iStructuredDocument.getChar(n) != MatchingBracketAutoEditStrategy.getMatchingChar(c)) return 0;
                return 1;
            }
            if (string != "org.eclipse.php.PHP_DEFAULT" && string != "PHP_OPENTAG" && string != "PHP_CLOSETAG") {
                return -1;
            }
            int n2 = n + 1;
            IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n2);
            while (n2 >= 0) {
                if (iStructuredDocumentRegion == null) {
                    return 1;
                }
                if (iStructuredDocumentRegion.getType() != "PHP_CONTENT") {
                    n2 = iStructuredDocumentRegion.getStartOffset() - 1;
                    iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n2);
                    continue;
                }
                int n3 = iStructuredDocumentRegion.getStart();
                ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n2);
                while (true) {
                    block14: {
                        if (iTextRegion != null) break block14;
                    }
                    String string2 = iTextRegion.getType();
                    if (string2 == "PHP_TOKEN") {
                        char c2 = iStructuredDocumentRegion.getText(iTextRegion).charAt(0);
                        if ((c2 == '(' || c2 == '[') && c2 == c && matcher.match((IDocument)iStructuredDocument, n3 + iTextRegion.getStart() + 1) == null) {
                            return 0;
                        }
                    } else {
                        if (string2 == "PHP_CURLY_OPEN") return 1;
                        if (string2 == "PHP_CURLY_CLOSE") {
                            return 1;
                        }
                    }
                    n2 = n3 + iTextRegion.getStart() - 1;
                    iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n2);
                }
                n2 = iStructuredDocumentRegion.getStartOffset() - 1;
                iStructuredDocumentRegion = n2 < 0 ? null : iStructuredDocument.getRegionAtCharacterOffset(n2);
            }
            return 1;
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
        return 1;
    }

    private void insertClosingChar(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand) {
        int n = documentCommand.offset + documentCommand.length;
        char c = documentCommand.text.charAt(0);
        if (n == iStructuredDocument.getLength()) {
            return;
        }
        try {
            int n2;
            char c2 = iStructuredDocument.getChar(n);
            if (c2 == c && (n2 = this.isMatchingCharNeeded(iStructuredDocument, n, MatchingBracketAutoEditStrategy.getMatchingChar(c))) == 1 && (matcher.match((IDocument)iStructuredDocument, n + 1) != null || iStructuredDocument.getLength() == n + 1)) {
                if (documentCommand.length == 0) {
                    ++documentCommand.offset;
                    documentCommand.text = "";
                } else {
                    ++documentCommand.length;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
    }

    private void deletePairBreaket(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand, char c) {
        int n = documentCommand.offset;
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        if (iStructuredDocumentRegion == null || iStructuredDocumentRegion.getType() != "PHP_CONTENT") {
            return;
        }
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion == null) {
            return;
        }
        String string = iTextRegion.getType();
        if (string != "PHP_TOKEN") {
            return;
        }
        try {
            boolean bl;
            char c2 = iStructuredDocument.getChar(n + 1);
            char c3 = MatchingBracketAutoEditStrategy.getMatchingChar(c);
            if (c3 == '-' || c2 != c3) {
                return;
            }
            boolean bl2 = bl = this.isMatchingCharNeeded(iStructuredDocument, n, c) == 1;
            if (bl) {
                documentCommand.length = 2;
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

