/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.PHPManualConfigurationBlock;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewPHPManualSiteDialog
extends StatusDialog {
    protected Text name;
    protected Text url;
    protected Text extension;
    private Button okButton;
    private Button browseButton;
    private boolean enableOK = false;
    private List configs;
    private PHPManualConfigurationBlock.PHPManualConfig edited;
    private PHPManualConfigurationBlock.PHPManualConfig result;

    public NewPHPManualSiteDialog(Shell shell, PHPManualConfigurationBlock.PHPManualConfig pHPManualConfig, List list) {
        super(shell);
        this.configs = new ArrayList(list.size());
        int n = 0;
        while (n < list.size()) {
            PHPManualConfigurationBlock.PHPManualConfig pHPManualConfig2 = (PHPManualConfigurationBlock.PHPManualConfig)list.get(n);
            if (!pHPManualConfig2.equals(pHPManualConfig)) {
                this.configs.add(pHPManualConfig2);
            }
            ++n;
        }
        this.edited = pHPManualConfig;
        if (pHPManualConfig != null) {
            this.setTitle(PHPUIMessages.NewPHPManualSiteDialog_updateTitle);
        } else {
            this.setTitle(PHPUIMessages.NewPHPManualSiteDialog_newTitle);
        }
    }

    public PHPManualConfigurationBlock.PHPManualConfig getResult() {
        return this.result;
    }

    protected void setResult(PHPManualConfigurationBlock.PHPManualConfig pHPManualConfig) {
        this.result = pHPManualConfig;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(this.enableOK);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.widthHint = 400;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(PHPUIMessages.NewPHPManualSiteDialog_name);
        this.name = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.name.setLayoutData((Object)gridData);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewPHPManualSiteDialog.this.verifyComplete();
            }
        });
        label = new Label(composite2, 0);
        label.setText(PHPUIMessages.NewPHPManualSiteDialog_url);
        this.url = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.url.setLayoutData((Object)gridData);
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewPHPManualSiteDialog.this.verifyComplete();
            }
        });
        this.browseButton = new Button(composite2, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        gridData.widthHint = 50;
        this.browseButton.setLayoutData((Object)gridData);
        this.browseButton.setText("...");
        this.browseButton.setAlignment(0x1000000);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewPHPManualSiteDialog.this.choosePHPManualFolder();
            }
        });
        label = new Label(composite2, 0);
        label.setText(PHPUIMessages.NewPHPManualSiteDialog_fileExtension);
        this.extension = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.extension.setLayoutData((Object)gridData);
        this.extension.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewPHPManualSiteDialog.this.verifyComplete();
            }
        });
        this.initializeFields();
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void initializeFields() {
        if (this.edited != null) {
            this.name.setText(this.edited.getLabel());
            this.url.setText(this.edited.getUrl());
            this.extension.setText(this.edited.getExtension());
        } else {
            this.url.setText("http://");
            this.extension.setText("php");
        }
    }

    private void verifyComplete() {
        if (this.okButton == null) {
            return;
        }
        if (this.name.getText().trim().length() == 0 || this.url.getText().trim().length() == 0) {
            this.okButton.setEnabled(false);
            this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.NewPHPManualSiteDialog_siteOrUrlNotSpecified, null));
            return;
        }
        try {
            new URL(URLDecoder.decode(this.url.getText().trim(), "UTF-8"));
        }
        catch (Exception exception) {
            this.okButton.setEnabled(false);
            this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.NewPHPManualSiteDialog_incorrectUrl, null));
            return;
        }
        if (this.isDuplicate()) {
            return;
        }
        this.okButton.setEnabled(true);
        this.updateStatus((IStatus)new Status(0, PHPUiPlugin.getPluginId(), 0, "", null));
        this.result = new PHPManualConfigurationBlock.PHPManualConfig(this.name.getText(), this.url.getText(), this.extension.getText(), false);
    }

    private boolean isDuplicate() {
        if (this.configs == null) {
            return false;
        }
        int n = 0;
        while (n < this.configs.size()) {
            if (!this.isCurrentlyEditedSiteBookmark(n)) {
                PHPManualConfigurationBlock.PHPManualConfig pHPManualConfig = (PHPManualConfigurationBlock.PHPManualConfig)this.configs.get(n);
                if (pHPManualConfig.getLabel().equals(this.name.getText().trim())) {
                    this.okButton.setEnabled(false);
                    this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.NewPHPManualSiteDialog_nameAlreadyInUse, null));
                    return true;
                }
                if (pHPManualConfig.getUrl().toString().trim().equals(this.url.getText().trim())) {
                    this.okButton.setEnabled(false);
                    this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, NLS.bind((String)PHPUIMessages.NewPHPManualSiteDialog_urlAlreadyInUse, (Object)pHPManualConfig.getLabel()), null));
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    protected boolean isCurrentlyEditedSiteBookmark(int n) {
        return false;
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        if (this.okButton != null && !this.okButton.isDisposed() && this.name.getText().trim().length() != 0) {
            this.okButton.setEnabled(!iStatus.matches(4));
        }
    }

    private void choosePHPManualFolder() {
        DirectoryDialog directoryDialog = new DirectoryDialog(PHPUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        directoryDialog.setText(PHPUIMessages.NewPHPManualSiteDialog_chooseDir);
        String string = directoryDialog.open();
        if (string == null) {
            return;
        }
        this.url.setText("file://" + string);
    }
}

