/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDSchemaBuildingTools;
import org.w3c.dom.Text;

public final class AddXSDComplexTypeDefinitionCommand
extends BaseCommand {
    protected XSDConcreteComponent parent;
    protected XSDComplexTypeDefinition createdComplexType;
    private String nameToAdd;

    public AddXSDComplexTypeDefinitionCommand(String label, XSDConcreteComponent parent) {
        super(label);
        this.parent = parent;
    }

    public void setNameToAdd(String nameToAdd) {
        this.nameToAdd = nameToAdd;
    }

    public void execute() {
        XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
        XSDComplexTypeDefinition complexType = factory.createXSDComplexTypeDefinition();
        this.addedXSDConcreteComponent = complexType;
        String newName = this.getNewName(this.nameToAdd == null ? "NewXSDComplexType" : this.nameToAdd, this.parent.getSchema());
        complexType.setName(newName);
        if (this.parent instanceof XSDSchema) {
            try {
                XSDSchema xsdSchema = (XSDSchema)this.parent;
                AddXSDComplexTypeDefinitionCommand.ensureSchemaElement(xsdSchema);
                Text textNode = xsdSchema.getDocument().createTextNode("\n");
                xsdSchema.getElement().appendChild(textNode);
                xsdSchema.getContents().add((Object)complexType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.parent instanceof XSDElementDeclaration) {
            ((XSDElementDeclaration)this.parent).setAnonymousTypeDefinition((XSDTypeDefinition)complexType);
            this.formatChild(this.parent.getElement());
        }
        this.createdComplexType = complexType;
    }

    protected String getNewName(String description, XSDSchema schema) {
        String candidateName = description;
        int i = 1;
        EList list = schema.getTypeDefinitions();
        ArrayList<String> listOfNames = new ArrayList<String>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            XSDTypeDefinition typeDef = (XSDTypeDefinition)iter.next();
            String name = typeDef.getName();
            if (name == null) {
                name = "";
            }
            if (typeDef.getTargetNamespace() != schema.getTargetNamespace()) continue;
            listOfNames.add(name);
        }
        boolean flag = true;
        while (flag) {
            if (!listOfNames.contains(candidateName)) {
                flag = false;
                break;
            }
            candidateName = String.valueOf(description) + String.valueOf(i);
            ++i;
        }
        return candidateName;
    }

    public XSDComplexTypeDefinition getCreatedComplexType() {
        return this.createdComplexType;
    }
}

