/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit4.runner;

import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.IVisitsTestTrees;
import org.eclipse.jdt.internal.junit4.runner.JUnit4Identifier;
import org.eclipse.jdt.internal.junit4.runner.JUnit4TestReference;
import org.junit.runner.Description;
import org.junit.runner.Request;

public class JUnit4TestClassReference
extends JUnit4TestReference {
    protected final Class<?> fClass;

    public JUnit4TestClassReference(Class clazz) {
        super(Request.aClass((Class)clazz));
        this.fClass = clazz;
    }

    public int countTestCases() {
        return this.fRunner.testCount();
    }

    public String getName() {
        return this.fClass.getName();
    }

    public void sendTree(IVisitsTestTrees notified) {
        this.sendDescriptionTree(notified, this.fRunner.getDescription());
    }

    private void sendDescriptionTree(IVisitsTestTrees notified, Description description) {
        if (description.isTest()) {
            notified.visitTreeEntry((ITestIdentifier)new JUnit4Identifier(description), false, 1);
        } else {
            notified.visitTreeEntry((ITestIdentifier)new JUnit4Identifier(description), true, description.getChildren().size());
            for (Description child : description.getChildren()) {
                this.sendDescriptionTree(notified, child);
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JUnit4TestReference)) {
            return false;
        }
        JUnit4TestReference ref = (JUnit4TestReference)obj;
        return ref.getIdentifier().equals(this.getIdentifier());
    }

    public int hashCode() {
        return this.fClass.hashCode();
    }

    public ITestIdentifier getIdentifier() {
        return new JUnit4Identifier(this.fRunner.getDescription());
    }
}

