/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import org.eclipse.debug.internal.ui.viewers.AbstractUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelDelta;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;

public class TreeUpdatePolicy
extends AbstractUpdatePolicy
implements IModelChangedListener {
    private TreePath fTreePath;
    private IModelDelta fNode;

    public void modelChanged(IModelDelta delta) {
        this.updateNodes(new IModelDelta[]{delta});
        this.fTreePath = null;
        this.fNode = null;
    }

    protected void updateNodes(IModelDelta[] nodes) {
        AsynchronousTreeViewer viewer = (AsynchronousTreeViewer)this.getViewer();
        if (viewer == null) {
            return;
        }
        int i = 0;
        while (i < nodes.length) {
            IModelDelta node = nodes[i];
            int flags = node.getFlags();
            if ((flags & 1) != 0) {
                this.handleAdd(viewer, node);
            }
            if ((flags & 2) != 0) {
                this.handleRemove(viewer, node);
            }
            if ((flags & 0x400) != 0) {
                this.handleContent(viewer, node);
            }
            if ((flags & 0x100000) != 0) {
                this.handleExpand(viewer, node);
            }
            if ((flags & 0x200000) != 0) {
                this.handleSelect(viewer, node);
            }
            if ((flags & 0x800) != 0) {
                this.handleState(viewer, node);
            }
            this.updateNodes(node.getNodes());
            ++i;
        }
    }

    protected void handleState(AsynchronousTreeViewer viewer, IModelDelta delta) {
        viewer.update(delta.getElement());
    }

    protected void handleSelect(AsynchronousTreeViewer viewer, IModelDelta delta) {
        viewer.setSelection((ISelection)new TreeSelection(this.getTreePath(delta)));
    }

    protected void handleExpand(AsynchronousTreeViewer viewer, IModelDelta delta) {
        viewer.expand((ISelection)new TreeSelection(this.getTreePath(delta)));
    }

    protected void handleContent(AsynchronousTreeViewer viewer, IModelDelta delta) {
        viewer.refresh(delta.getElement());
    }

    protected void handleRemove(AsynchronousTreeViewer viewer, IModelDelta delta) {
        viewer.remove(this.getTreePath(delta));
    }

    protected void handleAdd(AsynchronousTreeViewer viewer, IModelDelta delta) {
        viewer.add(this.getTreePath(delta));
    }

    protected TreePath getTreePath(IModelDelta node) {
        if (node != this.fNode) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(0, node.getElement());
            while (node.getParent() != null) {
                node = node.getParent();
                list.add(0, node.getElement());
            }
            this.fTreePath = new TreePath(list.toArray());
            this.fNode = node;
        }
        return this.fTreePath;
    }
}

