/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.syncinfo.BaserevInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.NotifyInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class SyncFileWriter {
    public static final String CVS_DIRNAME = "CVS";
    public static final String REPOSITORY = "Repository";
    public static final String ROOT = "Root";
    public static final String STATIC = "Entries.Static";
    public static final String TAG = "Tag";
    public static final String ENTRIES = "Entries";
    public static final String ENTRIES_LOG = "Entries.Log";
    public static final String NOTIFY = "Notify";
    public static final String BASE_DIRNAME = "Base";
    public static final String BASEREV = "Baserev";
    public static final String IGNORE_FILE = ".cvsignore";
    private static final String FOLDER_TAG = "D";
    private static final String ADD_TAG = "A ";
    private static final String REMOVE_TAG = "R ";
    public static final QualifiedName MODSTAMP_KEY = new QualifiedName("org.eclipse.team.cvs.core", "meta-file-modtime");

    public static byte[][] readAllResourceSync(IContainer parent) throws CVSException {
        String[] entries;
        IFolder cvsSubDir = SyncFileWriter.getCVSSubdirectory(parent);
        if (!SyncFileWriter.folderExists(cvsSubDir)) {
            return null;
        }
        if (Policy.DEBUG_METAFILE_CHANGES) {
            System.out.println("Reading Entries file for " + parent.getFullPath());
        }
        if ((entries = SyncFileWriter.readLines(cvsSubDir.getFile(ENTRIES))) == null) {
            return null;
        }
        TreeMap<String, ResourceSyncInfo> infos = new TreeMap<String, ResourceSyncInfo>();
        int i = 0;
        while (i < entries.length) {
            String line = entries[i];
            if (!FOLDER_TAG.equals(line) && !"".equals(line)) {
                try {
                    ResourceSyncInfo info = new ResourceSyncInfo(line, null);
                    infos.put(info.getName(), info);
                }
                catch (CVSException e) {
                    CVSProviderPlugin.log((IStatus)new CVSStatus(4, NLS.bind((String)CVSMessages.SyncFileWriter_0, (Object[])new String[]{parent.getFullPath().toString()}), (Throwable)((Object)e)));
                }
            }
            ++i;
        }
        String[] entriesLog = SyncFileWriter.readLines(cvsSubDir.getFile(ENTRIES_LOG));
        if (entriesLog != null) {
            int i2 = 0;
            while (i2 < entriesLog.length) {
                ResourceSyncInfo info;
                String line = entriesLog[i2];
                if (line.startsWith(ADD_TAG)) {
                    line = line.substring(ADD_TAG.length());
                    info = new ResourceSyncInfo(line, null);
                    infos.put(info.getName(), info);
                } else if (line.startsWith(REMOVE_TAG)) {
                    line = line.substring(REMOVE_TAG.length());
                    info = new ResourceSyncInfo(line, null);
                    infos.remove(info.getName());
                }
                ++i2;
            }
        }
        byte[][] result = new byte[infos.size()][];
        int i3 = 0;
        Iterator iter = infos.values().iterator();
        while (iter.hasNext()) {
            ResourceSyncInfo info = (ResourceSyncInfo)iter.next();
            result[i3++] = info.getBytes();
        }
        return result;
    }

    private static boolean folderExists(IFolder cvsSubDir) throws CVSException {
        try {
            IFileStore store;
            URI uri = cvsSubDir.getLocationURI();
            if (uri != null && (store = EFS.getStore((URI)uri)) != null) {
                return store.fetchInfo().exists();
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
        return false;
    }

    public static void writeAllResourceSync(IContainer parent, byte[][] infos) throws CVSException {
        try {
            if (Policy.DEBUG_METAFILE_CHANGES) {
                System.out.println("Writing Entries file for folder " + parent.getFullPath());
            }
            IFolder cvsSubDir = SyncFileWriter.createCVSSubdirectory(parent);
            String[] entries = new String[infos.length];
            int i = 0;
            while (i < infos.length) {
                byte[] info = infos[i];
                entries[i] = new String(info);
                ++i;
            }
            SyncFileWriter.writeLines(cvsSubDir.getFile(ENTRIES), entries);
            cvsSubDir.getFile(ENTRIES_LOG).delete(0, null);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    public static FolderSyncInfo readFolderSync(IContainer folder) throws CVSException {
        String root;
        IFolder cvsSubDir = SyncFileWriter.getCVSSubdirectory(folder);
        if (!SyncFileWriter.folderExists(cvsSubDir)) {
            return null;
        }
        if (Policy.DEBUG_METAFILE_CHANGES) {
            System.out.println("Reading Root/Repository files for " + folder.getFullPath());
        }
        if (!cvsSubDir.isTeamPrivateMember() && cvsSubDir.exists()) {
            try {
                cvsSubDir.setTeamPrivateMember(true);
            }
            catch (CoreException e) {
                CVSProviderPlugin.log(e);
            }
        }
        if ((root = SyncFileWriter.readFirstLine(cvsSubDir.getFile(ROOT))) == null) {
            return null;
        }
        String repository = SyncFileWriter.readFirstLine(cvsSubDir.getFile(REPOSITORY));
        if (repository == null) {
            return null;
        }
        String tag = SyncFileWriter.readFirstLine(cvsSubDir.getFile(TAG));
        if (Policy.DEBUG_METAFILE_CHANGES && tag != null) {
            System.out.println("Reading Tag file for " + folder.getFullPath());
        }
        CVSEntryLineTag cvsTag = tag != null ? new CVSEntryLineTag(tag) : null;
        String staticDir = SyncFileWriter.readFirstLine(cvsSubDir.getFile(STATIC));
        if (Policy.DEBUG_METAFILE_CHANGES && staticDir != null) {
            System.out.println("Reading Static file for " + folder.getFullPath());
        }
        boolean isStatic = staticDir != null;
        return new FolderSyncInfo(repository, root, cvsTag, isStatic);
    }

    public static void writeFolderSync(IContainer folder, FolderSyncInfo info) throws CVSException {
        try {
            if (Policy.DEBUG_METAFILE_CHANGES) {
                System.out.println("Writing Root/Respository files for " + folder.getFullPath());
            }
            IFolder cvsSubDir = SyncFileWriter.createCVSSubdirectory(folder);
            SyncFileWriter.writeLines(cvsSubDir.getFile(ROOT), new String[]{info.getRoot()});
            SyncFileWriter.writeLines(cvsSubDir.getFile(REPOSITORY), new String[]{info.getRepository()});
            IFile tagFile = cvsSubDir.getFile(TAG);
            if (info.getTag() != null) {
                if (Policy.DEBUG_METAFILE_CHANGES) {
                    System.out.println("Writing Tag file for " + folder.getFullPath());
                }
                SyncFileWriter.writeLines(tagFile, new String[]{info.getTag().toEntryLineFormat(false)});
            } else if (tagFile.exists()) {
                if (Policy.DEBUG_METAFILE_CHANGES) {
                    System.out.println("Deleting Tag file for " + folder.getFullPath());
                }
                tagFile.delete(0, null);
            }
            IFile staticFile = cvsSubDir.getFile(STATIC);
            if (info.getIsStatic()) {
                if (Policy.DEBUG_METAFILE_CHANGES) {
                    System.out.println("Writing Static file for " + folder.getFullPath());
                }
                SyncFileWriter.writeLines(staticFile, new String[]{""});
            } else if (staticFile.exists()) {
                if (Policy.DEBUG_METAFILE_CHANGES) {
                    System.out.println("Deleting Static file for " + folder.getFullPath());
                }
                staticFile.delete(0, null);
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    public static String[] readCVSIgnoreEntries(IContainer folder) throws CVSException {
        IFile ignoreFile = folder.getFile((IPath)new Path(IGNORE_FILE));
        if (ignoreFile != null) {
            return SyncFileWriter.readLines(ignoreFile);
        }
        return null;
    }

    public static void writeCVSIgnoreEntries(IContainer folder, String[] patterns) throws CVSException {
        IFile ignoreFile = folder.getFile((IPath)new Path(IGNORE_FILE));
        SyncFileWriter.writeLines(ignoreFile, patterns);
    }

    public static void deleteFolderSync(IContainer folder) throws CVSException {
        try {
            if (Policy.DEBUG_METAFILE_CHANGES) {
                System.out.println("Deleting CVS directory from " + folder.getFullPath());
            }
            SyncFileWriter.getCVSSubdirectory(folder).delete(0, null);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    public static NotifyInfo[] readAllNotifyInfo(IContainer parent) throws CVSException {
        IFolder cvsSubDir = SyncFileWriter.getCVSSubdirectory(parent);
        if (!SyncFileWriter.folderExists(cvsSubDir)) {
            return null;
        }
        String[] entries = SyncFileWriter.readLines(cvsSubDir.getFile(NOTIFY));
        if (entries == null) {
            return null;
        }
        TreeMap<String, NotifyInfo> infos = new TreeMap<String, NotifyInfo>();
        int i = 0;
        while (i < entries.length) {
            String line = entries[i];
            if (!"".equals(line)) {
                try {
                    NotifyInfo info = new NotifyInfo(parent, line);
                    infos.put(info.getName(), info);
                }
                catch (CVSException e) {
                    CVSProviderPlugin.log((CoreException)((Object)e));
                }
            }
            ++i;
        }
        return infos.values().toArray(new NotifyInfo[infos.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeAllNotifyInfo(IContainer parent, NotifyInfo[] infos) throws CVSException {
        IFolder cvsSubDir = SyncFileWriter.getCVSSubdirectory(parent);
        if (infos.length == 0) {
            try {
                IFile notifyFile = cvsSubDir.getFile(NOTIFY);
                if (!notifyFile.exists()) return;
                notifyFile.delete(0, null);
                return;
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        } else {
            String[] entries = new String[infos.length];
            int i = 0;
            while (i < infos.length) {
                NotifyInfo info = infos[i];
                entries[i] = info.getNotifyLine();
                ++i;
            }
            SyncFileWriter.writeLines(cvsSubDir.getFile(NOTIFY), entries);
        }
    }

    public static BaserevInfo[] readAllBaserevInfo(IContainer parent) throws CVSException {
        IFolder cvsSubDir = SyncFileWriter.getCVSSubdirectory(parent);
        if (!SyncFileWriter.folderExists(cvsSubDir)) {
            return null;
        }
        String[] entries = SyncFileWriter.readLines(cvsSubDir.getFile(BASEREV));
        if (entries == null) {
            return null;
        }
        TreeMap<String, BaserevInfo> infos = new TreeMap<String, BaserevInfo>();
        int i = 0;
        while (i < entries.length) {
            String line = entries[i];
            if (!"".equals(line)) {
                BaserevInfo info = new BaserevInfo(line);
                infos.put(info.getName(), info);
            }
            ++i;
        }
        return infos.values().toArray(new BaserevInfo[infos.size()]);
    }

    public static void writeAllBaserevInfo(IContainer parent, BaserevInfo[] infos) throws CVSException {
        IFolder cvsSubDir = SyncFileWriter.getCVSSubdirectory(parent);
        String[] entries = new String[infos.length];
        int i = 0;
        while (i < infos.length) {
            BaserevInfo info = infos[i];
            entries[i] = info.getEntryLine();
            ++i;
        }
        SyncFileWriter.writeLines(cvsSubDir.getFile(BASEREV), entries);
    }

    private static IFolder getCVSSubdirectory(IContainer folder) {
        return folder.getFolder((IPath)new Path(CVS_DIRNAME));
    }

    private static IFolder createCVSSubdirectory(IContainer folder) throws CVSException {
        try {
            final IFolder cvsSubDir = SyncFileWriter.getCVSSubdirectory(folder);
            if (!cvsSubDir.exists()) {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        if (!cvsSubDir.exists()) {
                            cvsSubDir.create(2048, true, null);
                        } else if (!cvsSubDir.isTeamPrivateMember()) {
                            cvsSubDir.setTeamPrivateMember(true);
                        }
                    }
                }, (ISchedulingRule)folder, 0, null);
            }
            return cvsSubDir;
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFirstLine(IFile file) throws CVSException {
        try {
            String string;
            BufferedReader reader;
            block12: {
                block11: {
                    reader = null;
                    if (file.exists()) {
                        reader = new BufferedReader(new InputStreamReader(file.getContents(true)), 512);
                    } else {
                        File ioFile = file.getLocation().toFile();
                        if (ioFile.exists()) {
                            reader = new BufferedReader(new InputStreamReader(new FileInputStream(ioFile)), 512);
                        }
                    }
                    if (reader == null) {
                        return null;
                    }
                    try {
                        String line = reader.readLine();
                        if (line == null) {
                            Object var3_5 = null;
                            break block11;
                        }
                        string = line;
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var3_7 = null;
                        reader.close();
                        throw throwable;
                    }
                }
                reader.close();
                return "";
            }
            Object var3_6 = null;
            reader.close();
            return string;
        }
        catch (IOException e) {
            throw CVSException.wrapException(e);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() != 368 && e.getStatus().getCode() != 271) {
                throw CVSException.wrapException(e);
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] readLines(IFile file) throws CVSException {
        try {
            String[] stringArray;
            BufferedReader reader = null;
            if (file.exists()) {
                reader = new BufferedReader(new InputStreamReader(file.getContents(true)));
            } else {
                File ioFile = file.getLocation().toFile();
                if (ioFile.exists()) {
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(ioFile)), 512);
                }
            }
            if (reader == null) {
                return null;
            }
            ArrayList<String> fileContentStore = new ArrayList<String>();
            try {
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        stringArray = fileContentStore.toArray(new String[fileContentStore.size()]);
                        Object var4_7 = null;
                        break;
                    }
                    fileContentStore.add(line);
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            return stringArray;
        }
        catch (IOException e) {
            throw CVSException.wrapException(e);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() != 368 && e.getStatus().getCode() != 271) {
                throw CVSException.wrapException(e);
            }
            return null;
        }
    }

    private static void writeLines(final IFile file, final String[] contents) throws CVSException {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        SyncFileWriter.writeLinesToStreamAndClose(os, contents);
                        if (!file.exists()) {
                            file.create((InputStream)new ByteArrayInputStream(os.toByteArray()), 1, null);
                        } else {
                            file.setContents((InputStream)new ByteArrayInputStream(os.toByteArray()), 1, null);
                        }
                        file.setSessionProperty(MODSTAMP_KEY, (Object)new Long(file.getModificationStamp()));
                    }
                    catch (CVSException e) {
                        throw new CoreException(e.getStatus());
                    }
                }
            }, ResourcesPlugin.getWorkspace().getRuleFactory().createRule((IResource)file), 0, null);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeLinesToStreamAndClose(OutputStream os, String[] contents) throws CVSException {
        byte[] lineEnd = SyncFileWriter.getLineDelimiter();
        try {
            try {
                int i = 0;
                while (i < contents.length) {
                    os.write(contents[i].getBytes());
                    os.write(lineEnd);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                os.close();
                throw throwable;
            }
            {
                Object var4_7 = null;
                os.close();
                return;
            }
        }
        catch (IOException e) {
            throw CVSException.wrapException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFileToBaseDirectory(IFile file, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        try {
            try {
                IFile target;
                IFolder baseFolder = SyncFileWriter.getBaseDirectory(file);
                if (!baseFolder.exists()) {
                    baseFolder.create(false, true, Policy.subMonitorFor(monitor, 10));
                }
                if ((target = baseFolder.getFile((IPath)new Path(null, file.getName()))).exists()) {
                    SyncFileWriter.setReadOnly(target, false);
                    target.delete(true, Policy.subMonitorFor(monitor, 10));
                }
                file.copy(target.getFullPath(), true, Policy.subMonitorFor(monitor, 80));
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void restoreFileFromBaseDirectory(IFile file, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        try {
            try {
                IFolder baseFolder = SyncFileWriter.getBaseDirectory(file);
                IFile source = baseFolder.getFile((IPath)new Path(null, file.getName()));
                if (!source.exists()) {
                    throw new CVSException(NLS.bind((String)CVSMessages.SyncFileWriter_baseNotAvailable, (Object[])new String[]{file.getFullPath().toString()}));
                }
                if (file.exists()) {
                    file.delete(false, true, Policy.subMonitorFor(monitor, 10));
                }
                SyncFileWriter.setReadOnly(source, false);
                source.move(file.getFullPath(), false, true, Policy.subMonitorFor(monitor, 100));
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        monitor.done();
    }

    private static void setReadOnly(IFile source, boolean readOnly) {
        ResourceAttributes attrs = source.getResourceAttributes();
        if (attrs.isReadOnly() != readOnly) {
            attrs.setReadOnly(readOnly);
            try {
                source.setResourceAttributes(attrs);
            }
            catch (CoreException e) {
                CVSProviderPlugin.log(e);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteFileFromBaseDirectory(IFile file, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        try {
            try {
                IFolder baseFolder = SyncFileWriter.getBaseDirectory(file);
                IFile source = baseFolder.getFile((IPath)new Path(null, file.getName()));
                if (source.exists()) {
                    SyncFileWriter.setReadOnly(source, false);
                    source.delete(false, false, Policy.subMonitorFor(monitor, 100));
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        monitor.done();
    }

    private static IFolder getBaseDirectory(IFile file) {
        IFolder cvsFolder = SyncFileWriter.getCVSSubdirectory(file.getParent());
        IFolder baseFolder = cvsFolder.getFolder((IPath)new Path(BASE_DIRNAME));
        return baseFolder;
    }

    public static IFile getTemplateFile(IContainer folder) throws CVSException {
        IFolder cvsFolder = SyncFileWriter.createCVSSubdirectory(folder);
        return cvsFolder.getFile("Template");
    }

    public static boolean isEdited(IFile file) {
        IFolder baseFolder = SyncFileWriter.getBaseDirectory(file);
        IFile baseFile = baseFolder.getFile(file.getName());
        return baseFile.exists();
    }

    private static byte[] getLineDelimiter() {
        String property;
        if (CVSProviderPlugin.getPlugin().isUsePlatformLineend() && (property = System.getProperty("line.separator")) != null) {
            return property.getBytes();
        }
        return new byte[]{10};
    }
}

