/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile.validator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentAdapter;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredTextReconcilingStrategy;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ReconcileStepForValidator;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorMetaData;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ValidatorStrategy
extends StructuredTextReconcilingStrategy {
    private String[] fContentTypeIds = null;
    private List fMetaData = new ArrayList();
    private HashMap fVidToVStepMap = null;
    private ProjectConfiguration fProjectConfiguration = null;
    private List fTotalScopeValidatorsAlreadyRun;

    public ValidatorStrategy(ISourceViewer sourceViewer, String contentType) {
        super(sourceViewer);
        this.fContentTypeIds = this.calculateParentContentTypeIds(contentType);
        this.fVidToVStepMap = new HashMap();
    }

    public void addValidatorMetaData(ValidatorMetaData vmd) {
        this.fMetaData.add(vmd);
    }

    public void beginProcessing() {
        if (this.fTotalScopeValidatorsAlreadyRun == null) {
            this.fTotalScopeValidatorsAlreadyRun = new ArrayList();
        }
    }

    private String[] calculateParentContentTypeIds(String contentTypeId) {
        HashSet<String> parentTypes = new HashSet<String>();
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        IContentType ct = ctManager.getContentType(contentTypeId);
        String id = contentTypeId;
        while (ct != null && id != null) {
            parentTypes.add(id);
            ct = ctManager.getContentType(id);
            if (ct == null) continue;
            IContentType baseType = ct.getBaseType();
            String string = id = baseType != null ? baseType.getId() : null;
        }
        return parentTypes.toArray(new String[parentTypes.size()]);
    }

    protected boolean canHandlePartition(String partitionType) {
        ValidatorMetaData vmd = null;
        int i = 0;
        while (i < this.fMetaData.size()) {
            vmd = (ValidatorMetaData)this.fMetaData.get(i);
            if (vmd.canHandlePartitionType(this.getContentTypeIds(), partitionType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean containsStep(IReconcileStep step) {
        return this.fVidToVStepMap.containsValue(step);
    }

    public void createReconcileSteps() {
    }

    public void endProcessing() {
        this.fTotalScopeValidatorsAlreadyRun.clear();
    }

    public String[] getContentTypeIds() {
        return this.fContentTypeIds;
    }

    public void reconcile(ITypedRegion tr, DirtyRegion dr) {
        if (this.isCanceled()) {
            return;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return;
        }
        String partitionType = tr.getType();
        ValidatorMetaData vmd = null;
        ArrayList<IReconcileResult> annotationsToAdd = new ArrayList<IReconcileResult>();
        ArrayList<ReconcileStepForValidator> stepsRanOnThisDirtyRegion = new ArrayList<ReconcileStepForValidator>(1);
        int i = 0;
        while (i < this.fMetaData.size() && !this.isCanceled()) {
            vmd = (ValidatorMetaData)this.fMetaData.get(i);
            if (vmd.canHandlePartitionType(this.getContentTypeIds(), partitionType) && this.isValidatorEnabled(vmd)) {
                int validatorScope = vmd.getValidatorScope();
                ReconcileStepForValidator validatorStep = null;
                Object o = this.fVidToVStepMap.get(vmd.getValidatorId());
                if (o != null) {
                    validatorStep = (ReconcileStepForValidator)o;
                } else {
                    IValidator validator = vmd.createValidator();
                    validatorStep = new ReconcileStepForValidator(validator, validatorScope);
                    validatorStep.setInputModel(new DocumentAdapter(doc));
                    this.fVidToVStepMap.put(vmd.getValidatorId(), validatorStep);
                }
                if (!this.fTotalScopeValidatorsAlreadyRun.contains(vmd)) {
                    annotationsToAdd.addAll(Arrays.asList(validatorStep.reconcile(dr, (IRegion)dr)));
                    stepsRanOnThisDirtyRegion.add(validatorStep);
                    if (validatorScope == 0) {
                        this.fTotalScopeValidatorsAlreadyRun.add(vmd);
                    }
                }
            }
            ++i;
        }
        TemporaryAnnotation[] annotationsToRemove = this.getAnnotationsToRemove(dr, stepsRanOnThisDirtyRegion);
        if (annotationsToRemove.length + annotationsToAdd.size() > 0) {
            this.smartProcess(annotationsToRemove, annotationsToAdd.toArray(new IReconcileResult[annotationsToAdd.size()]));
        }
    }

    public void release() {
        super.release();
        Iterator it = this.fVidToVStepMap.values().iterator();
        IReconcileStep step = null;
        while (it.hasNext()) {
            step = (IReconcileStep)it.next();
            if (!(step instanceof IReleasable)) continue;
            ((IReleasable)step).release();
        }
    }

    public void setDocument(IDocument document) {
        super.setDocument(document);
        Iterator it = this.fVidToVStepMap.values().iterator();
        IReconcileStep step = null;
        while (it.hasNext()) {
            step = (IReconcileStep)it.next();
            step.setInputModel((IReconcilableModel)new DocumentAdapter(document));
        }
    }

    private boolean isValidatorEnabled(ValidatorMetaData vmd) {
        boolean enabled = true;
        ProjectConfiguration configuration = this.getProjectConfiguration();
        org.eclipse.wst.validation.internal.ValidatorMetaData metadata = ValidationRegistryReader.getReader().getValidatorMetaData(vmd.getValidatorClass());
        if (configuration != null && metadata != null && !configuration.isBuildEnabled(metadata) && !configuration.isManualEnabled(metadata)) {
            enabled = false;
        }
        return enabled;
    }

    private ProjectConfiguration getProjectConfiguration() {
        IProject project;
        IFile file;
        if (this.fProjectConfiguration == null && (file = this.getFile()) != null && (project = file.getProject()) != null) {
            try {
                this.fProjectConfiguration = ConfigurationManager.getManager().getProjectConfiguration(project);
            }
            catch (InvocationTargetException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
        return this.fProjectConfiguration;
    }

    /*
     * Exception decompiling
     */
    private IFile getFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 101->104)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

