/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.server.PHPServerUIMessages;
import org.eclipse.php.server.ui.ApplicationFileSelectionDialog;
import org.eclipse.php.server.ui.ProjectSelectionDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.dialogs.ResourceSorter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ServerUtilities {
    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getShell() {
        return ServerUtilities.getStandardDisplay().getActiveShell();
    }

    public static void openError(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = ServerUtilities.getShell();
                MessageDialog.openError((Shell)shell, (String)PHPServerUIMessages.getString("ServerUtilities.error"), (String)string);
            }
        });
    }

    public static void openError(final String string, final IStatus iStatus) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = ServerUtilities.getShell();
                ErrorDialog.openError((Shell)shell, (String)PHPServerUIMessages.getString("ServerUtilities.error"), (String)string, (IStatus)iStatus);
            }
        });
    }

    public static void openError(Shell shell, String string) {
        MessageDialog.openError((Shell)shell, (String)PHPServerUIMessages.getString("ServerUtilities.error"), (String)string);
    }

    public static void openError(Shell shell, String string, IStatus iStatus) {
        ErrorDialog.openError((Shell)shell, (String)PHPServerUIMessages.getString("ServerUtilities.error"), (String)string, (IStatus)iStatus);
    }

    public static String getProjectFromDialog(Shell shell, String[] stringArray) {
        ProjectSelectionDialog projectSelectionDialog = new ProjectSelectionDialog(shell, stringArray, PHPServerUIMessages.getString("ServerUtilities.projects"), PHPServerUIMessages.getString("ServerUtilities.selectProject"));
        projectSelectionDialog.open();
        Object[] objectArray = projectSelectionDialog.getResult();
        String string = null;
        if (objectArray != null && objectArray.length > 0) {
            Object object = objectArray[0];
            IPath iPath = null;
            if (object instanceof IPath) {
                iPath = (IPath)objectArray[0];
            } else if (object instanceof IProject) {
                iPath = ((IProject)object).getFullPath();
            }
            string = iPath.makeRelative().toString();
        }
        return string;
    }

    public static IResource getFileFromDialog(IProject iProject, Shell shell, String[] stringArray, String[] stringArray2) {
        Object[] objectArray;
        ServerUtilities serverUtilities;
        ServerUtilities serverUtilities2 = serverUtilities = new ServerUtilities();
        serverUtilities2.getClass();
        ApplicationFileSelectionDialog applicationFileSelectionDialog = new ApplicationFileSelectionDialog(shell, (ILabelProvider)serverUtilities2.new WebLaunchLabelProvider(), PHPServerUIMessages.getString("ServerUtilities.selectFile"), PHPServerUIMessages.getString("ServerUtilities.selectProjectFile"), stringArray, stringArray2, false);
        if (iProject != null) {
            applicationFileSelectionDialog.setInput(iProject);
            applicationFileSelectionDialog.setInitialSelection(iProject);
        } else {
            objectArray = ResourcesPlugin.getWorkspace().getRoot();
            applicationFileSelectionDialog.setInput(objectArray);
            applicationFileSelectionDialog.setInitialSelection(objectArray);
        }
        applicationFileSelectionDialog.setAllowMultiple(false);
        applicationFileSelectionDialog.setSorter((ViewerSorter)new ResourceSorter(2));
        applicationFileSelectionDialog.open();
        if (applicationFileSelectionDialog.getReturnCode() == 0) {
            objectArray = applicationFileSelectionDialog.getResult();
            Object object = objectArray[0];
            return (IResource)object;
        }
        return null;
    }

    private class WebLaunchLabelProvider
    extends WorkbenchLabelProvider {
        private WebLaunchLabelProvider() {
        }

        protected String decorateText(String string, Object object) {
            if (object instanceof IFile) {
                IFile iFile = (IFile)object;
                String string2 = iFile.getName();
                return string2;
            }
            return string;
        }
    }
}

