/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.exporter.ui;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.converter.ui.ModelConverterDescriptorSelectionPage;
import org.eclipse.emf.converter.ui.contribution.ModelConverterManager;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.exporter.ExporterPlugin;
import org.eclipse.emf.exporter.ui.contribution.ModelExporterDescriptor;
import org.eclipse.emf.exporter.ui.contribution.ModelExporterManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class EMFExportWizard
extends Wizard
implements IWorkbenchWizard {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected IFile modelFile;
    protected ModelConverterDescriptorSelectionPage selectionPage;

    public EMFExportWizard() {
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(ExporterPlugin.INSTANCE.getString("_UI_ExportModelWizard_title"));
    }

    public EMFExportWizard(IFile modelFile) {
        this();
        this.modelFile = modelFile;
    }

    public void dispose() {
        this.selection = null;
        this.workbench = null;
        if (this.selectionPage != null) {
            this.selectionPage.clearCache();
            this.selectionPage = null;
        }
        super.dispose();
    }

    protected ImageDescriptor getDefaultImageDescriptor() {
        return ExtendedImageRegistry.INSTANCE.getImageDescriptor(ExporterPlugin.INSTANCE.getImage("ExportModel"));
    }

    public void addPages() {
        this.selectionPage = new SelectionPage("ModelExporterDescriptorSelectionPage", this.workbench, this.selection);
        this.selectionPage.setTitle(ExporterPlugin.INSTANCE.getString("_UI_SelectModelExporters_title"));
        this.selectionPage.setModeConverterWizardDefaultImageDescriptor(this.getDefaultImageDescriptor());
        this.addPage((IWizardPage)this.selectionPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.init();
    }

    protected void init() {
        this.setDefaultPageImageDescriptor(this.getDefaultImageDescriptor());
    }

    protected List getModelExporterDescriptors() {
        return ModelExporterManager.INSTANCE.getModelConverterDescriptors();
    }

    protected void adjustModelExporterWizard(IWorkbenchWizard workbenchWizard, ModelExporterDescriptor modelExporterDescriptor) {
    }

    public boolean canFinish() {
        return false;
    }

    public boolean performFinish() {
        this.selectionPage.performFinish();
        return true;
    }

    public class SelectionPage
    extends ModelConverterDescriptorSelectionPage {
        public SelectionPage(String pageId, IWorkbench workbench, IStructuredSelection selection) {
            super(pageId, (ModelConverterManager)ModelExporterManager.INSTANCE, workbench, selection);
        }

        protected Object[] getTableInput() {
            return EMFExportWizard.this.getModelExporterDescriptors().toArray();
        }

        protected String getSelectModelConverterLabel() {
            return ExporterPlugin.INSTANCE.getString("_UI_SelectModelExporters_label");
        }

        public void setModelExporterDescriptor(ModelExporterDescriptor modelExporterDescriptor) {
            this.setModelConverterDescriptor(modelExporterDescriptor);
        }

        public ModelExporterDescriptor getModelExporterDescriptor() {
            return (ModelExporterDescriptor)this.getModelConverterDescriptor();
        }

        protected void adjustModelConverterWizard(IWizard modelConverterWizard) {
            EMFExportWizard.this.adjustModelExporterWizard((IWorkbenchWizard)modelConverterWizard, this.getModelExporterDescriptor());
        }

        protected String getNoModelConverterMessage() {
            return ExporterPlugin.INSTANCE.getString("_UI_NoModelExporters_error");
        }
    }
}

