/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.project.options.includepath;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.internal.resources.XMLWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.php.core.project.IIncludePathEntry;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.core.util.Messages;
import org.w3c.dom.Element;

public class IncludePathEntry
implements IIncludePathEntry {
    public static final String TAG_INCLUDEPATH = "includepath";
    public static final String TAG_INCLUDEPATHENTRY = "includepathentry";
    public static final String TAG_ENTRY_KIND = "kind";
    public static final String TAG_CONTENT_KIND = "contentKind";
    public static final String TAG_PATH = "path";
    public static final String TAG_RESOURCE = "resource";
    public static final String TAG_ROOTPATH = "rootpath";
    public static final String TAG_EXPORTED = "exported";
    public static final String TAG_CREATEDREFERENCE = "createdReference";
    public int entryKind;
    public int contentKind;
    public IPath path;
    public IResource resource;
    public boolean isExported;
    private boolean createdReference;

    public IncludePathEntry(int n, int n2, IPath iPath, IResource iResource, boolean bl) {
        this.contentKind = n;
        this.entryKind = n2;
        this.path = iPath;
        this.resource = iResource;
        this.isExported = bl;
    }

    public int getContentKind() {
        return this.contentKind;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public IPath getPath() {
        return this.path;
    }

    public IResource getResource() {
        return this.resource;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public static IIncludePathEntry elementDecode(Element element, PHPProjectOptions pHPProjectOptions) {
        IPath iPath = pHPProjectOptions.getProject().getFullPath();
        String string = element.getAttribute(TAG_ENTRY_KIND);
        String string2 = element.getAttribute(TAG_CONTENT_KIND);
        String string3 = element.getAttribute(TAG_PATH);
        String string4 = element.getAttribute(TAG_RESOURCE);
        String string5 = element.getAttribute(TAG_CREATEDREFERENCE);
        "true".equalsIgnoreCase(string5);
        Path path = new Path(string3);
        int n = IncludePathEntry.entryKindFromString(string);
        if (n != 4 && n != 5 && !path.isAbsolute()) {
            path = iPath.append((IPath)path);
        }
        IProject iProject = null;
        boolean bl = element.getAttribute(TAG_EXPORTED).equals("true");
        IIncludePathEntry iIncludePathEntry = null;
        switch (n) {
            case 2: {
                iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string4);
                iIncludePathEntry = IncludePathEntry.newProjectEntry((IPath)path, (IResource)iProject, bl);
                break;
            }
            case 1: {
                iIncludePathEntry = new IncludePathEntry(IncludePathEntry.contentKindFromString(string2), 1, (IPath)path, (IResource)iProject, bl);
                break;
            }
            case 3: {
                iIncludePathEntry = IncludePathEntry.newSourceEntry((IPath)path, iProject);
                break;
            }
            case 4: {
                iIncludePathEntry = IncludePathEntry.newVariableEntry((IPath)path, iProject, bl);
                break;
            }
            case 5: {
                iIncludePathEntry = IncludePathEntry.newContainerEntry((IPath)path, iProject, bl);
                break;
            }
            default: {
                throw new AssertionError((Object)Messages.bind(Messages.includePath_unknownKind, string));
            }
        }
        return iIncludePathEntry;
    }

    public static IIncludePathEntry newProjectEntry(IPath iPath, IResource iResource, boolean bl) {
        if (!iPath.isAbsolute()) {
            throw new IllegalArgumentException("Path for IIncludePathEntry must be absolute");
        }
        return new IncludePathEntry(1, 2, iPath, iResource, bl);
    }

    public static IIncludePathEntry newContainerEntry(IPath iPath, IResource iResource, boolean bl) {
        if (iPath == null) {
            throw new IllegalArgumentException("Container path cannot be null");
        }
        if (iPath.segmentCount() < 1) {
            throw new IllegalArgumentException("Illegal include path container path: '" + iPath.makeRelative().toString() + "', must have at least one segment (containerID+hints)");
        }
        return new IncludePathEntry(1, 5, iPath, iResource, bl);
    }

    public static IIncludePathEntry newVariableEntry(IPath iPath, IResource iResource, boolean bl) {
        if (iPath == null) {
            throw new IllegalArgumentException("Variable path cannot be null");
        }
        if (iPath.segmentCount() < 1) {
            throw new IllegalArgumentException("Illegal classpath variable path: '" + iPath.makeRelative().toString() + "', must have at least one segment");
        }
        return new IncludePathEntry(1, 4, iPath, iResource, bl);
    }

    public static IIncludePathEntry newSourceEntry(IPath iPath, IResource iResource) {
        if (iPath == null) {
            throw new IllegalArgumentException("Source path cannot be null");
        }
        if (!iPath.isAbsolute()) {
            throw new IllegalArgumentException("Path for IIncludePathEntry must be absolute");
        }
        return new IncludePathEntry(1, 3, iPath, iResource, false);
    }

    public void elementEncode(XMLWriter xMLWriter, IPath iPath, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(TAG_ENTRY_KIND, IncludePathEntry.entryKindToString(this.entryKind));
        hashMap.put(TAG_CONTENT_KIND, IncludePathEntry.contentKindToString(this.contentKind));
        hashMap.put(TAG_CREATEDREFERENCE, this.createdReference ? "true" : "false");
        IPath iPath2 = this.path;
        if (this.entryKind != 4 && this.entryKind != 5 && iPath != null && iPath.isPrefixOf(iPath2)) {
            if (iPath2.segment(0).equals(iPath.segment(0))) {
                iPath2 = iPath2.removeFirstSegments(1);
                iPath2 = iPath2.makeRelative();
            } else {
                iPath2 = iPath2.makeAbsolute();
            }
        }
        hashMap.put(TAG_PATH, String.valueOf(iPath2));
        if (this.resource != null) {
            hashMap.put(TAG_RESOURCE, this.resource.getName());
        }
        if (this.isExported) {
            hashMap.put(TAG_EXPORTED, "true");
        }
        xMLWriter.printTag(TAG_INCLUDEPATHENTRY, hashMap);
        xMLWriter.endTag(TAG_INCLUDEPATHENTRY);
    }

    public static void updateProjectReferences(IIncludePathEntry[] iIncludePathEntryArray, IIncludePathEntry[] iIncludePathEntryArray2, IProject iProject, SubProgressMonitor subProgressMonitor) {
        try {
            String string;
            boolean bl = false;
            IProjectDescription iProjectDescription = iProject.getDescription();
            ArrayList<IProject> arrayList = new ArrayList<IProject>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            IProject[] iProjectArray = iProjectDescription.getReferencedProjects();
            int n = 0;
            while (n < iProjectArray.length) {
                arrayList.add(iProjectArray[n]);
                arrayList2.add(iProjectArray[n].getName());
                ++n;
            }
            n = 0;
            while (n < iIncludePathEntryArray2.length) {
                int n2;
                if (iIncludePathEntryArray2[n].getEntryKind() == 2 && !IncludePathEntry.containsProject(iIncludePathEntryArray, string = iIncludePathEntryArray2[n].getPath().lastSegment()) && ((IncludePathEntry)iIncludePathEntryArray2[n]).createdReference && (n2 = arrayList2.indexOf(string)) >= 0) {
                    bl = true;
                    arrayList2.remove(n2);
                    arrayList.remove(n2);
                }
                ++n;
            }
            n = 0;
            while (n < iIncludePathEntryArray.length) {
                if (iIncludePathEntryArray[n].getEntryKind() == 2 && !IncludePathEntry.containsProject(iIncludePathEntryArray2, string = iIncludePathEntryArray[n].getPath().lastSegment()) && !arrayList2.contains(string)) {
                    bl = true;
                    ((IncludePathEntry)iIncludePathEntryArray[n]).createdReference = true;
                    arrayList.add(ResourcesPlugin.getWorkspace().getRoot().getProject(string));
                    arrayList2.add(string);
                }
                ++n;
            }
            if (bl) {
                IProject[] iProjectArray2 = arrayList.toArray(new IProject[arrayList.size()]);
                iProjectDescription.setReferencedProjects(iProjectArray2);
                iProject.setDescription(iProjectDescription, (IProgressMonitor)subProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private static boolean containsProject(IIncludePathEntry[] iIncludePathEntryArray, String string) {
        int n = 0;
        while (n < iIncludePathEntryArray.length) {
            if (iIncludePathEntryArray[n].getEntryKind() == 2 && iIncludePathEntryArray[n].getPath().lastSegment().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static int entryKindFromString(String string) {
        if (string.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (string.equalsIgnoreCase("var")) {
            return 4;
        }
        if (string.equalsIgnoreCase("con")) {
            return 5;
        }
        if (string.equalsIgnoreCase("src")) {
            return 3;
        }
        if (string.equalsIgnoreCase("lib")) {
            return 1;
        }
        return -1;
    }

    static String entryKindToString(int n) {
        switch (n) {
            case 2: {
                return "prj";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "con";
            }
        }
        return "unknown";
    }

    static int contentKindFromString(String string) {
        if (string.equalsIgnoreCase("binary")) {
            return 2;
        }
        if (string.equalsIgnoreCase("source")) {
            return 1;
        }
        return -1;
    }

    static String contentKindToString(int n) {
        switch (n) {
            case 2: {
                return "binary";
            }
            case 1: {
                return "source";
            }
        }
        return "unknown";
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            IncludePathEntry includePathEntry = (IncludePathEntry)object;
            if (includePathEntry.entryKind != this.entryKind || includePathEntry.contentKind != this.contentKind) {
                return false;
            }
            return this.path.equals((Object)includePathEntry.path);
        }
        return false;
    }

    public String validate() {
        String string = null;
        switch (this.entryKind) {
            case 2: {
                if (this.resource != null && this.resource.exists()) break;
                string = "included project not found: " + this.path.toOSString();
                break;
            }
            case 1: {
                File file;
                if (this.resource != null && this.resource.exists() || (file = new File(this.path.toOSString())).exists()) break;
                string = "included library not found: " + this.path.toOSString();
                break;
            }
            case 3: {
                if (this.resource != null && this.resource.exists()) break;
                string = "included source not found: " + this.path.toOSString();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new AssertionError((Object)Messages.bind(Messages.includePath_unknownKind, ""));
            }
        }
        return string;
    }

    public void setResource(IResource iResource) {
        this.resource = iResource;
    }
}

