/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.preferences;

import java.io.File;

public class PHPexeItem {
    private static final String[] fgCandidatePHPLocations = new String[]{"php", "php.exe"};
    String name;
    File location;
    File phpEXE;
    String version;
    boolean editable = true;

    public PHPexeItem(String string, String string2) {
        this.name = string;
        this.setLocation(new File(string2));
    }

    public PHPexeItem(String string, File file, boolean bl) {
        this.name = string;
        this.phpEXE = file;
        this.editable = bl;
        this.location = file.getParentFile();
    }

    public PHPexeItem() {
    }

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File file) {
        this.location = file;
        this.phpEXE = PHPexeItem.findPHPExecutable(file);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public static File findPHPExecutable(File file) {
        int n = 0;
        while (n < fgCandidatePHPLocations.length) {
            File file2 = new File(file, fgCandidatePHPLocations[n]);
            if (file2.isFile()) {
                return file2;
            }
            ++n;
        }
        return null;
    }

    public File getPhpEXE() {
        return this.phpEXE;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PHPexeItem)) {
            return false;
        }
        PHPexeItem pHPexeItem = (PHPexeItem)object;
        return pHPexeItem.name.equals(this.name) && pHPexeItem.location.equals(this.location);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public boolean isEditable() {
        return this.editable;
    }
}

