/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.util.collections;

public class IntList
implements Cloneable {
    private int minimumSize;
    private int[] data;
    private int size;

    public IntList() {
        this(5);
    }

    public IntList(int n) {
        this.data = new int[n];
        this.minimumSize = n;
        this.size = -1;
    }

    public IntList(int[] nArray) {
        this.data = nArray;
        this.minimumSize = nArray.length;
        this.size = nArray.length;
    }

    public boolean isEmpty() {
        return this.size == -1;
    }

    public int top() {
        return this.data[this.size];
    }

    public int popStack() {
        int n = this.data[this.size];
        --this.size;
        this.reductListSize();
        return n;
    }

    public int remove(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("index must be at range 0.." + this.size + ". got index " + n);
        }
        int n2 = this.data[n];
        int n3 = n;
        while (n3 < this.size) {
            this.data[n3] = this.data[n3 + 1];
            ++n3;
        }
        --this.size;
        this.reductListSize();
        return n2;
    }

    public void pushStack(int n) {
        ++this.size;
        this.verifySizeBeforeAdding();
        this.data[this.size] = n;
    }

    public void add(int n, int n2) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("index must be at range 0.." + this.size + ". got index " + n);
        }
        ++this.size;
        this.verifySizeBeforeAdding();
        int n3 = this.size;
        while (n3 > n) {
            this.data[n3] = this.data[n3 - 1];
            --n3;
        }
        this.data[n] = n2;
    }

    public void add(int n) {
        this.pushStack(n);
    }

    public int get(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("index must be at range 0.." + this.size + ". got index " + n);
        }
        return this.data[n];
    }

    public int clear() {
        this.size = -1;
        return -1;
    }

    public int size() {
        return this.size + 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof IntList)) {
            return false;
        }
        IntList intList = (IntList)object;
        if (this.size != intList.size) {
            return false;
        }
        int n = this.size;
        while (n >= 0) {
            if (this.data[n] != intList.data[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    private void verifySizeBeforeAdding() {
        int n = this.data.length;
        if (this.size == this.data.length) {
            int[] nArray = new int[n * 2];
            System.arraycopy(this.data, 0, nArray, 0, n);
            this.data = nArray;
        }
    }

    private void reductListSize() {
        if (this.size / 4 < this.data.length) {
            int n = Math.max(this.size / 2, this.minimumSize);
            int[] nArray = new int[n];
            System.arraycopy(this.data, 0, nArray, 0, this.size + 1);
            this.data = nArray;
        }
    }

    public void copyFrom(IntList intList) {
        this.size = intList.size;
        int n = 0;
        while (n <= intList.size) {
            this.add(intList.data[n]);
            ++n;
        }
    }

    public boolean contains(int n) {
        int n2 = 0;
        while (n2 <= this.size) {
            if (this.data[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        int n = 0;
        while (n <= this.size) {
            stringBuffer.append(" stack[" + n + "]= " + this.data[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        IntList intList = new IntList(this.size());
        intList.copyFrom(this);
        return intList;
    }

    public int[] toIntArray() {
        int[] nArray = new int[this.size()];
        return this.toIntArray(nArray);
    }

    public int[] toIntArray(int[] nArray) {
        int n = 0;
        while (n <= this.size) {
            nArray[n] = this.data[n];
            ++n;
        }
        return nArray;
    }

    public static Iterator createIterator() {
        return new Iterator();
    }

    public void startIterating(Iterator iterator) {
        iterator.lastIndex = this.size;
    }

    public boolean hasNext(Iterator iterator) {
        return iterator.lastIndex != -1;
    }

    public int next(Iterator iterator) {
        return this.data[iterator.lastIndex--];
    }

    public static class Iterator {
        int lastIndex = -1;
    }
}

