/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.contentassist;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;

public class PHPContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private IContextInformation fInformation;
    private ITextViewer fViewer;
    private int fPosition;
    private int fCurrentParameter;

    public void install(IContextInformation iContextInformation, ITextViewer iTextViewer, int n) {
        this.fInformation = iContextInformation;
        this.fViewer = iTextViewer;
        this.fPosition = n;
        this.fCurrentParameter = -1;
    }

    private int getCommentEnd(IDocument iDocument, int n, int n2) throws BadLocationException {
        while (n < n2) {
            char c = iDocument.getChar(n);
            if (c != '*' || ++n >= n2 || iDocument.getChar(n) != '/') continue;
            return n + 1;
        }
        return n2;
    }

    private int getStringEnd(IDocument iDocument, int n, int n2, char c) throws BadLocationException {
        while (n < n2) {
            char c2 = iDocument.getChar(n);
            ++n;
            if (c2 == '\\') {
                ++n;
                continue;
            }
            if (c2 != c) continue;
            return n;
        }
        return n2;
    }

    private int getCharCount(IDocument iDocument, int n, int n2, String string, String string2, boolean bl) throws BadLocationException {
        Assert.isTrue(((string.length() != 0 || string2.length() != 0) && !string.equals(string2) ? 1 : 0) != 0);
        int n3 = 0;
        int n4 = 0;
        block5: while (n < n2) {
            char c = iDocument.getChar(n++);
            switch (c) {
                case '/': {
                    if (n >= n2) continue block5;
                    char c2 = iDocument.getChar(n);
                    if (c2 == '*') {
                        n = this.getCommentEnd(iDocument, n + 1, n2);
                        break;
                    }
                    if (c2 != '/') continue block5;
                    n = n2;
                    break;
                }
                case '*': {
                    char c2;
                    if (n >= n2 || (c2 = iDocument.getChar(n)) != '/') continue block5;
                    n4 = 0;
                    ++n;
                    break;
                }
                case '\"': 
                case '\'': {
                    n = this.getStringEnd(iDocument, n, n2, c);
                    break;
                }
                default: {
                    if (bl) {
                        if ('(' == c) {
                            ++n3;
                        } else if (')' == c) {
                            --n3;
                        }
                        if (n3 != 0) continue block5;
                    }
                    if (string.indexOf(c) >= 0) {
                        ++n4;
                    }
                    if (string2.indexOf(c) < 0) continue block5;
                    --n4;
                }
            }
        }
        return n4;
    }

    public boolean isContextInformationValid(int n) {
        IDocument iDocument;
        block5: {
            block4: {
                try {
                    if (n >= this.fPosition) break block4;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            iDocument = this.fViewer.getDocument();
            IRegion iRegion = iDocument.getLineInformationOfOffset(this.fPosition);
            if (n >= iRegion.getOffset() && n < iDocument.getLength()) break block5;
            return false;
        }
        return this.getCharCount(iDocument, this.fPosition, n, "(<", ")>", false) >= 0;
    }

    public boolean updatePresentation(int n, TextPresentation textPresentation) {
        int n2;
        int n3 = -1;
        try {
            n3 = this.getCharCount(this.fViewer.getDocument(), this.fPosition, n, ",", "", true);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (this.fCurrentParameter != -1 && n3 == this.fCurrentParameter) {
            return false;
        }
        textPresentation.clear();
        this.fCurrentParameter = n3;
        String string = this.fInformation.getInformationDisplayString();
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.fCurrentParameter) {
            n2 = string.indexOf(44, n4);
            if (n2 == -1) break;
            n4 = n2 + 1;
            ++n5;
        }
        if (n5 < this.fCurrentParameter) {
            textPresentation.addStyleRange(new StyleRange(0, string.length(), null, null, 0));
            return true;
        }
        if (n4 == -1) {
            n4 = 0;
        }
        if ((n2 = string.indexOf(44, n4)) == -1) {
            n2 = string.length();
        }
        if (n4 > 0) {
            textPresentation.addStyleRange(new StyleRange(0, n4, null, null, 0));
        }
        if (n2 > n4) {
            textPresentation.addStyleRange(new StyleRange(n4, n2 - n4, null, null, 1));
        }
        if (n2 < string.length()) {
            textPresentation.addStyleRange(new StyleRange(n2, string.length() - n2, null, null, 0));
        }
        return true;
    }
}

