/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.osgi.framework.Bundle;

public class Logger {
    private static final String PLUGIN_ID = PHPDebugPlugin.getID();
    private static final String TRACEFILTER_LOCATION = "/debug/tracefilter";
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static final int OK_DEBUG = 200;
    public static final int INFO_DEBUG = 201;
    public static final int WARNING_DEBUG = 202;
    public static final int ERROR_DEBUG = 204;

    protected static void _log(int n, String string, Throwable throwable) {
        if (!(n != 200 && n != 201 && n != 202 && n != 204 || Logger.isDebugging())) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case 1: 
            case 201: {
                n2 = 1;
                break;
            }
            case 2: 
            case 202: {
                n2 = 2;
                break;
            }
            case 4: 
            case 204: {
                n2 = 4;
            }
        }
        string = string != null ? string : "null";
        Status status = new Status(n2, PLUGIN_ID, n2, string, throwable);
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        if (bundle != null) {
            Platform.getLog((Bundle)bundle).log((IStatus)status);
        }
        Logger.debugMSG(status.toString());
    }

    protected static void _trace(String string, String string2, Throwable throwable) {
        if (Logger.isTracing(string)) {
            string2 = string2 != null ? string2 : "null";
            Status status = new Status(0, PLUGIN_ID, 0, string2, throwable);
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            if (bundle != null) {
                Platform.getLog((Bundle)bundle).log((IStatus)status);
            }
        }
    }

    public static boolean isDebugging() {
        return Platform.inDebugMode();
    }

    public static boolean isTracing(String string) {
        if (!Logger.isDebugging()) {
            return false;
        }
        String string2 = Platform.getDebugOption((String)(String.valueOf(PLUGIN_ID) + TRACEFILTER_LOCATION));
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                if (!string.equals(string3)) continue;
                return true;
            }
        }
        return false;
    }

    public static void log(int n, String string) {
        Logger._log(n, string, null);
    }

    public static void log(int n, String string, Throwable throwable) {
        Logger._log(n, string, throwable);
    }

    public static void logException(String string, Throwable throwable) {
        Logger._log(4, string, throwable);
    }

    public static void logException(Throwable throwable) {
        Logger._log(4, throwable.getMessage(), throwable);
    }

    public static void traceException(String string, String string2, Throwable throwable) {
        Logger._trace(string, string2, throwable);
    }

    public static void traceException(String string, Throwable throwable) {
        Logger._trace(string, throwable.getMessage(), throwable);
    }

    public static void trace(String string, String string2) {
        Logger._trace(string, string2, null);
    }

    public static void debugMSG(String string) {
        if (PHPDebugPlugin.DebugPHP) {
            System.out.println(string);
        }
    }
}

