/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.wizards;

import java.util.regex.Pattern;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.eclipse.wst.xsd.ui.internal.wizards.RegexCompositionPage;

public class RegexTestingPage
extends WizardPage {
    private Label matchLabel;
    private Text value;
    private StyledText testString;

    public RegexTestingPage() {
        super(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TESTING_PAGE_TITLE"));
        this.setTitle(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TESTING_PAGE_TITLE"));
        this.setDescription(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TESTING_PAGE_DESCRIPTION"));
    }

    public void createControl(Composite parent) {
        Composite composite = ViewUtility.createComposite(parent, 1);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0200");
        this.matchLabel = new Label(composite, 64);
        this.matchLabel.setText(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TESTING_PAGE_DESCRIPTION"));
        FontData[] fontData = this.matchLabel.getFont().getFontData();
        GridData dataF = new GridData();
        dataF.widthHint = 400;
        dataF.heightHint = 6 * fontData[0].getHeight();
        this.matchLabel.setLayoutData((Object)dataF);
        Composite controls = new Composite(composite, 0);
        GridLayout controlsLayout = new GridLayout();
        controlsLayout.numColumns = 2;
        controls.setLayout((Layout)controlsLayout);
        controls.setLayoutData((Object)new GridData(768));
        new Label(controls, 16384).setText(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_REGEX_LABEL"));
        this.value = new Text(controls, 2056);
        this.value.setLayoutData((Object)new GridData(768));
        new Label(controls, 16384).setText(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_SAMPLE_TEXT"));
        this.testString = new StyledText(controls, 2052);
        WorkbenchHelp.setHelp((Control)this.testString, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0210");
        this.testString.addListener(24, (Listener)new TestStringListener());
        this.testString.setLayoutData((Object)new GridData(768));
        controls.pack();
        Label separator = new Label(composite, 258);
        GC gc = new GC((Drawable)separator);
        Point pointSize = gc.stringExtent(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TESTING_PAGE_DESCRIPTION"));
        GridData gd = new GridData();
        gd.widthHint = pointSize.x / 2 + gc.getAdvanceWidth('M') * 11;
        gd.horizontalAlignment = 4;
        separator.setLayoutData((Object)gd);
        composite.pack();
        this.setControl((Control)composite);
    }

    private String getPatternValue() {
        return ((RegexCompositionPage)this.getPreviousPage()).getPattern().getLexicalValue();
    }

    private String getFlags() {
        return ((RegexCompositionPage)this.getPreviousPage()).getFlags();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        String pattern = this.getPatternValue();
        this.getFlags();
        this.value.setText(pattern);
        this.updateMatchStatus();
        this.testString.setFocus();
    }

    private void updateMatchStatus() {
        if (Pattern.matches(this.getPatternValue(), this.testString.getText())) {
            this.setMessage(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_MATCHES"), 1);
        } else {
            this.setMessage(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_DOES_NOT_MATCH"), 2);
        }
    }

    class TestStringListener
    implements Listener {
        TestStringListener() {
        }

        public void handleEvent(Event e) {
            RegexTestingPage.this.updateMatchStatus();
        }
    }
}

